/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.uibinding;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.eclipse.riena.internal.core.test.collect.UITestCase;
import org.eclipse.riena.ui.ridgets.ILabelRidget;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.IRidgetContainer;
import org.eclipse.riena.ui.ridgets.IStatuslineRidget;
import org.eclipse.riena.ui.ridgets.ITextRidget;
import org.eclipse.riena.ui.ridgets.SubModuleUtils;
import org.eclipse.riena.ui.ridgets.swt.SwtRidgetFactory;
import org.eclipse.riena.ui.ridgets.uibinding.CorrespondingLabelMapper;
import org.eclipse.riena.ui.ridgets.uibinding.ICorrespondingLabelExtension;
import org.eclipse.riena.ui.ridgets.uibinding.ILabelFinderStrategy;
import org.eclipse.riena.ui.ridgets.uibinding.ILabelFinderStrategyExtension;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.riena.ui.swt.utils.UIControlsFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

@UITestCase
public class CorrespondingLabelManagerTest
extends TestCase {
    private CorrespondingLabelMapper labelMapper;
    private static final String FIRSTNAME_LABEL_ID = "labelfirstName";
    private static final String FIRSTNAME_TEXT_ID = "firstName";
    private static final String LASTNAME_LABEL_ID = "lbllastName";
    private static final String LASTNAME_TEXT_ID = "lastName";
    private static final String AGE_LABEL_ID = "fooage";
    private static final String AGE_TEXT_ID = "age";
    private ILabelRidget lblFirstName;
    private ITextRidget txtFirstName;
    private ILabelRidget lblLastName;
    private ITextRidget txtLastName;
    private ILabelRidget lblAge;
    private ITextRidget txtAge;
    private ILabelRidget lblDummyFinder;
    private Shell shell;
    private boolean isPrepareView;

    protected void setUp() throws Exception {
        super.setUp();
        this.isPrepareView = SubModuleUtils.isPrepareView();
        System.setProperty("riena.prepare.view", "true");
        StubRidgetContainer ridgetContainer = new StubRidgetContainer();
        this.shell = new Shell();
        this.lblFirstName = (ILabelRidget)SwtRidgetFactory.createRidget((Object)UIControlsFactory.createLabel((Composite)this.shell, (String)"FirstName", (int)0, (String)FIRSTNAME_LABEL_ID));
        this.txtFirstName = (ITextRidget)SwtRidgetFactory.createRidget((Object)UIControlsFactory.createText((Composite)this.shell, (int)0, (String)FIRSTNAME_TEXT_ID));
        this.lblLastName = (ILabelRidget)SwtRidgetFactory.createRidget((Object)UIControlsFactory.createLabel((Composite)this.shell, (String)"LastName", (int)0, (String)LASTNAME_LABEL_ID));
        this.txtLastName = (ITextRidget)SwtRidgetFactory.createRidget((Object)UIControlsFactory.createText((Composite)this.shell, (int)0, (String)LASTNAME_TEXT_ID));
        this.lblLastName = (ILabelRidget)SwtRidgetFactory.createRidget((Object)UIControlsFactory.createLabel((Composite)this.shell, (String)"LastName", (int)0, (String)LASTNAME_LABEL_ID));
        this.txtLastName = (ITextRidget)SwtRidgetFactory.createRidget((Object)UIControlsFactory.createText((Composite)this.shell, (int)0, (String)LASTNAME_TEXT_ID));
        this.lblAge = (ILabelRidget)SwtRidgetFactory.createRidget((Object)UIControlsFactory.createLabel((Composite)this.shell, (String)"Age", (int)0, (String)AGE_LABEL_ID));
        this.txtAge = (ITextRidget)SwtRidgetFactory.createRidget((Object)UIControlsFactory.createText((Composite)this.shell, (int)0, (String)AGE_TEXT_ID));
        ridgetContainer.addRidget(FIRSTNAME_LABEL_ID, (IRidget)this.lblFirstName);
        ridgetContainer.addRidget(FIRSTNAME_TEXT_ID, (IRidget)this.txtFirstName);
        ridgetContainer.addRidget(LASTNAME_LABEL_ID, (IRidget)this.lblLastName);
        ridgetContainer.addRidget(LASTNAME_TEXT_ID, (IRidget)this.txtLastName);
        ridgetContainer.addRidget(AGE_LABEL_ID, (IRidget)this.lblAge);
        ridgetContainer.addRidget(AGE_TEXT_ID, (IRidget)this.txtAge);
        CorrespondingLabelMapper.setCorrespondingLabelConfig(null);
        CorrespondingLabelMapper.setLabelFinderStrategy(null);
        this.labelMapper = new CorrespondingLabelMapper((IRidgetContainer)ridgetContainer);
    }

    protected void tearDown() throws Exception {
        SwtUtilities.dispose((Widget)this.shell);
        this.shell = null;
        System.setProperty("riena.prepare.view", String.valueOf(this.isPrepareView));
        super.tearDown();
    }

    public void testConnectCorrespondingLabel() throws Exception {
        boolean foundLabel = this.labelMapper.connectCorrespondingLabel((IRidget)this.txtFirstName, FIRSTNAME_TEXT_ID);
        CorrespondingLabelManagerTest.assertTrue((boolean)foundLabel);
        CorrespondingLabelManagerTest.assertTrue((boolean)this.txtFirstName.isEnabled());
        CorrespondingLabelManagerTest.assertTrue((boolean)this.txtLastName.isEnabled());
        this.txtFirstName.setEnabled(false);
        CorrespondingLabelManagerTest.assertFalse((boolean)this.lblFirstName.isEnabled());
        CorrespondingLabelManagerTest.assertTrue((boolean)this.lblLastName.isEnabled());
        CorrespondingLabelManagerTest.assertTrue((boolean)this.lblAge.isEnabled());
    }

    public void testConnectCorrespondingLabelLabelNotFound() throws Exception {
        boolean foundLabel = this.labelMapper.connectCorrespondingLabel((IRidget)this.txtLastName, LASTNAME_TEXT_ID);
        CorrespondingLabelManagerTest.assertFalse((boolean)foundLabel);
    }

    public void testCustomLabelFinderStrategy() throws Exception {
        this.lblDummyFinder = (ILabelRidget)SwtRidgetFactory.createRidget((Object)UIControlsFactory.createLabel((Composite)this.shell, (String)"Dummy", (int)2048, (String)LASTNAME_TEXT_ID));
        CorrespondingLabelMapper.setLabelFinderStrategy((ILabelFinderStrategyExtension)new StubLabelFinderStrategyProperties());
        boolean foundLabel = this.labelMapper.connectCorrespondingLabel((IRidget)this.txtLastName, LASTNAME_TEXT_ID);
        CorrespondingLabelManagerTest.assertTrue((boolean)foundLabel);
        CorrespondingLabelManagerTest.assertTrue((boolean)this.lblDummyFinder.isEnabled());
        CorrespondingLabelManagerTest.assertTrue((boolean)this.txtLastName.isEnabled());
        this.txtLastName.setEnabled(false);
        CorrespondingLabelManagerTest.assertFalse((boolean)this.lblDummyFinder.isEnabled());
        CorrespondingLabelManagerTest.assertTrue((boolean)this.lblFirstName.isEnabled());
        CorrespondingLabelManagerTest.assertTrue((boolean)this.lblLastName.isEnabled());
        CorrespondingLabelManagerTest.assertTrue((boolean)this.lblAge.isEnabled());
    }

    public void testCustomLabelPrefix() throws Exception {
        CorrespondingLabelMapper.setCorrespondingLabelConfig((ICorrespondingLabelExtension)new ICorrespondingLabelExtension(){

            public String getLabelPrefix() {
                return "foo";
            }
        });
        boolean foundLabel = this.labelMapper.connectCorrespondingLabel((IRidget)this.txtAge, AGE_TEXT_ID);
        CorrespondingLabelManagerTest.assertTrue((boolean)foundLabel);
        CorrespondingLabelManagerTest.assertTrue((boolean)this.txtLastName.isEnabled());
        CorrespondingLabelManagerTest.assertTrue((boolean)this.lblAge.isEnabled());
        this.txtAge.setEnabled(false);
        CorrespondingLabelManagerTest.assertFalse((boolean)this.lblAge.isEnabled());
        CorrespondingLabelManagerTest.assertTrue((boolean)this.lblFirstName.isEnabled());
        CorrespondingLabelManagerTest.assertTrue((boolean)this.lblLastName.isEnabled());
    }

    private class DummyLabelFinderStrategy
    implements ILabelFinderStrategy {
        private DummyLabelFinderStrategy() {
        }

        public ILabelRidget findLabelRidget(IRidgetContainer ridgetContainer, String ridgetID) {
            System.out.println("CorrespondingLabelManagerTest.DummyLabelFinderStrategy.findLabelRidget()");
            return CorrespondingLabelManagerTest.this.lblDummyFinder;
        }
    }

    private class StubLabelFinderStrategyProperties
    implements ILabelFinderStrategyExtension {
        private StubLabelFinderStrategyProperties() {
        }

        public String getClassName() {
            return "org.eclipse.riena.ui.ridgets.uibinding.CorrespondingLabelManagerTest.DummyLabelFinderStrategy";
        }

        public ILabelFinderStrategy createFinderStrategy() {
            return new DummyLabelFinderStrategy();
        }
    }

    private static class StubRidgetContainer
    implements IRidgetContainer {
        private final Map<String, IRidget> ridgets = new HashMap<String, IRidget>();

        public void addRidget(String id, IRidget ridget) {
            this.ridgets.put(id, ridget);
        }

        public boolean removeRidget(String id) {
            return this.ridgets.remove(id) != null;
        }

        public <R extends IRidget> R getRidget(String id) {
            return (R)this.ridgets.get(id);
        }

        public Collection<? extends IRidget> getRidgets() {
            return this.ridgets.values();
        }

        public void configureRidgets() {
        }

        public <R extends IRidget> R getRidget(Class<R> ridgetClazz, String id) {
            return this.getRidget(id);
        }

        public boolean isConfigured() {
            return false;
        }

        public void setConfigured(boolean configured) {
        }

        public void setStatuslineToShowMarkerMessages(IStatuslineRidget statuslineToShowMarkerMessages) {
        }
    }
}

