/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.swt;

import org.eclipse.riena.ui.swt.facades.SWTFacade;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

public class MultilineButton
extends Button {
    private final GC gc = new GC((Drawable)this);

    public MultilineButton(Composite parent, int style) {
        super(parent, style);
        this.gc.setFont(this.getFont());
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.gc.setFont(font);
    }

    public void dispose() {
        this.gc.dispose();
        super.dispose();
    }

    protected void checkSubclass() {
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point fromSuper = super.computeSize(wHint, hHint, changed);
        if (this.getText() == null || (this.getStyle() & 0x40) == 0) {
            return fromSuper;
        }
        Point textSizeOneLine = this.gc.stringExtent(this.getText().replaceAll("\\r|\\n", ""));
        Point textSizeWithLineBreaks = SWTFacade.getDefault().textExtent(this.gc, this.getText(), 2);
        return new Point(fromSuper.x - textSizeOneLine.x + textSizeWithLineBreaks.x, Math.max(fromSuper.y, textSizeWithLineBreaks.y));
    }
}

