/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt.uiprocess;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.jface.window.Window;
import org.eclipse.riena.ui.swt.RienaWindowRenderer;
import org.eclipse.riena.ui.swt.lnf.LnFUpdater;
import org.eclipse.riena.ui.swt.nls.Messages;
import org.eclipse.riena.ui.swt.uiprocess.IProcessWindowListener;
import org.eclipse.riena.ui.swt.uiprocess.IUIProcessWindow;
import org.eclipse.riena.ui.swt.uiprocess.UIProcessControl;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class UIProcessWindow
extends ApplicationWindow
implements IUIProcessWindow {
    private static final int CANCEL_BUTTON_WIDTH = 70;
    private static final int PROGRESS_BAR_WIDTH = 210;
    private final LnFUpdater lnfUpdater = LnFUpdater.getInstance();
    private final UIProcessControl progressControl;
    private final Set<IProcessWindowListener> windowListeners;
    private final RienaWindowRenderer windowRenderer;
    private ProgressBar progressBar;
    private Text description;
    private Label percent;
    private Button cancelButton;
    private boolean cancelEnabled = true;
    private boolean cancelVisible = true;

    public UIProcessWindow(Shell parentShell, UIProcessControl progressControl) {
        super(parentShell);
        this.progressControl = progressControl;
        this.windowListeners = new HashSet<IProcessWindowListener>();
        this.windowRenderer = new RienaWindowRenderer((Window)this);
    }

    public void create() {
        int style = this.windowRenderer.computeShellStyle() & 0xFFFFFF7F & 0xFFFFFBFF;
        this.setShellStyle(style);
        super.create();
    }

    private void createWindowLayout(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.marginTop = 10;
        layout.marginBottom = 10;
        layout.marginLeft = 20;
        layout.marginRight = 20;
        parent.setLayout((Layout)layout);
    }

    protected Control createContents(Composite parent) {
        Control contentsComposite = this.windowRenderer.createContents(parent);
        Composite centerComposite = this.windowRenderer.getCenterComposite();
        this.createWindowLayout(centerComposite);
        this.description = new Text(centerComposite, 524362);
        GridDataFactory.fillDefaults().minSize(210, 35).grab(true, true).applyTo((Control)this.description);
        this.percent = new Label(centerComposite, 0);
        GridDataFactory.fillDefaults().align(4, 1).indent(0, 5).minSize(50, 13).grab(true, false).applyTo((Control)this.percent);
        this.progressBar = new ProgressBar(centerComposite, 256);
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(100);
        GridDataFactory.fillDefaults().minSize(210, 15).applyTo((Control)this.progressBar);
        this.cancelButton = new Button(centerComposite, 0);
        this.cancelButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                UIProcessWindow.this.progressControl.fireCanceled(false);
            }

            public void widgetSelected(SelectionEvent e) {
                UIProcessWindow.this.progressControl.fireCanceled(false);
            }
        });
        this.cancelButton.setText(Messages.UIProcessWindow_cancel);
        GridDataFactory.fillDefaults().align(0x1000000, 1).indent(0, 10).minSize(70, 0).grab(true, false).applyTo((Control)this.cancelButton);
        this.lnfUpdater.updateUIControls(centerComposite.getParent(), true);
        this.description.setBackground(centerComposite.getBackground());
        return contentsComposite;
    }

    public Label getPercent() {
        return this.percent;
    }

    public Text getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.getDescription().setText(description);
    }

    @Override
    public void closeWindow() {
        this.close();
    }

    public boolean close() {
        this.fireWindowAboutToClose();
        return super.close();
    }

    @Override
    public void openWindow() {
        this.open();
        this.cancelButton.setFocus();
    }

    public int getShellStyle() {
        return super.getShellStyle();
    }

    public void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle);
    }

    @Override
    public void addProcessWindowListener(IProcessWindowListener listener) {
        this.windowListeners.add(listener);
    }

    protected void fireWindowAboutToClose() {
        for (IProcessWindowListener listener : this.windowListeners) {
            listener.windowAboutToClose();
        }
    }

    @Override
    public ProgressBar getProgressBar() {
        return this.progressBar;
    }

    protected void createTrimWidgets(Shell shell) {
    }

    protected void setCancelVisible(boolean cancelVisible) {
        if (this.cancelVisible != cancelVisible) {
            this.cancelVisible = cancelVisible;
            if (this.cancelButton != null) {
                this.cancelButton.setVisible(cancelVisible);
            }
        }
    }

    protected void setCancelEnabled(boolean cancelEnabled) {
        if (this.cancelEnabled != cancelEnabled) {
            this.cancelEnabled = cancelEnabled;
            if (this.cancelButton != null) {
                this.cancelButton.setEnabled(cancelEnabled);
            }
        }
    }
}

