/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.compositetable;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.nebula.widgets.compositetable.HeaderLayout;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public abstract class AbstractNativeHeader
extends Composite {
    private String[] columnLabelStrings;
    private int[] columnAlignments;
    Table headerTable;
    List tableColumns;
    private HeaderLayout headerLayout;
    private int sortDirection = 0;
    private int lastSortColumn = -1;
    private boolean movable = true;
    private boolean resizable = true;
    private List columnControlListeners = new ArrayList();
    private ControlListener controlListener = new ControlAdapter(){

        public void controlResized(ControlEvent e) {
            Point size = AbstractNativeHeader.this.getSize();
            AbstractNativeHeader.this.headerTable.setBounds(0, 0, size.x, size.y);
        }
    };
    private ControlListener columnControlListener = new ControlAdapter(){

        public void controlResized(ControlEvent e) {
            Iterator i = AbstractNativeHeader.this.columnControlListeners.iterator();
            while (i.hasNext()) {
                ControlListener listener = (ControlListener)i.next();
                listener.controlResized(e);
            }
        }

        public void controlMoved(ControlEvent e) {
            Iterator i = AbstractNativeHeader.this.columnControlListeners.iterator();
            while (i.hasNext()) {
                ControlListener listener = (ControlListener)i.next();
                listener.controlMoved(e);
            }
        }
    };
    private SelectionListener columnSelectionListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            TableColumn tableColumn = (TableColumn)e.widget;
            int c = AbstractNativeHeader.this.tableColumns.indexOf(tableColumn);
            if (c != AbstractNativeHeader.this.lastSortColumn) {
                AbstractNativeHeader.this.sortDirection = 0;
            }
            if (AbstractNativeHeader.this.sortOnColumn(c, AbstractNativeHeader.this.toggleSortDirection())) {
                if (c != AbstractNativeHeader.this.lastSortColumn) {
                    AbstractNativeHeader.this.headerTable.setSortColumn(tableColumn);
                }
                AbstractNativeHeader.this.headerTable.setSortDirection(AbstractNativeHeader.this.sortDirection);
                AbstractNativeHeader.this.lastSortColumn = c;
            }
        }
    };
    private DisposeListener disposeListener = new DisposeListener(){

        public void widgetDisposed(DisposeEvent e) {
            AbstractNativeHeader header = AbstractNativeHeader.this;
            header.removeControlListener(AbstractNativeHeader.this.controlListener);
        }
    };

    public AbstractNativeHeader(Composite parent, int style) {
        super(parent, style);
        this.headerTable = new Table((Composite)this, 0);
        this.headerTable.setHeaderVisible(true);
        this.addControlListener(this.controlListener);
        this.addDisposeListener(this.disposeListener);
        this.headerLayout = new HeaderLayout();
        this.setLayout(this.headerLayout);
    }

    protected boolean sortOnColumn(int column, int sortDirection) {
        return false;
    }

    public void setMovable(boolean movable) {
        this.movable = movable;
        Iterator columnsIter = this.tableColumns.iterator();
        while (columnsIter.hasNext()) {
            TableColumn column = (TableColumn)columnsIter.next();
            column.setMoveable(movable);
        }
    }

    public boolean isMovable() {
        return this.movable;
    }

    public void setResizable(boolean resizable) {
        this.resizable = resizable;
        Iterator columnsIter = this.tableColumns.iterator();
        while (columnsIter.hasNext()) {
            TableColumn column = (TableColumn)columnsIter.next();
            column.setResizable(resizable);
        }
    }

    public boolean isResizable() {
        return this.resizable;
    }

    public void setColumnText(String[] columnTextStrings) {
        this.columnLabelStrings = columnTextStrings;
        this.columnAlignments = new int[this.columnLabelStrings.length];
        int i = 0;
        while (i < this.columnAlignments.length) {
            this.columnAlignments[i] = 16384;
            ++i;
        }
        this.initializeColumns();
    }

    public void setColumnText(String[] columnTextStrings, int[] alignments) {
        this.columnLabelStrings = columnTextStrings;
        this.columnAlignments = alignments;
        this.initializeColumns();
    }

    public TableColumn[] getColumns() {
        return this.headerTable.getColumns();
    }

    public void setSortColumn(int index) {
        if (index == -1) {
            this.headerTable.setSortColumn(null);
        } else {
            TableColumn column = this.headerTable.getColumn(index);
            this.headerTable.setSortColumn(column);
        }
        this.lastSortColumn = index;
    }

    public int indexOfSortColumn() {
        TableColumn column = this.headerTable.getSortColumn();
        return column == null ? -1 : this.headerTable.indexOf(column);
    }

    public void setSortDirection(int direction) {
        if (direction != 0 && direction != 128 && direction != 1024) {
            throw new IllegalArgumentException("direction= " + direction);
        }
        this.headerTable.setSortDirection(direction);
        this.sortDirection = direction;
    }

    public int getSortDirection() {
        return this.headerTable.getSortDirection();
    }

    public void addColumnControlListener(ControlListener c) {
        this.columnControlListeners.add(c);
    }

    public void removeColumnControlListener(ControlListener c) {
        this.columnControlListeners.remove(c);
    }

    private void initializeColumns() {
        this.tableColumns = new ArrayList();
        int i = 0;
        while (i < this.columnLabelStrings.length) {
            TableColumn column = new TableColumn(this.headerTable, this.columnAlignments[i]);
            column.setMoveable(this.movable);
            column.setResizable(this.resizable);
            column.setText(this.columnLabelStrings[i]);
            this.tableColumns.add(column);
            column.addControlListener(this.columnControlListener);
            column.addSelectionListener(this.columnSelectionListener);
            ++i;
        }
    }

    private int toggleSortDirection() {
        if (this.sortDirection == 0) {
            this.sortDirection = 1024;
        } else if (this.sortDirection == 1024) {
            this.sortDirection = 128;
        } else if (this.sortDirection == 128) {
            this.sortDirection = 1024;
        }
        return this.sortDirection;
    }

    public Point computeSize(int wHint, int hHint) {
        return this.computeSize(wHint, hHint, true);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point preferredSize = super.computeSize(wHint, hHint, changed);
        preferredSize.y = this.headerTable.getHeaderHeight();
        return preferredSize;
    }

    public int[] getWeights() {
        return this.headerLayout.getWeights();
    }

    public AbstractNativeHeader setWeights(int[] weights) {
        this.headerLayout.setWeights(weights);
        return this;
    }

    public boolean isFittingHorizontally() {
        return this.headerLayout.isFittingHorizontally();
    }

    public AbstractNativeHeader setFittingHorizontally(boolean fittingHorizontally) {
        this.headerLayout.setFittingHorizontally(fittingHorizontally);
        return this;
    }
}

