/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.compositetable;

import java.lang.reflect.Constructor;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import org.eclipse.nebula.widgets.compositetable.CompositeTable;
import org.eclipse.nebula.widgets.compositetable.EmptyTablePlaceholder;
import org.eclipse.nebula.widgets.compositetable.GridRowLayout;
import org.eclipse.nebula.widgets.compositetable.IDeleteHandler;
import org.eclipse.nebula.widgets.compositetable.IInsertHandler;
import org.eclipse.nebula.widgets.compositetable.IRowContentProvider;
import org.eclipse.nebula.widgets.compositetable.IRowFocusListener;
import org.eclipse.nebula.widgets.compositetable.RowConstructionListener;
import org.eclipse.nebula.widgets.compositetable.ScrollEvent;
import org.eclipse.nebula.widgets.compositetable.ScrollListener;
import org.eclipse.nebula.widgets.compositetable.TableRow;
import org.eclipse.nebula.widgets.compositetable.internal.DuckType;
import org.eclipse.nebula.widgets.compositetable.internal.ISelectableRegionControl;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.swt.widgets.Widget;

class InternalCompositeTable
extends Composite
implements Listener {
    private Composite controlHolder = null;
    private Composite vSliderHolder = null;
    private Slider vSlider = null;
    private Composite hScroller;
    private Composite hSliderHolder = null;
    private Slider hSlider = null;
    EmptyTablePlaceholder emptyTablePlaceholder = null;
    private CompositeTable parent;
    private int maxRowsVisible;
    private int numRowsInDisplay;
    private int numRowsInCollection;
    private int topRow;
    private int currentRow;
    private int currentColumn;
    private int currentVisibleTopRow = 0;
    private int numRowsVisible = 0;
    private LinkedList rows = new LinkedList();
    private LinkedList spareRows = new LinkedList();
    int clientAreaHeight;
    private Constructor headerConstructor;
    private Constructor rowConstructor;
    private Control headerControl;
    private Control myHeader = null;
    private Control rowControl;
    ControlAdapter scrollerResizeHandler = new ControlAdapter(){

        public void controlResized(ControlEvent e) {
            Point size = InternalCompositeTable.this.hScroller.getSize();
            int preferredWidth = ((InternalCompositeTable)InternalCompositeTable.this).controlHolder.computeSize((int)-1, (int)-1, (boolean)true).x;
            if (preferredWidth > size.x && !InternalCompositeTable.this.isHSliderVisible()) {
                InternalCompositeTable.this.setHSliderVisible(true);
            }
            if (preferredWidth <= size.x && InternalCompositeTable.this.isHSliderVisible()) {
                InternalCompositeTable.this.setHSliderVisible(false);
            }
            if (preferredWidth <= size.x) {
                InternalCompositeTable.this.controlHolder.setBounds(0, 0, size.x, size.y);
                return;
            }
            if (InternalCompositeTable.this.isHSliderVisible()) {
                InternalCompositeTable.this.hSlider.setMaximum(preferredWidth);
                InternalCompositeTable.this.hSlider.setPageIncrement(size.x);
                InternalCompositeTable.this.hSlider.setThumb(preferredWidth - (preferredWidth - size.x));
                int currentSelection = InternalCompositeTable.this.hSlider.getSelection();
                if (preferredWidth - currentSelection < size.x) {
                    InternalCompositeTable.this.hSlider.setSelection(preferredWidth - size.x);
                }
            }
            InternalCompositeTable.this.hSlider.notifyListeners(13, new Event());
        }
    };
    private boolean vSliderVisible = false;
    private boolean hSliderVisible = false;
    private boolean needToRequestRC = true;
    private Listener displayKeyDownFilter = new Listener(){

        public void handleEvent(Event event) {
            if (InternalCompositeTable.this.rowControl.getClass().isAssignableFrom(event.widget.getClass())) {
                InternalCompositeTable.this.doMakeFocusedRowVisible();
            }
        }
    };
    private SelectionListener sliderSelectionListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            Control control;
            if (InternalCompositeTable.this.vSlider.getSelection() == InternalCompositeTable.this.topRow) {
                return;
            }
            if (!InternalCompositeTable.this.fireRequestRowChangeEvent()) {
                InternalCompositeTable.this.vSlider.setSelection(InternalCompositeTable.this.topRow);
                return;
            }
            InternalCompositeTable.this.deselectCurrentRowIfVisible();
            int delta = InternalCompositeTable.this.topRow - InternalCompositeTable.this.vSlider.getSelection();
            int oldCurrentRow = InternalCompositeTable.this.currentRow;
            InternalCompositeTable.this.currentRow = InternalCompositeTable.this.vSlider.getSelection();
            InternalCompositeTable.this.doSetTopRow(InternalCompositeTable.this.vSlider.getSelection(), InternalCompositeTable.this.currentRow + delta);
            if (oldCurrentRow < 0 || oldCurrentRow >= InternalCompositeTable.this.getNumRowsVisible()) {
                if (InternalCompositeTable.this.currentRow >= 0 && InternalCompositeTable.this.currentRow < InternalCompositeTable.this.getNumRowsVisible()) {
                    Control newFocusControl = InternalCompositeTable.this.getControl(InternalCompositeTable.this.currentColumn, InternalCompositeTable.this.currentRow);
                    if (newFocusControl == null) {
                        return;
                    }
                    if (newFocusControl.isFocusControl()) {
                        newFocusControl.notifyListeners(15, new Event());
                    } else {
                        InternalCompositeTable.this.deferredSetFocus(newFocusControl, true);
                    }
                }
            } else if ((InternalCompositeTable.this.currentRow < 0 || InternalCompositeTable.this.currentRow >= InternalCompositeTable.this.getNumRowsVisible()) && (control = InternalCompositeTable.this.getControl(InternalCompositeTable.this.currentColumn, oldCurrentRow)) != null) {
                control.notifyListeners(16, new Event());
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }
    };
    private SelectionListener hSliderSelectionListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            Point scrollerSize = InternalCompositeTable.this.hScroller.getSize();
            int preferredWidth = ((InternalCompositeTable)InternalCompositeTable.this).controlHolder.computeSize((int)-1, (int)-1, (boolean)true).x;
            Rectangle controlHolderBounds = new Rectangle(-1 * InternalCompositeTable.this.hSlider.getSelection(), 0, preferredWidth, scrollerSize.y);
            InternalCompositeTable.this.controlHolder.setBounds(controlHolderBounds);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }
    };
    private PaintListener headerPaintListener = new PaintListener(){

        public void paintControl(PaintEvent e) {
            if (((InternalCompositeTable)InternalCompositeTable.this).parent.linesVisible) {
                InternalCompositeTable.this.drawGridLines(e, true);
            }
        }
    };
    private PaintListener rowPaintListener = new PaintListener(){

        public void paintControl(PaintEvent e) {
            if (((InternalCompositeTable)InternalCompositeTable.this).parent.linesVisible) {
                InternalCompositeTable.this.drawGridLines(e, false);
            }
        }
    };
    private Menu menu = null;
    static /* synthetic */ Class class$0;

    public InternalCompositeTable(Composite parentControl, int style) {
        super(parentControl, style);
        this.initialize();
        this.parent = (CompositeTable)parentControl;
        this.setBackground(parentControl.getBackground());
        this.controlHolder.addListener(37, (Listener)this);
        this.maxRowsVisible = this.parent.getMaxRowsVisible();
        this.numRowsInCollection = this.parent.getNumRowsInCollection();
        this.topRow = this.parent.getTopRow();
        this.headerConstructor = this.parent.getHeaderConstructor();
        this.rowConstructor = this.parent.getRowConstructor();
        this.headerControl = this.parent.getHeaderControl();
        this.rowControl = this.parent.getRowControl();
        this.setMenu(this.parent.getMenu());
        this.currentVisibleTopRow = this.topRow;
        this.showHeader();
        this.updateVisibleRows();
        if (this.numRowsVisible < 1) {
            this.createEmptyTablePlaceholer();
        }
        this.currentRow = -1;
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.controlHolder.setBackground(color);
    }

    private void initialize() {
        int borderInPixels;
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        gl.verticalSpacing = 0;
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        gl.marginRight = borderInPixels = this.getParent().getBorderWidth() * 2;
        gl.marginBottom = borderInPixels;
        gl.horizontalSpacing = 0;
        this.setLayout((Layout)gl);
        this.createControlHolder();
        this.createVSliderHolder();
        this.createHSliderHolder();
    }

    private void createControlHolder() {
        this.hScroller = new Composite((Composite)this, 0);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.verticalAlignment = 4;
        this.hScroller.setLayoutData((Object)gridData);
        this.controlHolder = new Composite(this.hScroller, 0);
        this.controlHolder.setLayout(new Layout(){

            protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
                if (InternalCompositeTable.this.rowControl != null) {
                    int height = 0;
                    int width = 0;
                    if (InternalCompositeTable.this.headerControl != null) {
                        Point headerSize = InternalCompositeTable.this.headerControl.computeSize(wHint, hHint, flushCache);
                        width = headerSize.x;
                        height = headerSize.y;
                    }
                    Point rowSize = InternalCompositeTable.this.rowControl.computeSize(wHint, hHint, flushCache);
                    height += rowSize.y * 2;
                    if (width < rowSize.x) {
                        width = rowSize.x;
                    }
                    return new Point(width, height);
                }
                return new Point(50, 50);
            }

            protected void layout(Composite composite, boolean flushCache) {
                InternalCompositeTable.this.layoutControlHolder();
            }
        });
        this.hScroller.addControlListener((ControlListener)this.scrollerResizeHandler);
    }

    private void createVSliderHolder() {
        GridData gd = this.getVSliderGridData();
        this.vSliderHolder = new Composite((Composite)this, 0);
        this.vSlider = new Slider(this.vSliderHolder, 512);
        this.vSlider.addSelectionListener(this.sliderSelectionListener);
        this.vSliderHolder.setLayout((Layout)new FillLayout());
        this.vSliderHolder.setLayoutData((Object)gd);
        this.vSliderHolder.setTabList(new Control[0]);
    }

    private void createHSliderHolder() {
        GridData gd = this.getHSliderGridData();
        this.hSliderHolder = new Composite((Composite)this, 0);
        this.hSlider = new Slider(this.hSliderHolder, 256);
        this.hSlider.setMinimum(0);
        this.hSlider.setIncrement(20);
        this.hSlider.addSelectionListener(this.sliderSelectionListener);
        this.hSliderHolder.setLayout((Layout)new FillLayout());
        this.hSliderHolder.setLayoutData((Object)gd);
        this.hSliderHolder.setTabList(new Control[0]);
        this.hSlider.addSelectionListener(this.hSliderSelectionListener);
    }

    private GridData getVSliderGridData() {
        GridData gd = new GridData();
        gd.grabExcessVerticalSpace = true;
        gd.verticalAlignment = 4;
        gd.verticalSpan = 1;
        if (!this.vSliderVisible) {
            gd.widthHint = 0;
        }
        return gd;
    }

    private GridData getHSliderGridData() {
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.horizontalSpan = 1;
        if (!this.hSliderVisible) {
            gd.heightHint = 0;
        }
        return gd;
    }

    public void setVSliderVisible(boolean visible) {
        this.vSliderVisible = visible;
        this.vSliderHolder.setLayoutData((Object)this.getVSliderGridData());
        if (visible) {
            Display.getCurrent().addFilter(1, this.displayKeyDownFilter);
        } else {
            Display.getCurrent().removeFilter(1, this.displayKeyDownFilter);
        }
        Display.getCurrent().asyncExec(new Runnable(){

            public void run() {
                if (!(InternalCompositeTable.this.isDisposed() || InternalCompositeTable.this.vSliderHolder.isDisposed() || InternalCompositeTable.this.vSliderHolder.getParent().isDisposed())) {
                    InternalCompositeTable.this.vSliderHolder.getParent().layout(true);
                    InternalCompositeTable.this.vSliderHolder.layout(true);
                    Point sliderHolderSize = InternalCompositeTable.this.vSliderHolder.getSize();
                    InternalCompositeTable.this.vSlider.setBounds(0, 0, sliderHolderSize.x, sliderHolderSize.y);
                }
            }
        });
    }

    public boolean isVSliderVisible() {
        return this.vSliderVisible;
    }

    public void setHSliderVisible(boolean visible) {
        this.hSliderVisible = visible;
        this.hSliderHolder.setLayoutData((Object)this.getHSliderGridData());
        Display.getCurrent().asyncExec(new Runnable(){

            public void run() {
                if (!(InternalCompositeTable.this.isDisposed() || InternalCompositeTable.this.hSliderHolder.isDisposed() || InternalCompositeTable.this.hSliderHolder.getParent().isDisposed())) {
                    InternalCompositeTable.this.hSliderHolder.getParent().layout(true);
                    InternalCompositeTable.this.hSliderHolder.layout(true);
                    Point sliderHolderSize = InternalCompositeTable.this.hSliderHolder.getSize();
                    InternalCompositeTable.this.hSlider.setBounds(0, 0, sliderHolderSize.x, sliderHolderSize.y);
                }
            }
        });
    }

    public boolean isHSliderVisible() {
        return this.hSliderVisible;
    }

    public void dispose() {
        this.disposeRows(this.rows);
        this.disposeRows(this.spareRows);
        super.dispose();
    }

    private void disposeRows(LinkedList rowsCollection) {
        Iterator rowsIter = rowsCollection.iterator();
        while (rowsIter.hasNext()) {
            TableRow row = (TableRow)rowsIter.next();
            if (row instanceof IRowFocusListener) {
                this.parent.removeRowFocusListener((IRowFocusListener)((Object)row));
            }
            if (row instanceof IRowContentProvider) {
                this.parent.removeRowContentProvider((IRowContentProvider)((Object)row));
            }
            row.dispose();
        }
    }

    protected void layoutControlHolder() {
        if (this.myHeader != null) {
            this.layoutHeaderOrRow(this.myHeader);
        }
        Iterator rowsIter = this.rows.iterator();
        while (rowsIter.hasNext()) {
            TableRow row = (TableRow)rowsIter.next();
            this.layoutHeaderOrRow(row.getRowControl());
        }
        this.updateVisibleRows();
    }

    private void layoutHeaderOrRow(Control control) {
        if (control instanceof Composite) {
            Composite headerOrRow = (Composite)control;
            headerOrRow.layout(true);
        }
    }

    private Control createInternalControl(Composite parent, Constructor constructor) {
        Control result = null;
        try {
            if (!constructor.isAccessible()) {
                constructor.setAccessible(true);
            }
            result = (Control)constructor.newInstance(parent, new Integer(0));
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Unable to construct control");
        }
        if (result instanceof IRowFocusListener) {
            this.parent.addRowFocusListener((IRowFocusListener)result);
        }
        if (result instanceof IRowContentProvider) {
            this.parent.addRowContentProvider((IRowContentProvider)result);
        }
        return result;
    }

    private void showHeader() {
        if (this.myHeader == null && this.headerConstructor != null) {
            Composite headerComp;
            this.myHeader = this.createInternalControl(this.controlHolder, this.headerConstructor);
            this.fireHeaderConstructionEvent(this.myHeader);
            if (this.myHeader instanceof Composite && (headerComp = (Composite)this.myHeader).getLayout() instanceof GridRowLayout) {
                headerComp.addPaintListener(this.headerPaintListener);
            }
            this.layoutHeaderOrRow(this.myHeader);
        }
    }

    void updateVisibleRows() {
        if (this.rowControl == null) {
            return;
        }
        this.clientAreaHeight = this.controlHolder.getSize().y;
        if (this.clientAreaHeight <= 0) {
            return;
        }
        int topPosition = 0;
        int headerHeight = 0;
        if (this.myHeader != null) {
            headerHeight = this.headerControl.getSize().y + 3;
            this.clientAreaHeight -= headerHeight;
            topPosition += headerHeight;
        }
        this.numRowsInDisplay = this.clientAreaHeight / this.getRowHeight(this.clientAreaHeight);
        int userScrollDirection = 0;
        if (this.numRowsInCollection > 0) {
            this.numRowsVisible = this.numRowsInDisplay;
            this.disposeEmptyTablePlaceholder();
            int displayableRows = this.numRowsInCollection - this.topRow;
            if (this.numRowsVisible > displayableRows) {
                this.numRowsVisible = displayableRows;
            }
            if (this.numRowsVisible > this.maxRowsVisible) {
                this.numRowsVisible = this.maxRowsVisible;
            }
            if (this.numRowsVisible < 1) {
                this.numRowsVisible = 1;
            }
            if (this.currentVisibleTopRow - this.topRow > 0) {
                userScrollDirection = -1;
            } else if (this.topRow - this.currentVisibleTopRow > 0) {
                userScrollDirection = 1;
            }
            if (this.rows.size() - Math.abs(this.currentVisibleTopRow - this.topRow) > 0) {
                this.scrollTop();
                this.fixNumberOfRows();
            } else {
                this.currentVisibleTopRow = this.topRow;
                this.fixNumberOfRows();
                this.refreshAllRows();
            }
        } else {
            this.numRowsVisible = 0;
            this.topRow = 0;
            this.currentRow = 0;
            this.currentColumn = 0;
            this.currentVisibleTopRow = 0;
            this.numRowsVisible = 0;
            if (this.emptyTablePlaceholder == null) {
                this.fixNumberOfRows();
                this.createEmptyTablePlaceholer();
            }
        }
        if (this.currentRow >= this.numRowsVisible && this.getNumRowsVisible() < this.numRowsInDisplay) {
            this.currentRow = this.numRowsVisible - 1;
        }
        if (this.numRowsVisible < this.numRowsInCollection) {
            int pageIncrement = this.numRowsVisible;
            int extra = this.numRowsInCollection - this.numRowsVisible;
            if (pageIncrement > extra) {
                pageIncrement = extra;
            }
            this.vSlider.setMaximum(this.numRowsInCollection);
            this.vSlider.setMinimum(0);
            this.vSlider.setIncrement(1);
            this.vSlider.setPageIncrement(pageIncrement);
            this.vSlider.setThumb(this.numRowsInCollection - (this.numRowsInCollection - this.numRowsVisible));
            this.vSlider.setSelection(this.topRow);
            if (!this.isVSliderVisible()) {
                this.setVSliderVisible(true);
            }
        } else {
            this.setVSliderVisible(false);
        }
        int width = this.controlHolder.getSize().x;
        if (this.myHeader != null) {
            this.myHeader.setBounds(0, 0, width, headerHeight);
        }
        if (this.numRowsInCollection < 1) {
            return;
        }
        int rowHeight = this.getRowHeight(this.clientAreaHeight);
        if (userScrollDirection == 1 || userScrollDirection == 0) {
            Iterator rowsIter = this.rows.iterator();
            while (rowsIter.hasNext()) {
                TableRow row = (TableRow)rowsIter.next();
                Control rowControl = row.getRowControl();
                rowControl.setBounds(0, topPosition, width, rowHeight);
                this.layoutHeaderOrRow(rowControl);
                topPosition += rowHeight;
            }
        } else {
            ListIterator rowsIter = this.rows.listIterator();
            while (rowsIter.hasNext()) {
                rowsIter.next();
            }
            topPosition += rowHeight * (this.rows.size() - 1);
            while (rowsIter.hasPrevious()) {
                TableRow row = (TableRow)rowsIter.previous();
                Control rowControl = row.getRowControl();
                rowControl.setBounds(0, topPosition, width, rowHeight);
                this.layoutHeaderOrRow(rowControl);
                topPosition -= rowHeight;
            }
        }
        if (userScrollDirection != 0) {
            this.fireScrollEvent(new ScrollEvent(userScrollDirection, this.parent));
        }
    }

    int getRowHeight(int clientAreaHeight) {
        int rowControlHeight = this.rowControl.getSize().y;
        if (this.maxRowsVisible == Integer.MAX_VALUE) {
            return rowControlHeight;
        }
        return rowControlHeight;
    }

    private void scrollTop() {
        while (this.currentVisibleTopRow < this.topRow) {
            this.deleteRowAt(0);
            ++this.currentVisibleTopRow;
        }
        while (this.currentVisibleTopRow > this.topRow) {
            --this.currentVisibleTopRow;
            this.insertRowAt(0);
        }
    }

    private void fixNumberOfRows() {
        int numRows = this.rows.size();
        while (numRows > this.numRowsVisible) {
            this.deleteRowAt(numRows - 1);
            numRows = this.rows.size();
        }
        while (numRows < this.numRowsVisible) {
            this.insertRowAt(numRows);
            numRows = this.rows.size();
        }
    }

    void refreshAllRows() {
        int row = 0;
        Iterator rowsIter = this.rows.iterator();
        while (rowsIter.hasNext()) {
            TableRow rowControl = (TableRow)rowsIter.next();
            this.fireRefreshEvent(this.topRow + row, rowControl.getRowControl());
            ++row;
        }
        this.resetFocus();
    }

    void refreshRow(int row) {
        if (this.topRow > -1 && this.isRowVisible(row)) {
            this.fireRefreshEvent(row + this.topRow, ((TableRow)this.rows.get(row)).getRowControl());
        }
    }

    private boolean isRowVisible(int row) {
        return row >= 0 && row < this.numRowsVisible;
    }

    private void resetFocus() {
        if (this.numRowsVisible < 1 || this.currentRow < 0) {
            return;
        }
        Control control = null;
        if (this.currentRow < this.numRowsVisible) {
            control = this.getControl(this.currentColumn, this.currentRow);
        } else if (this.currentRow > 0) {
            control = this.getControl(this.currentColumn, this.numRowsVisible - 1);
        }
        if (control != null && control.isFocusControl()) {
            this.setFocus();
            this.deferredSetFocus(control, true);
        }
    }

    private void insertRowAt(int position) {
        TableRow newRow = this.getNewRow();
        if (position > this.rows.size()) {
            position = this.rows.size();
        }
        this.rows.add(position, newRow);
        this.fireRefreshEvent(this.currentVisibleTopRow + position, newRow.getRowControl());
    }

    private void deleteRowAt(int position) {
        TableRow row = (TableRow)this.rows.remove(position);
        row.setVisible(false);
        this.spareRows.addLast(row);
    }

    private TableRow getNewRow() {
        Composite rowComp;
        if (this.spareRows.size() > 0) {
            TableRow recycledRow = (TableRow)this.spareRows.removeFirst();
            recycledRow.setVisible(true);
            return recycledRow;
        }
        Control newControl = this.createInternalControl(this.controlHolder, this.rowConstructor);
        if (this.menu != null) {
            newControl.setMenu(this.menu);
        }
        this.fireRowConstructionEvent(newControl);
        TableRow newRow = new TableRow(this, newControl);
        if (newRow.getRowControl() instanceof Composite && (rowComp = (Composite)newRow.getRowControl()).getLayout() instanceof GridRowLayout) {
            rowComp.setBackground(this.getBackground());
            rowComp.addPaintListener(this.rowPaintListener);
        }
        return newRow;
    }

    public Control getHeaderControl() {
        return this.headerControl;
    }

    Control getHeader() {
        return this.myHeader;
    }

    public void setMaxRowsVisible(int maxRowsVisible) {
        this.maxRowsVisible = maxRowsVisible;
        this.updateVisibleRows();
    }

    public int getNumRowsVisible() {
        return this.rows.size();
    }

    public void setNumRowsInCollection(int numRowsInCollection) {
        this.topRow = 0;
        if (this.topRow + this.currentRow > numRowsInCollection) {
            if (this.topRow < numRowsInCollection) {
                this.currentRow = numRowsInCollection - this.topRow;
            } else {
                this.topRow = numRowsInCollection - 1;
                this.currentRow = 0;
            }
            this.deferredSetFocus(this.getCurrentRowControl(), false);
        }
        this.numRowsInCollection = numRowsInCollection;
        this.updateVisibleRows();
        this.refreshAllRows();
    }

    private void doSetTopRow(int topRow, int currentRow) {
        this.topRow = topRow;
        this.currentRow = currentRow;
        this.updateVisibleRows();
    }

    public void setTopRow(int topRow) {
        this.fireRowDepartEvent();
        int topRowDelta = this.topRow - topRow;
        this.doSetTopRow(topRow, this.currentRow + topRowDelta);
        this.fireRowArriveEvent();
    }

    public int getTopRow() {
        return this.topRow;
    }

    public Point getSelection() {
        return this.currentRow != -1 ? new Point(this.currentColumn, this.currentRow) : null;
    }

    public void setSelection(int column, int row) {
        int topRowDelta = this.computeTopRowDelta(row);
        if (topRowDelta != 0) {
            this.doSetTopRow(this.topRow + topRowDelta, this.currentRow);
            this.internalSetSelection(column, row += -1 * topRowDelta, true);
        } else if (row == this.currentRow) {
            this.internalSetSelection(column, row, false);
        } else if (this.fireRequestRowChangeEvent()) {
            this.internalSetSelection(column, row, true);
        }
    }

    public void clearSelection() {
        Point currentSelection = this.getSelection();
        if (currentSelection != null) {
            this.fireRowDepartEvent();
            this.currentRow = -1;
        }
    }

    public void setWeights() {
        this.layoutControlHolder();
    }

    public void addRefreshContentProvider(IRowContentProvider listener) {
        this.parent.contentProviders.add(listener);
    }

    public void removeRefreshContentProvider(IRowContentProvider listener) {
        this.parent.contentProviders.remove(listener);
    }

    private void fireRefreshEvent(int positionInCollection, Control rowControl) {
        if (this.numRowsInCollection < 1) {
            return;
        }
        Iterator refreshListenersIter = this.parent.contentProviders.iterator();
        while (refreshListenersIter.hasNext()) {
            IRowContentProvider listener = (IRowContentProvider)refreshListenersIter.next();
            listener.refresh(this.parent, positionInCollection, rowControl);
        }
    }

    private void createEmptyTablePlaceholer() {
        this.emptyTablePlaceholder = new EmptyTablePlaceholder(this.controlHolder, 0);
        if (this.rowControl != null) {
            this.emptyTablePlaceholder.setBackground(this.rowControl.getBackground());
        }
        this.emptyTablePlaceholder.setMessage(this.parent.getInsertHint());
    }

    private void disposeEmptyTablePlaceholder() {
        if (this.emptyTablePlaceholder != null) {
            this.emptyTablePlaceholder.dispose();
            this.emptyTablePlaceholder = null;
        }
    }

    public void keyPressed(TableRow sender, KeyEvent e) {
        if (this.doMakeFocusedRowVisible()) {
            return;
        }
        if ((e.stateMask & 0x40000) != 0) {
            switch (e.keyCode) {
                case 0x1000007: {
                    this.doFocusInitialRow();
                    return;
                }
                case 0x1000008: {
                    this.doFocusLastRow();
                    return;
                }
                case 0x1000009: {
                    this.doInsertRow();
                    return;
                }
                case 127: {
                    this.doDeleteRow();
                    return;
                }
            }
            return;
        }
        switch (e.keyCode) {
            case 0x1000001: {
                this.doRowUp();
                return;
            }
            case 0x1000002: {
                this.doRowDown();
                return;
            }
            case 0x1000005: {
                this.doPageUp();
                return;
            }
            case 0x1000006: {
                this.doPageDown();
                return;
            }
        }
    }

    public void keyTraversed(TableRow sender, TraverseEvent e) {
        if (this.doMakeFocusedRowVisible()) {
            return;
        }
        if (this.parent.isTraverseOnTabsEnabled()) {
            if (e.detail == 16) {
                if (this.currentColumn >= sender.getNumColumns() - 1) {
                    e.detail = 0;
                    this.handleNextRowNavigation();
                }
            } else if (e.detail == 8) {
                if (this.currentColumn == 0) {
                    e.detail = 0;
                    this.handlePreviousRowNavigation(sender);
                }
            } else if (e.detail == 4) {
                e.detail = 0;
                if (this.currentColumn >= sender.getNumColumns() - 1) {
                    this.handleNextRowNavigation();
                } else {
                    this.deferredSetFocus(this.getControl(this.currentColumn + 1, this.currentRow), false);
                }
            }
        } else if (e.detail == 16) {
            if (this.currentColumn >= sender.getNumColumns() - 1) {
                e.detail = 0;
            }
        } else if (e.detail == 8 && this.currentColumn == 0) {
            e.detail = 0;
        }
    }

    public boolean doMakeFocusedRowVisible() {
        if (this.numRowsVisible < 1) {
            return false;
        }
        int topRowDelta = this.computeTopRowDelta(this.currentRow);
        if (topRowDelta == 0) {
            return false;
        }
        this.doSetTopRow(this.topRow + topRowDelta, this.currentRow + -1 * topRowDelta);
        Control control = this.getControl(this.currentColumn, this.currentRow);
        if (control != null) {
            control.setFocus();
        }
        return true;
    }

    private int computeTopRowDelta(int row) {
        int topRowDelta;
        if (row < 0) {
            topRowDelta = row;
        } else if (row >= this.getNumRowsVisible()) {
            topRowDelta = row - this.getNumRowsVisible() + 1;
        } else {
            return 0;
        }
        return topRowDelta;
    }

    public void handleEvent(Event event) {
        event.doit = false;
        if (event.count > 0) {
            if (this.topRow > 0) {
                if (!this.fireRequestRowChangeEvent()) {
                    return;
                }
                this.deselectCurrentRowIfVisible();
                this.doSetTopRow(this.topRow - 1, this.currentRow + 1);
                if (this.isRowVisible(this.currentRow)) {
                    this.deferredSetFocus(this.getControl(this.currentColumn, this.currentRow), true);
                }
            }
        } else if (this.topRow < this.numRowsInCollection - this.numRowsVisible) {
            if (!this.fireRequestRowChangeEvent()) {
                return;
            }
            this.deselectCurrentRowIfVisible();
            this.doSetTopRow(this.topRow + 1, this.currentRow - 1);
            if (this.isRowVisible(this.currentRow)) {
                this.deferredSetFocus(this.getControl(this.currentColumn, this.currentRow), true);
            }
        }
    }

    private void deselectCurrentRowIfVisible() {
        Control control;
        if (this.currentRow >= 0 && this.currentRow < this.numRowsVisible && (control = this.getControl(this.currentColumn, this.currentRow)) != null) {
            this.deselect((Widget)control);
        }
    }

    public void focusLost(TableRow sender, FocusEvent e) {
    }

    public void focusGained(TableRow sender, FocusEvent e) {
        boolean rowChanged = false;
        int senderRowNumber = this.getRowNumber(sender);
        if (senderRowNumber != this.currentRow) {
            if (this.needToRequestRC) {
                if (!this.fireRequestRowChangeEvent()) {
                    this.deferredSetFocus(this.getControl(this.currentColumn, this.currentRow), false);
                }
            } else {
                this.needToRequestRC = true;
            }
            rowChanged = true;
        }
        this.currentRow = senderRowNumber;
        this.currentColumn = sender.getColumnNumber((Control)e.widget);
        if (rowChanged) {
            this.fireRowArriveEvent();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void drawGridLines(PaintEvent e, boolean isHeader) {
        Color oldColor = e.gc.getForeground();
        try {
            Display display = Display.getCurrent();
            Color lineColor = display.getSystemColor(17);
            Color secondaryColor = display.getSystemColor(18);
            Color hilightColor = display.getSystemColor(20);
            if (!isHeader) {
                lineColor = display.getSystemColor(19);
            }
            Control toPaint = (Control)e.widget;
            Point controlSize = toPaint.getSize();
            e.gc.setForeground(lineColor);
            e.gc.drawLine(0, controlSize.y - 1, controlSize.x, controlSize.y - 1);
            if (isHeader) {
                e.gc.setForeground(secondaryColor);
                e.gc.drawLine(0, controlSize.y - 2, controlSize.x, controlSize.y - 2);
                e.gc.setForeground(hilightColor);
                e.gc.drawLine(0, 1, controlSize.x, 1);
            }
            if (toPaint instanceof Composite) {
                Composite row = (Composite)toPaint;
                Control[] children = row.getChildren();
                int i = 0;
                while (i < children.length) {
                    Rectangle childBounds = children[i].getBounds();
                    if (isHeader) {
                        e.gc.setForeground(hilightColor);
                        e.gc.drawLine(childBounds.x - 2, 1, childBounds.x - 2, controlSize.y - 2);
                    }
                    e.gc.setForeground(lineColor);
                    int lineLeft = childBounds.x + childBounds.width + 1;
                    e.gc.drawLine(lineLeft, 0, lineLeft, controlSize.y);
                    if (isHeader) {
                        e.gc.setForeground(secondaryColor);
                        e.gc.drawLine(lineLeft - 1, 0, lineLeft - 1, controlSize.y - 1);
                    }
                    ++i;
                }
            }
        }
        catch (Throwable throwable) {
            Object var15_16 = null;
            e.gc.setForeground(oldColor);
            throw throwable;
        }
        {
            Object var15_17 = null;
        }
        e.gc.setForeground(oldColor);
    }

    private void fireRowConstructionEvent(Control newControl) {
        Iterator rowConstructionListenersIter = this.parent.rowConstructionListeners.iterator();
        while (rowConstructionListenersIter.hasNext()) {
            RowConstructionListener listener = (RowConstructionListener)rowConstructionListenersIter.next();
            listener.rowConstructed(newControl);
        }
    }

    private void fireHeaderConstructionEvent(Control newControl) {
        Iterator rowConstructionListenersIter = this.parent.rowConstructionListeners.iterator();
        while (rowConstructionListenersIter.hasNext()) {
            RowConstructionListener listener = (RowConstructionListener)rowConstructionListenersIter.next();
            listener.headerConstructed(newControl);
        }
    }

    private void fireRowArriveEvent() {
        if (this.rows.size() < 1 || !this.isRowVisible(this.currentRow)) {
            return;
        }
        Iterator rowChangeListenersIter = this.parent.rowFocusListeners.iterator();
        while (rowChangeListenersIter.hasNext()) {
            IRowFocusListener listener = (IRowFocusListener)rowChangeListenersIter.next();
            TableRow row = this.currentRow();
            Control control = row != null ? row.getRowControl() : null;
            listener.arrive(this.parent, this.topRow + this.currentRow, control);
        }
    }

    private boolean fireRequestRowChangeEvent() {
        if (this.rows.size() < 1 || !this.isRowVisible(this.currentRow)) {
            return true;
        }
        if (this.currentRow > this.rows.size() - 1) {
            return true;
        }
        Iterator rowChangeListenersIter = this.parent.rowFocusListeners.iterator();
        while (rowChangeListenersIter.hasNext()) {
            Control control;
            IRowFocusListener listener = (IRowFocusListener)rowChangeListenersIter.next();
            TableRow row = this.currentRow();
            Control control2 = control = row != null ? row.getRowControl() : null;
            if (listener.requestRowChange(this.parent, this.topRow + this.currentRow, control)) continue;
            return false;
        }
        this.fireRowDepartEvent();
        return true;
    }

    private void fireRowDepartEvent() {
        if (this.rows.size() < 1 || !this.isRowVisible(this.currentRow)) {
            return;
        }
        Iterator rowChangeListenersIter = this.parent.rowFocusListeners.iterator();
        while (rowChangeListenersIter.hasNext()) {
            Control control;
            IRowFocusListener listener = (IRowFocusListener)rowChangeListenersIter.next();
            TableRow row = this.currentRow();
            Control control2 = control = row != null ? row.getRowControl() : null;
            if (control == null) continue;
            listener.depart(this.parent, this.topRow + this.currentRow, control);
        }
    }

    private boolean fireDeleteEvent() {
        IDeleteHandler handler;
        if (this.parent.deleteHandlers.size() < 1) {
            return false;
        }
        int absoluteRow = this.topRow + this.currentRow;
        Iterator deleteHandlersIter = this.parent.deleteHandlers.iterator();
        while (deleteHandlersIter.hasNext()) {
            handler = (IDeleteHandler)deleteHandlersIter.next();
            if (handler.canDelete(absoluteRow)) continue;
            return false;
        }
        deleteHandlersIter = this.parent.deleteHandlers.iterator();
        while (deleteHandlersIter.hasNext()) {
            handler = (IDeleteHandler)deleteHandlersIter.next();
            handler.deleteRow(absoluteRow);
        }
        return true;
    }

    private void fireRowDeletedEvent() {
        int absoluteRow = this.topRow + this.currentRow;
        Iterator deleteHandlersIter = this.parent.deleteHandlers.iterator();
        while (deleteHandlersIter.hasNext()) {
            IDeleteHandler handler = (IDeleteHandler)deleteHandlersIter.next();
            handler.rowDeleted(absoluteRow);
        }
    }

    private int fireInsertEvent() {
        if (this.parent.insertHandlers.size() < 1) {
            return -1;
        }
        Iterator insertHandlersIter = this.parent.insertHandlers.iterator();
        while (insertHandlersIter.hasNext()) {
            IInsertHandler handler = (IInsertHandler)insertHandlersIter.next();
            int resultRow = handler.insert(this.topRow + this.currentRow);
            if (resultRow < 0) continue;
            return resultRow;
        }
        return -1;
    }

    private void fireScrollEvent(ScrollEvent scrollEvent) {
        if (this.parent.scrollListeners.size() < 1) {
            return;
        }
        Iterator scrollListenersIter = this.parent.scrollListeners.iterator();
        while (scrollListenersIter.hasNext()) {
            ScrollListener scrollListener = (ScrollListener)scrollListenersIter.next();
            scrollListener.tableScrolled(scrollEvent);
        }
    }

    private void deselect(Widget widget) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.nebula.widgets.compositetable.internal.ISelectableRegionControl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (DuckType.instanceOf(clazz, widget)) {
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.eclipse.nebula.widgets.compositetable.internal.ISelectableRegionControl");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ISelectableRegionControl control = (ISelectableRegionControl)DuckType.implement(clazz2, widget);
            control.setSelection(0, 0);
        }
    }

    private void handleNextRowNavigation() {
        if (this.currentRow < this.numRowsVisible - 1) {
            if (!this.fireRequestRowChangeEvent()) {
                return;
            }
            this.needToRequestRC = false;
            this.deselect((Widget)this.getControl(this.currentColumn, this.currentRow));
            this.deferredSetFocus(this.getControl(0, this.currentRow + 1), false);
        } else {
            if (this.topRow + this.numRowsVisible >= this.numRowsInCollection) {
                return;
            }
            if (!this.fireRequestRowChangeEvent()) {
                return;
            }
            this.needToRequestRC = false;
            this.deselect((Widget)this.getControl(this.currentColumn, this.currentRow));
            this.doSetTopRow(this.topRow + 1, this.currentRow);
            this.deferredSetFocus(this.getControl(0, this.currentRow), true);
        }
    }

    private void handlePreviousRowNavigation(TableRow row) {
        if (this.currentRow == 0) {
            if (this.topRow == 0) {
                return;
            }
            if (!this.fireRequestRowChangeEvent()) {
                return;
            }
            this.needToRequestRC = false;
            this.deselect((Widget)this.getControl(this.currentColumn, this.currentRow));
            this.doSetTopRow(this.topRow - 1, this.currentRow);
            this.deferredSetFocus(this.getControl(row.getNumColumns() - 1, 0), true);
        } else {
            if (!this.fireRequestRowChangeEvent()) {
                return;
            }
            this.needToRequestRC = false;
            this.deselect((Widget)this.getControl(this.currentColumn, this.currentRow));
            this.deferredSetFocus(this.getControl(row.getNumColumns() - 1, this.currentRow - 1), false);
        }
    }

    private TableRow currentRow() {
        if (this.currentRow < 0 || this.currentRow > this.rows.size() - 1) {
            return null;
        }
        return (TableRow)this.rows.get(this.currentRow);
    }

    public Control getCurrentRowControl() {
        TableRow currentRow = this.currentRow();
        if (currentRow == null) {
            return null;
        }
        return this.currentRow().getRowControl();
    }

    public Control[] getRowControls() {
        Control[] rowControls = new Control[this.rows.size()];
        int i = 0;
        while (i < rowControls.length) {
            rowControls[i] = this.getRowByNumber(i).getRowControl();
            ++i;
        }
        return rowControls;
    }

    public void setMenu(Menu menu) {
        this.menu = menu;
        this.setMenuOnCollection(this.rows, menu);
        this.setMenuOnCollection(this.spareRows, menu);
    }

    private void setMenuOnCollection(LinkedList collection, Menu menu) {
        Iterator rowsIter = collection.iterator();
        while (rowsIter.hasNext()) {
            TableRow row = (TableRow)rowsIter.next();
            row.getRowControl().setMenu(menu);
        }
    }

    public int getControlRow(Control rowControl) {
        int row = 0;
        while (row < this.rows.size()) {
            if (this.getRowByNumber(row).getRowControl() == rowControl) {
                return row;
            }
            ++row;
        }
        throw new IllegalArgumentException("getControlRow passed a control that is not visible inside CompositeTable");
    }

    public TableRow getControlRowObject(Control rowControl) {
        Iterator rowsIter = this.rows.iterator();
        while (rowsIter.hasNext()) {
            TableRow row = (TableRow)rowsIter.next();
            if (row.getRowControl() != rowControl) continue;
            return row;
        }
        throw new IllegalArgumentException("getControlRowObject passed a control that is not visible inside CompositeTable");
    }

    private TableRow getRowByNumber(int rowNumber) {
        if (rowNumber > this.rows.size() - 1 || rowNumber < 0) {
            return null;
        }
        return (TableRow)this.rows.get(rowNumber);
    }

    private Control getControl(int column, int row) {
        TableRow rowObject = this.getRowByNumber(row);
        if (rowObject == null) {
            throw new IndexOutOfBoundsException("Request for a nonexistent row");
        }
        Control result = rowObject.getColumnControl(column);
        return result;
    }

    private int getRowNumber(TableRow row) {
        int rowNumber = 0;
        Iterator rowIter = this.rows.iterator();
        while (rowIter.hasNext()) {
            TableRow candidate = (TableRow)rowIter.next();
            if (candidate == row) {
                return rowNumber;
            }
            ++rowNumber;
        }
        return -1;
    }

    private void internalSetSelection(int column, int row, boolean rowChange) {
        Control toFocus = this.getControl(column, row);
        if (toFocus == null) {
            return;
        }
        if (toFocus.isFocusControl()) {
            toFocus.notifyListeners(15, new Event());
        } else {
            this.deferredSetFocus(toFocus, rowChange);
        }
    }

    private void deferredSetFocus(final Control toFocus, final boolean rowChange) {
        if (toFocus == null) {
            return;
        }
        Display.getCurrent().asyncExec(new Runnable(){

            public void run() {
                if (toFocus.isDisposed()) {
                    return;
                }
                toFocus.setFocus();
                if (rowChange) {
                    InternalCompositeTable.this.fireRowArriveEvent();
                }
            }
        });
    }

    public void doFocusInitialRow() {
        if (this.topRow <= 0) {
            return;
        }
        if (!this.fireRequestRowChangeEvent()) {
            return;
        }
        this.needToRequestRC = false;
        Control widget = this.getDisplay().getFocusControl();
        this.deselect((Widget)widget);
        boolean needToArrive = true;
        if (this.currentRow > 0) {
            needToArrive = false;
        }
        this.doSetTopRow(0, this.currentRow);
        if (needToArrive) {
            this.internalSetSelection(this.currentColumn, 0, true);
        } else {
            this.internalSetSelection(this.currentColumn, 0, false);
        }
    }

    public void doFocusLastRow() {
        if (this.topRow + this.numRowsVisible < this.numRowsInCollection) {
            if (!this.fireRequestRowChangeEvent()) {
                return;
            }
            this.needToRequestRC = false;
            Control widget = this.getDisplay().getFocusControl();
            this.deselect((Widget)widget);
            boolean needToArrive = true;
            if (this.currentRow < this.numRowsVisible - 1) {
                needToArrive = false;
            }
            this.doSetTopRow(this.numRowsInCollection - this.numRowsVisible, this.currentRow);
            if (needToArrive) {
                this.internalSetSelection(this.currentColumn, this.numRowsVisible - 1, true);
            } else {
                this.internalSetSelection(this.currentColumn, this.numRowsVisible - 1, false);
            }
        }
    }

    public void doPageUp() {
        if (this.topRow > 0) {
            if (!this.fireRequestRowChangeEvent()) {
                return;
            }
            this.needToRequestRC = false;
            int newTopRow = this.topRow - this.numRowsInDisplay;
            if (newTopRow < 0) {
                newTopRow = 0;
            }
            this.doSetTopRow(newTopRow, 0);
            this.internalSetSelection(this.currentColumn, this.currentRow, true);
        }
    }

    public void doPageDown() {
        if (this.topRow + this.numRowsVisible < this.numRowsInCollection) {
            if (!this.fireRequestRowChangeEvent()) {
                return;
            }
            this.needToRequestRC = false;
            int newTopRow = this.topRow + this.numRowsVisible;
            if (newTopRow >= this.numRowsInCollection - 1) {
                newTopRow = this.numRowsInCollection - 1;
            }
            this.doSetTopRow(newTopRow, this.numRowsVisible - 1);
            this.internalSetSelection(this.currentColumn, this.currentRow, true);
        }
    }

    public void doRowUp() {
        if (this.maxRowsVisible <= 1) {
            return;
        }
        if (this.currentRow > 0) {
            if (!this.fireRequestRowChangeEvent()) {
                return;
            }
            this.needToRequestRC = false;
            Control widget = this.getDisplay().getFocusControl();
            this.deselect((Widget)widget);
            this.internalSetSelection(this.currentColumn, this.currentRow - 1, false);
            return;
        }
        if (this.topRow > 0) {
            if (!this.fireRequestRowChangeEvent()) {
                return;
            }
            this.needToRequestRC = false;
            Control widget = this.getDisplay().getFocusControl();
            this.deselect((Widget)widget);
            this.doSetTopRow(this.topRow - 1, this.currentRow);
            this.internalSetSelection(this.currentColumn, this.currentRow, true);
            return;
        }
    }

    public void doRowDown() {
        if (this.maxRowsVisible <= 1) {
            return;
        }
        if (this.currentRow < this.numRowsVisible - 1) {
            if (!this.fireRequestRowChangeEvent()) {
                return;
            }
            this.needToRequestRC = false;
            Control widget = this.getDisplay().getFocusControl();
            this.deselect((Widget)widget);
            this.internalSetSelection(this.currentColumn, this.currentRow + 1, false);
            return;
        }
        if (this.topRow + this.numRowsVisible < this.numRowsInCollection) {
            if (!this.fireRequestRowChangeEvent()) {
                return;
            }
            this.needToRequestRC = false;
            Control widget = this.getDisplay().getFocusControl();
            this.deselect((Widget)widget);
            this.doSetTopRow(this.topRow + 1, this.currentRow);
            this.internalSetSelection(this.currentColumn, this.currentRow, true);
            return;
        }
    }

    public boolean doInsertRow() {
        if (this.parent.insertHandlers.size() < 1) {
            return false;
        }
        if (!this.fireRequestRowChangeEvent()) {
            return false;
        }
        this.needToRequestRC = false;
        int newRowPosition = this.fireInsertEvent();
        if (newRowPosition < 0) {
            throw new IllegalArgumentException("Insert < row 0???");
        }
        this.disposeEmptyTablePlaceholder();
        Control widget = this.getDisplay().getFocusControl();
        this.deselect((Widget)widget);
        if (this.topRow <= newRowPosition && this.numRowsVisible > newRowPosition - this.topRow) {
            this.insertRowAt(newRowPosition - this.topRow);
            ++this.numRowsInCollection;
            this.updateVisibleRows();
            int newRowNumber = newRowPosition - this.topRow;
            if (newRowNumber != this.currentRow) {
                this.internalSetSelection(this.currentColumn, newRowNumber, false);
            } else {
                this.internalSetSelection(this.currentColumn, newRowNumber, true);
            }
            return true;
        }
        ++this.numRowsInCollection;
        if (newRowPosition < this.topRow + this.currentRow) {
            this.doSetTopRow(newRowPosition, this.currentRow);
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    InternalCompositeTable.this.updateVisibleRows();
                    if (InternalCompositeTable.this.currentRow != 0) {
                        InternalCompositeTable.this.internalSetSelection(InternalCompositeTable.this.currentColumn, 0, false);
                    } else {
                        InternalCompositeTable.this.internalSetSelection(InternalCompositeTable.this.currentColumn, 0, true);
                    }
                }
            });
        } else if (this.numRowsInDisplay > this.numRowsVisible) {
            this.updateVisibleRows();
            int newRowNumber = newRowPosition - this.topRow;
            if (newRowNumber != this.currentRow) {
                this.internalSetSelection(this.currentColumn, newRowNumber, false);
            } else {
                this.internalSetSelection(this.currentColumn, newRowNumber, true);
            }
        } else {
            this.doSetTopRow(newRowPosition - this.numRowsVisible + 1, this.currentRow);
            int newRowNumber = this.numRowsVisible - 1;
            if (newRowNumber != this.currentRow) {
                this.internalSetSelection(this.currentColumn, newRowNumber, false);
            } else {
                this.internalSetSelection(this.currentColumn, newRowNumber, true);
            }
        }
        return false;
    }

    public boolean doDeleteRow() {
        if (this.fireDeleteEvent()) {
            --this.numRowsInCollection;
            if (this.currentRow >= this.numRowsVisible - 1) {
                if (this.numRowsInCollection > 0) {
                    if (this.currentRow < 1) {
                        this.needToRequestRC = false;
                        this.deleteRowAt(this.currentRow);
                        this.doSetTopRow(this.topRow - 1, this.currentRow);
                        this.internalSetSelection(this.currentColumn, this.currentRow, true);
                    } else {
                        this.needToRequestRC = false;
                        this.internalSetSelection(this.currentColumn, this.currentRow - 1, false);
                        Display.getCurrent().asyncExec(new Runnable(){

                            public void run() {
                                InternalCompositeTable.this.deleteRowAt(InternalCompositeTable.this.currentRow + 1);
                                InternalCompositeTable.this.updateVisibleRows();
                            }
                        });
                    }
                } else {
                    this.deleteRowAt(this.currentRow);
                    --this.numRowsVisible;
                    this.createEmptyTablePlaceholer();
                    this.emptyTablePlaceholder.setFocus();
                }
            } else {
                this.deleteRowAt(this.currentRow);
                this.updateVisibleRows();
                this.internalSetSelection(this.currentColumn, this.currentRow, true);
            }
            this.fireRowDeletedEvent();
        }
        return false;
    }
}

