/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.compositetable.day.internal;

import java.text.DateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.nebula.widgets.compositetable.day.internal.TimeSlot;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Widget;

public class TimeSlice
extends Composite {
    private final Image allDayImage;
    private CLabel timeLabel;
    private LinkedList columns;
    private boolean headerControl;
    private int numberOfColumns;
    private Date currentTime;
    static /* synthetic */ Class class$0;

    public LinkedList getColumns() {
        return this.columns;
    }

    public Control getColumnControl(int column) {
        return (Control)this.columns.get(column);
    }

    public int getControlColumn(Widget widget) {
        int columnNumber = 0;
        Iterator columnsIter = this.columns.iterator();
        while (columnsIter.hasNext()) {
            if (columnsIter.next() == widget) {
                return columnNumber;
            }
            ++columnNumber;
        }
        throw new IllegalArgumentException("Unrecognized widget passed to getControlColumn");
    }

    public TimeSlice(Composite parent, int style) {
        super(parent, 0);
        Display display = Display.getCurrent();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.nebula.widgets.compositetable.day.internal.TimeSlice");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.allDayImage = new Image((Device)display, clazz.getResourceAsStream("clock.png"));
        this.timeLabel = null;
        this.columns = new LinkedList();
        this.headerControl = false;
        this.numberOfColumns = 1;
        this.currentTime = new Date();
        this.initialize();
    }

    public void setMenu(Menu menu) {
        super.setMenu(menu);
        Iterator columnsIter = this.columns.iterator();
        while (columnsIter.hasNext()) {
            TimeSlot cell = (TimeSlot)((Object)columnsIter.next());
            cell.setMenu(menu);
        }
    }

    private void initialize() {
        this.timeLabel = new CLabel((Composite)this, 131072);
        this.timeLabel.setText("23:00 PM");
        Integer preferredWidth = new Integer(this.timeLabel.computeSize((int)-1, (int)-1, (boolean)false).x + 5);
        this.timeLabel.setLayoutData((Object)preferredWidth);
        this.timeLabel.setText("");
        this.setBackground(Display.getCurrent().getSystemColor(22));
        this.setSize(new Point(537, 16));
        this.setLayout(new TimeSliceAcrossTimeLayout());
    }

    public boolean isHeaderControl() {
        return this.headerControl;
    }

    public void setHeaderControl(boolean headerControl) {
        this.headerControl = headerControl;
    }

    public int getNumberOfColumns() {
        return this.numberOfColumns;
    }

    public void setNumberOfColumns(int numberOfColumns) {
        this.numberOfColumns = numberOfColumns;
        Control[] tabStops = new Control[numberOfColumns];
        int i = numberOfColumns;
        while (i > 0) {
            Object control;
            if (this.headerControl) {
                control = new CLabel((Composite)this, 0x1000808);
                tabStops[numberOfColumns - i] = control;
                this.columns.add(control);
            } else {
                control = new TimeSlot(this, 0);
                tabStops[numberOfColumns - i] = control;
                this.columns.add(control);
            }
            --i;
        }
        this.setTabList(tabStops);
    }

    public Date getCurrentTime() {
        return this.currentTime;
    }

    public void setCurrentTime(Date currentTime) {
        if (currentTime == null) {
            this.timeLabel.setImage(this.allDayImage);
            this.timeLabel.setText("");
            this.setAllDayEventOnDays(true);
            return;
        }
        this.setAllDayEventOnDays(false);
        this.timeLabel.setImage(null);
        this.setTimeOnDays(currentTime);
        this.currentTime = currentTime;
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(currentTime);
        if (calendar.get(12) == 0) {
            DateFormat df = DateFormat.getTimeInstance(3);
            String time = df.format(currentTime);
            this.timeLabel.setText(time);
        } else {
            this.timeLabel.setText("");
        }
    }

    private void setTimeOnDays(Date currentTime) {
        Iterator daysIter = this.columns.iterator();
        while (daysIter.hasNext()) {
            Object dayCandidate = daysIter.next();
            if (!(dayCandidate instanceof TimeSlot)) continue;
            TimeSlot day = (TimeSlot)((Object)dayCandidate);
            day.setTime(currentTime);
        }
    }

    private void setAllDayEventOnDays(boolean isAllDayEvent) {
        Iterator daysIter = this.columns.iterator();
        while (daysIter.hasNext()) {
            Object dayCandidate = daysIter.next();
            if (!(dayCandidate instanceof TimeSlot)) continue;
            TimeSlot day = (TimeSlot)((Object)dayCandidate);
            day.setAllDay(isAllDayEvent);
        }
    }

    public void addCellFocusListener(FocusListener listener) {
        Iterator daysIter = this.columns.iterator();
        while (daysIter.hasNext()) {
            Object dayCandidate = daysIter.next();
            if (!(dayCandidate instanceof TimeSlot)) continue;
            TimeSlot day = (TimeSlot)((Object)dayCandidate);
            day.addFocusListener(listener);
        }
    }

    public void removeCellFocusListener(FocusListener listener) {
        Iterator daysIter = this.columns.iterator();
        while (daysIter.hasNext()) {
            Object dayCandidate = daysIter.next();
            if (!(dayCandidate instanceof TimeSlot)) continue;
            TimeSlot day = (TimeSlot)((Object)dayCandidate);
            day.removeFocusListener(listener);
        }
    }

    public void addKeyListener(KeyListener listener) {
        super.addKeyListener(listener);
        Iterator columnsIter = this.columns.iterator();
        while (columnsIter.hasNext()) {
            TimeSlot cell = (TimeSlot)((Object)columnsIter.next());
            cell.addKeyListener(listener);
        }
    }

    public void removeKeyListener(KeyListener listener) {
        super.removeKeyListener(listener);
        Iterator columnsIter = this.columns.iterator();
        while (columnsIter.hasNext()) {
            TimeSlot cell = (TimeSlot)((Object)columnsIter.next());
            cell.removeKeyListener(listener);
        }
    }

    public void addMouseListener(MouseListener listener) {
        super.addMouseListener(listener);
        Iterator columnsIter = this.columns.iterator();
        while (columnsIter.hasNext()) {
            TimeSlot cell = (TimeSlot)((Object)columnsIter.next());
            cell.addMouseListener(listener);
        }
    }

    public void removeMouseListener(MouseListener listener) {
        super.removeMouseListener(listener);
        Iterator columnsIter = this.columns.iterator();
        while (columnsIter.hasNext()) {
            TimeSlot cell = (TimeSlot)((Object)columnsIter.next());
            cell.removeMouseListener(listener);
        }
    }

    private static class TimeSliceAcrossTimeLayout
    extends Layout {
        Point preferredSize = new Point(-1, -1);

        private TimeSliceAcrossTimeLayout() {
        }

        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            if (this.preferredSize.x == -1 || flushCache) {
                this.preferredSize.x = wHint;
                this.preferredSize.y = -1;
                Control[] children = composite.getChildren();
                int i = 0;
                while (i < children.length) {
                    Control child = children[i];
                    this.preferredSize.y = Math.max(this.preferredSize.y, child.computeSize((int)-1, (int)-1, (boolean)true).y);
                    ++i;
                }
            }
            return this.preferredSize;
        }

        protected void layout(Composite composite, boolean flushCache) {
            Point parentSize = composite.getSize();
            Control[] children = composite.getChildren();
            Integer preferredWidth = (Integer)children[0].getLayoutData();
            if (preferredWidth == null) {
                preferredWidth = new Integer(children[0].computeSize((int)-1, (int)-1).x);
            }
            children[0].setBounds(0, 0, preferredWidth.intValue(), parentSize.y);
            int controlWidth = 0;
            int extraWidth = 0;
            if (children.length >= 2) {
                controlWidth = (parentSize.x - preferredWidth) / (children.length - 1);
                extraWidth = (parentSize.x - preferredWidth) % (children.length - 1);
            }
            int leftPosition = preferredWidth;
            int i = 1;
            while (i < children.length) {
                Control control = children[i];
                int width = controlWidth;
                if (extraWidth > 0) {
                    ++width;
                    --extraWidth;
                }
                control.setBounds(leftPosition, 0, width, parentSize.y);
                leftPosition += width;
                ++i;
            }
        }
    }
}

