/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.compositetable.day.internal;

import java.util.Date;
import java.util.GregorianCalendar;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class TimeSlot
extends Canvas {
    private static final int FOCUS_LINE_WIDTH = 2;
    private boolean focusControl = false;
    private final Color WHITE;
    private final Color CELL_BACKGROUND_LIGHT;
    private final Color CELL_BACKGROUND_WHITE;
    private final Color CELL_BORDER_EMPHASIZED;
    private final Color CELL_BORDER_LIGHT;
    private final Color TIME_BAR_COLOR;
    private final Color FOCUS_RUBBERBAND;
    public static final int TIME_BAR_WIDTH = 3;
    private DisposeListener disposeListener = new DisposeListener(){

        public void widgetDisposed(DisposeEvent e) {
            TimeSlot.this.removeTraverseListener(TimeSlot.this.traverseListener);
            TimeSlot.this.removeFocusListener(TimeSlot.this.focusListener);
            TimeSlot.this.removePaintListener(TimeSlot.this.paintListener);
            TimeSlot.this.removeMouseListener(TimeSlot.this.mouseListener);
            TimeSlot.this.removeKeyListener(TimeSlot.this.keyListener);
            TimeSlot.this.removeDisposeListener(TimeSlot.this.disposeListener);
            TimeSlot.this.CELL_BACKGROUND_LIGHT.dispose();
            TimeSlot.this.CELL_BORDER_LIGHT.dispose();
            TimeSlot.this.TIME_BAR_COLOR.dispose();
            TimeSlot.this.FOCUS_RUBBERBAND.dispose();
        }
    };
    private KeyListener keyListener = new KeyAdapter(){

        public void keyPressed(KeyEvent e) {
            switch (e.keyCode) {
                case 0x1000003: {
                    TimeSlot.this.traverse(8);
                    return;
                }
                case 0x1000004: {
                    TimeSlot.this.traverse(16);
                    return;
                }
            }
        }
    };
    private Point preferredSize = new Point(-1, -1);
    private PaintListener paintListener = new PaintListener(){

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void paintControl(PaintEvent e) {
            GC gc = e.gc;
            Color oldForeground = gc.getForeground();
            Color oldBackground = gc.getBackground();
            Point controlSize = TimeSlot.this.getSize();
            try {
                gc.setBackground(TimeSlot.this.WHITE);
                gc.setForeground(TimeSlot.this.WHITE);
                gc.fillRectangle(0, 0, 3, controlSize.y);
                gc.setForeground(TimeSlot.this.CELL_BORDER_LIGHT);
                int lineStyle = gc.getLineStyle();
                gc.setLineStyle(3);
                gc.drawLine(4, 0, 4, controlSize.y);
                gc.setLineStyle(lineStyle);
                gc.setForeground(TimeSlot.this.TIME_BAR_COLOR);
                gc.drawLine(controlSize.x - 1, 0, controlSize.x - 1, controlSize.y);
                if (TimeSlot.this.isMinutesAfterHour(0)) {
                    gc.setForeground(TimeSlot.this.CELL_BORDER_EMPHASIZED);
                } else {
                    gc.setForeground(TimeSlot.this.CELL_BORDER_LIGHT);
                }
                if (TimeSlot.this.isMinutesAfterHour(0) || TimeSlot.this.isMinutesAfterHour(30) && !TimeSlot.this.isAllDay()) {
                    gc.drawLine(0, 0, controlSize.x, 0);
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                gc.setBackground(oldBackground);
                gc.setForeground(oldForeground);
                throw throwable;
            }
            {
                Object var7_10 = null;
            }
            gc.setBackground(oldBackground);
            gc.setForeground(oldForeground);
            int oldLineStyle = gc.getLineStyle();
            int oldLineWidth = gc.getLineWidth();
            try {
                if (TimeSlot.this.focusControl) {
                    gc.setLineStyle(2);
                    gc.setLineWidth(2);
                    gc.setForeground(TimeSlot.this.FOCUS_RUBBERBAND);
                    Point parentSize = TimeSlot.this.getSize();
                    gc.drawRectangle(2, 2, parentSize.x - 4, parentSize.y - 3);
                }
                gc.setForeground(TimeSlot.this.CELL_BACKGROUND_LIGHT);
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                gc.setForeground(oldForeground);
                gc.setLineStyle(oldLineStyle);
                gc.setLineWidth(oldLineWidth);
                throw throwable;
            }
            {
                Object var9_14 = null;
            }
            gc.setForeground(oldForeground);
            gc.setLineStyle(oldLineStyle);
            gc.setLineWidth(oldLineWidth);
        }
    };
    private FocusListener focusListener = new FocusListener(){

        public void focusGained(FocusEvent e) {
            TimeSlot.this.focusControl = true;
            TimeSlot.this.redraw();
        }

        public void focusLost(FocusEvent e) {
            TimeSlot.this.focusControl = false;
            TimeSlot.this.redraw();
        }
    };
    private TraverseListener traverseListener = new TraverseListener(){

        public void keyTraversed(TraverseEvent e) {
        }
    };
    private MouseListener mouseListener = new MouseAdapter(){

        public void mouseDown(MouseEvent e) {
            TimeSlot.this.setFocus();
        }
    };
    private boolean allDay = false;
    private Date time = new Date();

    public TimeSlot(Composite parent, int style) {
        super(parent, style);
        this.addTraverseListener(this.traverseListener);
        this.addFocusListener(this.focusListener);
        this.addPaintListener(this.paintListener);
        this.addDisposeListener(this.disposeListener);
        this.addKeyListener(this.keyListener);
        this.addMouseListener(this.mouseListener);
        Display display = Display.getCurrent();
        this.WHITE = display.getSystemColor(1);
        this.CELL_BACKGROUND_WHITE = display.getSystemColor(1);
        this.CELL_BORDER_EMPHASIZED = display.getSystemColor(26);
        this.CELL_BACKGROUND_LIGHT = new Color((Device)display, new RGB(248, 248, 248));
        this.CELL_BORDER_LIGHT = new Color((Device)display, this.saturate(this.CELL_BORDER_EMPHASIZED.getRGB(), 0.2f));
        this.TIME_BAR_COLOR = new Color((Device)display, this.saturate(this.CELL_BORDER_EMPHASIZED.getRGB(), 0.1f));
        this.FOCUS_RUBBERBAND = new Color((Device)display, this.lighten(this.saturate(display.getSystemColor(31).getRGB(), 0.85f), -0.333f));
        this.setBackground(this.CELL_BACKGROUND_LIGHT);
    }

    private RGB saturate(RGB color, float saturation) {
        float[] hsb = color.getHSB();
        return new RGB(hsb[0], saturation, hsb[2]);
    }

    private RGB lighten(RGB color, float amount) {
        float[] hsb = color.getHSB();
        float b = hsb[2] + hsb[2] * amount;
        if (b < 0.0f) {
            b = 0.0f;
        }
        if (b > 1.0f) {
            b = 1.0f;
        }
        return new RGB(hsb[0], hsb[1], b);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Point computeSize(int wHint, int hHint, boolean changed) {
        if (this.preferredSize.x != -1) {
            if (!changed) return this.preferredSize;
        }
        this.preferredSize.x = this.getSize().x;
        Display display = Display.getCurrent();
        GC gc = new GC((Drawable)display);
        try {
            Font font = display.getSystemFont();
            gc.setFont(font);
            FontMetrics fm = gc.getFontMetrics();
            this.preferredSize.y = fm.getHeight();
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            gc.dispose();
            throw throwable;
        }
        {
            Object var8_10 = null;
        }
        gc.dispose();
        return this.preferredSize;
    }

    public boolean isMinutesAfterHour(int minute) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(this.time);
        return calendar.get(12) == minute;
    }

    public void setAllDay(boolean isAllDayEvent) {
        this.allDay = isAllDayEvent;
        if (isAllDayEvent) {
            this.setBackground(this.CELL_BACKGROUND_WHITE);
        } else {
            this.setBackground(this.CELL_BACKGROUND_LIGHT);
        }
    }

    public boolean isAllDay() {
        return this.allDay;
    }

    public void setTime(Date currentTime) {
        this.time = currentTime;
        this.redraw();
    }
}

