/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.compositetable.timeeditor;

import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.nebula.widgets.compositetable.timeeditor.CalendarableItem;
import org.eclipse.nebula.widgets.compositetable.timeeditor.EventContentProvider;
import org.eclipse.nebula.widgets.compositetable.timeeditor.EventCountProvider;

public class CalendarableModel {
    private static final int DEFAULT_START_HOUR = 8;
    private int numberOfDays = -1;
    private int numberOfDivisionsInHour = -1;
    private ArrayList[] dayColumns = null;
    private CalendarableItem[][][] eventLayout = null;
    private int defaultStartHour = 8;
    private Date startDate = null;
    private EventCountProvider eventCountProvider = null;
    private EventContentProvider eventContentProvider = null;

    public int getNumberOfColumnsWithinDay(int dayOffset) {
        if (this.eventLayout == null) {
            return -1;
        }
        if (this.eventLayout[dayOffset] == null) {
            return -1;
        }
        return this.eventLayout[dayOffset].length;
    }

    public void setEventLayout(int dayOffset, CalendarableItem[][] eventLayout) {
        this.eventLayout[dayOffset] = eventLayout;
    }

    public CalendarableItem[][] getEventLayout(int dayOffset) {
        return this.eventLayout[dayOffset];
    }

    public void setTimeBreakdown(int numberOfDays, int numberOfDivisionsInHour) {
        if (numberOfDivisionsInHour < 1) {
            throw new IllegalArgumentException("There must be at least one division in the hour");
        }
        if (numberOfDays < 1) {
            throw new IllegalArgumentException("There must be at least one day in the editor");
        }
        this.numberOfDays = numberOfDays;
        this.numberOfDivisionsInHour = numberOfDivisionsInHour;
        this.initializeDayArrays(numberOfDays);
        this.refresh();
    }

    private void initializeDayArrays(int numberOfDays) {
        this.dayColumns = new ArrayList[numberOfDays];
        int i = 0;
        while (i < numberOfDays) {
            this.dayColumns[i] = new ArrayList();
            ++i;
        }
        this.eventLayout = new CalendarableItem[numberOfDays][][];
    }

    public int getNumberOfDays() {
        return this.numberOfDays;
    }

    public int getNumberOfDivisionsInHour() {
        return this.numberOfDivisionsInHour;
    }

    public List setStartDate(Date startDate) {
        if (this.startDate == null || startDate.after(this.calculateDate(this.startDate, this.numberOfDays - 1)) || this.calculateDate(startDate, this.numberOfDays - 1).before(this.startDate)) {
            this.startDate = startDate;
            this.eventLayout = new CalendarableItem[this.numberOfDays][][];
            return this.refresh();
        }
        LinkedList obsoleteCalendarables = new LinkedList();
        int overlap = -1;
        if (startDate.before(this.startDate)) {
            int day = 0;
            while (day < this.numberOfDays) {
                Date candidate = this.calculateDate(startDate, day);
                if (candidate.equals(this.startDate)) {
                    overlap = day;
                }
                ++day;
            }
            day = this.numberOfDays - 1;
            while (day >= 0) {
                if (this.numberOfDays - day <= overlap) {
                    Iterator invalidated = this.dayColumns[day].iterator();
                    while (invalidated.hasNext()) {
                        obsoleteCalendarables.add(invalidated.next());
                    }
                    this.dayColumns[day] = this.dayColumns[day - overlap];
                    this.eventLayout[day] = this.eventLayout[day - overlap];
                }
                if (day >= overlap) {
                    this.dayColumns[day] = this.dayColumns[day - overlap];
                    this.eventLayout[day] = this.eventLayout[day - overlap];
                } else {
                    this.dayColumns[day] = new ArrayList();
                    this.eventLayout[day] = null;
                    this.refresh(this.calculateDate(startDate, day), day, obsoleteCalendarables);
                }
                --day;
            }
        } else {
            int day = 0;
            while (day < this.numberOfDays) {
                Date candidate = this.calculateDate(this.startDate, day);
                if (candidate.equals(startDate)) {
                    overlap = day;
                }
                ++day;
            }
            day = 0;
            while (day < this.numberOfDays) {
                if (day < overlap) {
                    Iterator invalidated = this.dayColumns[day].iterator();
                    while (invalidated.hasNext()) {
                        obsoleteCalendarables.add(invalidated.next());
                    }
                    this.dayColumns[day] = this.dayColumns[day + overlap];
                    this.eventLayout[day] = this.eventLayout[day + overlap];
                }
                if (day < this.numberOfDays - overlap) {
                    this.dayColumns[day] = this.dayColumns[day + overlap];
                    this.eventLayout[day] = this.eventLayout[day + overlap];
                } else {
                    this.dayColumns[day] = new ArrayList();
                    this.eventLayout[day] = null;
                    this.refresh(this.calculateDate(startDate, day), day, obsoleteCalendarables);
                }
                ++day;
            }
        }
        this.startDate = startDate;
        return obsoleteCalendarables;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setEventCountProvider(EventCountProvider eventCountProvider) {
        this.eventCountProvider = eventCountProvider;
        this.refresh();
    }

    public void setEventContentProvider(EventContentProvider eventContentProvider) {
        this.eventContentProvider = eventContentProvider;
        this.refresh();
    }

    private List refresh() {
        if (this.startDate == null) {
            return new LinkedList();
        }
        LinkedList result = new LinkedList();
        if (!this.isInitialized()) {
            return result;
        }
        Date dateToRefresh = null;
        int i = 0;
        while (i < this.dayColumns.length) {
            dateToRefresh = this.calculateDate(this.startDate, i);
            this.refresh(dateToRefresh, i, result);
            ++i;
        }
        return result;
    }

    public Date calculateDate(Date startDate, int numberOfDaysFromStartDate) {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(startDate);
        gc.add(5, numberOfDaysFromStartDate);
        return gc.getTime();
    }

    private boolean isInitialized() {
        return this.startDate != null && this.numberOfDays > 0 && this.numberOfDivisionsInHour > 0 && this.eventContentProvider != null && this.eventCountProvider != null;
    }

    private void refresh(Date date, int column, List invalidatedElements) {
        if (this.eventCountProvider == null || this.eventContentProvider == null) {
            return;
        }
        int numberOfEventsInDay = this.eventCountProvider.getNumberOfEventsInDay(date);
        while (this.dayColumns[column].size() > 0) {
            invalidatedElements.add(this.dayColumns[column].remove(0));
        }
        this.resizeList(date, this.dayColumns[column], numberOfEventsInDay);
        CalendarableItem[] tempEvents = this.dayColumns[column].toArray(new CalendarableItem[numberOfEventsInDay]);
        this.eventContentProvider.refresh(date, tempEvents);
    }

    private void resizeList(Date date, ArrayList list, int numberOfEventsInDay) {
        while (list.size() < numberOfEventsInDay) {
            list.add(new CalendarableItem(date));
        }
        while (list.size() > numberOfEventsInDay) {
            list.remove(0);
        }
    }

    public List refresh(Date date) {
        LinkedList invalidatedCalendarables = new LinkedList();
        GregorianCalendar dateToRefresh = new GregorianCalendar();
        dateToRefresh.setTime(date);
        int offset = 0;
        while (offset < this.numberOfDays) {
            Date refreshTarget = this.calculateDate(this.startDate, offset);
            GregorianCalendar target = new GregorianCalendar();
            target.setTime(refreshTarget);
            if (target.get(5) == dateToRefresh.get(5) && target.get(2) == dateToRefresh.get(2) && target.get(1) == dateToRefresh.get(1)) {
                this.refresh(date, offset, invalidatedCalendarables);
                break;
            }
            ++offset;
        }
        return invalidatedCalendarables;
    }

    public List getCalendarableItems(int dayOffset) {
        return this.dayColumns[dayOffset];
    }

    public int computeNumberOfAllDayEventRows() {
        int maxAllDayEvents = 0;
        int day = 0;
        while (day < this.dayColumns.length) {
            ArrayList calendarables = this.dayColumns[day];
            int allDayEventsInCurrentDay = 0;
            Iterator iter = calendarables.iterator();
            while (iter.hasNext()) {
                CalendarableItem event = (CalendarableItem)iter.next();
                if (!event.isAllDayEvent()) continue;
                ++allDayEventsInCurrentDay;
            }
            if (allDayEventsInCurrentDay > maxAllDayEvents) {
                maxAllDayEvents = allDayEventsInCurrentDay;
            }
            ++day;
        }
        return maxAllDayEvents;
    }

    public int computeStartHour() {
        GregorianCalendar gc = new GregorianCalendar();
        int startHour = this.getDefaultStartHour();
        int day = 0;
        while (day < this.dayColumns.length) {
            ArrayList calendarables = this.dayColumns[day];
            Iterator iter = calendarables.iterator();
            while (iter.hasNext()) {
                CalendarableItem event = (CalendarableItem)iter.next();
                if (event.isAllDayEvent()) continue;
                gc.setTime(event.getStartTime());
                int eventStartHour = gc.get(11);
                if (eventStartHour >= startHour) continue;
                startHour = eventStartHour;
            }
            ++day;
        }
        return startHour;
    }

    public void setDefaultStartHour(int defaultStartHour) {
        this.defaultStartHour = defaultStartHour;
    }

    public int getDefaultStartHour() {
        return this.defaultStartHour;
    }

    public int getDay(CalendarableItem calendarable) {
        int day = 0;
        while (day < this.dayColumns.length) {
            Iterator calendarableIter = this.dayColumns[day].iterator();
            while (calendarableIter.hasNext()) {
                CalendarableItem event = (CalendarableItem)calendarableIter.next();
                if (event != calendarable) continue;
                return day;
            }
            ++day;
        }
        throw new IllegalArgumentException("Invalid Calenderable passed");
    }

    public int computeHourFromRow(int row) {
        return row / this.getNumberOfDivisionsInHour() + this.computeStartHour();
    }

    public int computeMinuteFromRow(int row) {
        int numberOfDivisionsInHour = this.getNumberOfDivisionsInHour();
        int minute = (int)((double)row % (double)numberOfDivisionsInHour / (double)numberOfDivisionsInHour * 60.0);
        return minute;
    }

    public CalendarableItem[] getAllDayCalendarables(int day) {
        LinkedList<CalendarableItem> allDays = new LinkedList<CalendarableItem>();
        Iterator calendarablesIter = this.getCalendarableItems(day).iterator();
        while (calendarablesIter.hasNext()) {
            CalendarableItem candidate = (CalendarableItem)calendarablesIter.next();
            if (!candidate.isAllDayEvent()) continue;
            allDays.add(candidate);
        }
        return allDays.toArray(new CalendarableItem[allDays.size()]);
    }

    public CalendarableItem findAllDayCalendarable(int day, boolean forward, CalendarableItem selection) {
        CalendarableItem[] calendarables = this.getAllDayCalendarables(day);
        if (forward) {
            if (calendarables.length < 1) {
                return null;
            }
            if (selection == null) {
                return null;
            }
            if (selection == calendarables[calendarables.length - 1]) {
                return null;
            }
            int selected = 0;
            while (selected < calendarables.length) {
                if (calendarables[selected] == selection) {
                    return calendarables[selected + 1];
                }
                ++selected;
            }
        } else {
            if (calendarables.length < 1) {
                return null;
            }
            if (selection == null) {
                return calendarables[calendarables.length - 1];
            }
            if (selection == calendarables[0]) {
                return null;
            }
            int selected = 0;
            while (selected < calendarables.length) {
                if (calendarables[selected] == selection) {
                    return calendarables[selected - 1];
                }
                ++selected;
            }
        }
        return null;
    }

    public CalendarableItem findTimedCalendarable(int day, int currentRow, int stopPosition, boolean forward, CalendarableItem selection) {
        CalendarableItem[][] eventLayoutForDay = this.getEventLayout(day);
        if (eventLayoutForDay == null) {
            throw new IllegalArgumentException("Day " + day + " has no event data!!!");
        }
        int startColumn = 0;
        if (selection != null && (startColumn = this.findCalendarable(selection, currentRow, eventLayoutForDay)) == -1) {
            throw new IllegalArgumentException("day " + day + ", row " + currentRow + " does not contain the specified Calendarable");
        }
        int currentColumn = startColumn;
        if (forward) {
            if (stopPosition == -1) {
                stopPosition = eventLayoutForDay[0].length;
            }
            int row = currentRow;
            while (row < stopPosition) {
                do {
                    CalendarableItem candidate;
                    if ((candidate = eventLayoutForDay[currentColumn][row]) == null || candidate == selection || selection != null && !candidate.getStartTime().after(selection.getStartTime()) && (currentColumn <= startColumn || candidate.getStartTime().before(selection.getStartTime()))) continue;
                    return candidate;
                } while (++currentColumn < eventLayoutForDay.length);
                currentColumn = 0;
                ++row;
            }
        } else {
            if (stopPosition == -1) {
                stopPosition = 0;
            }
            int row = currentRow;
            while (row >= stopPosition) {
                do {
                    CalendarableItem candidate;
                    if ((candidate = eventLayoutForDay[currentColumn][row]) == null || candidate == selection || candidate.getUpperLeftPositionInDayRowCoordinates().y != row || selection != null && !candidate.getStartTime().before(selection.getStartTime()) && (currentColumn >= startColumn || candidate.getStartTime().after(selection.getStartTime()))) continue;
                    if (selection == null && currentColumn > 0) {
                        int earlierColumn = currentColumn - 1;
                        while (earlierColumn >= 0) {
                            CalendarableItem newCandidate = eventLayoutForDay[earlierColumn][row];
                            if (newCandidate.getStartTime().after(candidate.getStartTime())) {
                                candidate = newCandidate;
                            }
                            --earlierColumn;
                        }
                    }
                    return candidate;
                } while (--currentColumn >= 0);
                currentColumn = eventLayoutForDay.length - 1;
                --row;
            }
        }
        return null;
    }

    private int findCalendarable(CalendarableItem selection, int currentRow, CalendarableItem[][] eventLayoutForDay) {
        int column = 0;
        while (column < eventLayoutForDay.length) {
            if (eventLayoutForDay[column][currentRow] == selection) {
                return column;
            }
            ++column;
        }
        return -1;
    }

    public CalendarableItem findNextCalendarable(int selectedDay, int selectedRow, CalendarableItem selection, boolean isAllDayEventRow) {
        CalendarableItem[] allDayCalendarables;
        CalendarableItem result = null;
        if (isAllDayEventRow) {
            result = this.findAllDayCalendarable(selectedDay, true, selection);
            if (result != null) {
                return result;
            }
            result = this.findTimedCalendarable(selectedDay, 0, -1, true, null);
            if (result != null) {
                return result;
            }
        } else {
            result = this.findTimedCalendarable(selectedDay, selectedRow, -1, true, selection);
            if (result != null) {
                return result;
            }
        }
        int currentDay = this.nextDay(selectedDay);
        while (currentDay != selectedDay) {
            allDayCalendarables = this.getAllDayCalendarables(currentDay);
            if (allDayCalendarables.length > 0) {
                return allDayCalendarables[0];
            }
            result = this.findTimedCalendarable(currentDay, 0, -1, true, null);
            if (result != null) {
                return result;
            }
            currentDay = this.nextDay(currentDay);
        }
        allDayCalendarables = this.getAllDayCalendarables(selectedDay);
        if (allDayCalendarables.length > 0) {
            return allDayCalendarables[0];
        }
        if (isAllDayEventRow) {
            return null;
        }
        result = this.findTimedCalendarable(selectedDay, 0, selectedRow - 1, true, null);
        if (result != null) {
            return result;
        }
        return null;
    }

    private int nextDay(int selectedDay) {
        if (++selectedDay >= this.numberOfDays) {
            selectedDay = 0;
        }
        return selectedDay;
    }

    public CalendarableItem findPreviousCalendarable(int selectedDay, int selectedRow, CalendarableItem selection, boolean isAllDayEventRow) {
        CalendarableItem result = null;
        if (!isAllDayEventRow) {
            result = this.findTimedCalendarable(selectedDay, selectedRow, -1, false, selection);
            if (result != null) {
                return result;
            }
            result = this.findAllDayCalendarable(selectedDay, false, null);
            if (result != null) {
                return result;
            }
        } else {
            result = this.findAllDayCalendarable(selectedDay, false, selection);
            if (result != null) {
                return result;
            }
        }
        int currentDay = this.previousDay(selectedDay);
        while (currentDay != selectedDay) {
            result = this.findTimedCalendarable(currentDay, this.getEventLayout(selectedDay)[0].length - 1, -1, false, null);
            if (result != null) {
                return result;
            }
            CalendarableItem[] allDayCalendarables = this.getAllDayCalendarables(currentDay);
            if (allDayCalendarables.length > 0) {
                return allDayCalendarables[allDayCalendarables.length - 1];
            }
            currentDay = this.previousDay(currentDay);
        }
        result = this.findTimedCalendarable(currentDay, this.getEventLayout(selectedDay)[0].length - 1, selectedRow + 1, false, null);
        if (result != null) {
            return result;
        }
        return null;
    }

    private int previousDay(int selectedDay) {
        if (--selectedDay < 0) {
            selectedDay = this.numberOfDays - 1;
        }
        return selectedDay;
    }
}

