/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.communication.core.factory;

import org.eclipse.riena.communication.core.IRemoteServiceReference;
import org.eclipse.riena.communication.core.RemoteServiceDescription;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class RemoteServiceReference
implements IRemoteServiceReference {
    private Object serviceInstance;
    private ServiceRegistration serviceRegistration;
    private RemoteServiceDescription description;
    private BundleContext context;

    public RemoteServiceReference(RemoteServiceDescription description) {
        this.description = description;
    }

    @Override
    public String getURL() {
        return this.description.getURL();
    }

    @Override
    public ServiceRegistration getServiceRegistration() {
        return this.serviceRegistration;
    }

    @Override
    public void setServiceRegistration(ServiceRegistration serviceRegistration) {
        this.serviceRegistration = serviceRegistration;
    }

    @Override
    public void setServiceInstance(Object serviceInstance) {
        this.serviceInstance = serviceInstance;
    }

    @Override
    public Object getServiceInstance() {
        return this.serviceInstance;
    }

    @Override
    public RemoteServiceDescription getDescription() {
        return this.description;
    }

    @Override
    public void dispose() {
        this.serviceInstance = null;
        this.serviceRegistration = null;
        if (this.description != null) {
            this.description.dispose();
            this.description = null;
        }
    }

    @Override
    public String getServiceInterfaceClassName() {
        return this.description.getServiceInterfaceClassName();
    }

    @Override
    public BundleContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(BundleContext context) {
        this.context = context;
    }

    public String toString() {
        String symbolicName = "no context";
        if (this.context != null) {
            symbolicName = this.context.getBundle().getSymbolicName();
        }
        return "context for bundle=" + symbolicName + ", end point=(" + this.getDescription() + ")";
    }
}

