/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public final class StringUtils {
    private StringUtils() {
    }

    public static String capitalize(String input) {
        String result = input;
        if (input != null && input.length() > 0) {
            result = input.substring(0, 1).toUpperCase();
            if (input.length() > 1) {
                result = String.valueOf(result) + input.substring(1);
            }
        }
        return result;
    }

    public static int count(String string, char ch) {
        int result = 0;
        if (string != null) {
            int i = 0;
            while (i < string.length()) {
                if (string.charAt(i) == ch) {
                    ++result;
                }
                ++i;
            }
        }
        return result;
    }

    public static boolean equals(CharSequence sequence1, CharSequence sequence2) {
        if (sequence1 == sequence2) {
            return true;
        }
        if (sequence1 == null || sequence2 == null) {
            return false;
        }
        return sequence1.equals(sequence2);
    }

    public static boolean isDeepEmpty(String string) {
        return string == null || string.trim().length() == 0;
    }

    public static boolean isEmpty(CharSequence sequence) {
        return sequence == null || sequence.length() == 0;
    }

    public static boolean isGiven(CharSequence sequence) {
        return sequence != null && sequence.length() != 0;
    }

    public static String join(Iterable<? extends Object> iterable, CharSequence separator) {
        Iterator<? extends Object> oIt;
        if (iterable == null || !(oIt = iterable.iterator()).hasNext()) {
            return "";
        }
        StringBuilder sb = new StringBuilder(String.valueOf(oIt.next()));
        while (oIt.hasNext()) {
            sb.append(separator).append(oIt.next());
        }
        return sb.toString();
    }

    public static List<String> split(String string, char separator) {
        int i;
        if (string == null) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        int fromIndex = 0;
        while ((i = string.indexOf(separator, fromIndex)) > 0) {
            result.add(string.substring(fromIndex, i));
            fromIndex = i + 1;
        }
        result.add(string.substring(fromIndex));
        return result;
    }
}

