/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.component;

import org.eclipse.core.runtime.Assert;
import org.eclipse.riena.navigation.IApplicationNode;
import org.eclipse.riena.navigation.ui.swt.component.SubApplicationSwitcherWidget;
import org.eclipse.riena.navigation.ui.swt.lnf.renderer.ShellBorderRenderer;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.riena.ui.swt.utils.WidgetIdentificationSupport;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public class SwitcherComposite
extends Composite {
    private final IApplicationNode node;

    public SwitcherComposite(Composite parent, IApplicationNode node) {
        super(parent, 0x20000000);
        this.node = node;
        this.init(parent);
    }

    private void init(Composite parent) {
        Assert.isTrue((boolean)(parent.getLayout() instanceof FormLayout));
        int padding = SwitcherComposite.getShellPadding();
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, SwitcherComposite.getSwitchterTopMargin() + padding);
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.height = SwitcherComposite.getSwitchterHeight();
        this.setLayoutData(formData);
        this.setLayout((Layout)new FillLayout());
        SubApplicationSwitcherWidget switcher = new SubApplicationSwitcherWidget(this, 0, this.node);
        WidgetIdentificationSupport.setDefaultIdentification((Widget)switcher);
    }

    public static int getSwitchterTopMargin() {
        int margin = LnfManager.getLnf().getIntegerSetting("SubApplicationSwitcher.topMargin");
        margin = SwtUtilities.convertPixelToDpiTruncate((int)margin);
        return margin;
    }

    public static int getSwitchterHeight() {
        int height = LnfManager.getLnf().getIntegerSetting("SubApplicationSwitcher.height");
        height = SwtUtilities.convertPixelToDpiTruncate((int)height);
        return height;
    }

    public static int getShellPadding() {
        ShellBorderRenderer borderRenderer = (ShellBorderRenderer)LnfManager.getLnf().getRenderer("TitlelessShell.borderRenderer");
        return borderRenderer.getCompleteBorderWidth();
    }
}

