/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.views;

import java.beans.Beans;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.log.Logger;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.riena.core.IRienaActivator;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.core.util.InvocationTargetFailure;
import org.eclipse.riena.core.util.StringUtils;
import org.eclipse.riena.internal.navigation.ui.swt.Activator;
import org.eclipse.riena.internal.navigation.ui.swt.handlers.NavigationSourceProvider;
import org.eclipse.riena.navigation.ApplicationNodeManager;
import org.eclipse.riena.navigation.IApplicationNode;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.NavigationNodeId;
import org.eclipse.riena.navigation.listener.ISubModuleNodeListener;
import org.eclipse.riena.navigation.listener.NavigationTreeObserver;
import org.eclipse.riena.navigation.listener.SubModuleNodeListener;
import org.eclipse.riena.navigation.model.SubModuleNode;
import org.eclipse.riena.navigation.ui.controllers.SubModuleController;
import org.eclipse.riena.navigation.ui.swt.presentation.SwtViewProvider;
import org.eclipse.riena.navigation.ui.swt.views.IComponentUpdateListener;
import org.eclipse.riena.navigation.ui.swt.views.INavigationNodeView;
import org.eclipse.riena.navigation.ui.swt.views.SWTModuleController;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.IRidgetContainer;
import org.eclipse.riena.ui.ridgets.SubModuleUtils;
import org.eclipse.riena.ui.ridgets.controller.IController;
import org.eclipse.riena.ui.ridgets.swt.uibinding.AbstractViewBindingDelegate;
import org.eclipse.riena.ui.ridgets.swt.uibinding.DefaultSwtBindingDelegate;
import org.eclipse.riena.ui.ridgets.swt.views.BlockHelper;
import org.eclipse.riena.ui.swt.EmbeddedTitleBar;
import org.eclipse.riena.ui.swt.facades.SWTFacade;
import org.eclipse.riena.ui.swt.lnf.LnFUpdater;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.utils.SWTBindingPropertyLocator;
import org.eclipse.riena.ui.swt.utils.SWTControlFinder;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.riena.ui.swt.utils.WidgetIdentificationSupport;
import org.eclipse.riena.ui.workarea.IWorkareaDefinition;
import org.eclipse.riena.ui.workarea.WorkareaManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.ISourceProvider;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.services.ISourceProviderService;

public abstract class SubModuleView
extends ViewPart
implements INavigationNodeView<ISubModuleNode> {
    public static final String SHARED_ID = "shared";
    private static final Logger LOGGER = Log4r.getLogger((IRienaActivator)Activator.getDefault(), SubModuleView.class);
    private final LnFUpdater lnfUpdater = LnFUpdater.getInstance();
    private static final Map<SubModuleView, SubModuleNode> FALLBACK_NODES = new HashMap<SubModuleView, SubModuleNode>();
    private static final String IS_SUB_MODULE_VIEW_COMPOSITE = "isSubModuleViewComposite";
    private final AbstractViewBindingDelegate binding;
    private SubModuleController currentController;
    private SubModuleNode rcpSubModuleNode;
    private EmbeddedTitleBar title;
    private Composite parentComposite;
    private Composite contentComposite;
    private NavigationTreeObserver navigationTreeObserver;
    private NavigationSourceProvider navigationSourceProvider;
    private SubModuleNodesListener subModuleNodeListener;
    private ISubModuleNode navigationNode;
    private IShellProvider shellProvider;
    private boolean e4Runtime = false;
    private final BlockHelper blockHelper = new BlockHelper(){

        protected IRidgetContainer getController() {
            return SubModuleView.this.getController();
        }

        protected Control getParentComposite() {
            return SubModuleView.this.getParentComposite();
        }

        protected boolean shouldRestoreFocus() {
            return SubModuleView.this.shouldRestoreFocus();
        }

        protected IRidget getFocusRidget() {
            return SubModuleView.this.getFocusRidget();
        }
    };

    public SubModuleView() {
        this.binding = this.createBinding();
        this.setShellProvider(new IShellProvider(){

            public Shell getShell() {
                return SubModuleView.this.getSite().getShell();
            }
        });
    }

    public void setE4Runtime(boolean e4Runtime) {
        this.e4Runtime = e4Runtime;
    }

    @Override
    public void addUpdateListener(IComponentUpdateListener listener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void bind(ISubModuleNode node) {
        if (this.getNavigationNode() != null && this.getController() == null) {
            this.createViewFacade();
        }
        if (this.currentController != this.getController()) {
            if (this.currentController != null) {
                if (((ISubModuleNode)this.currentController.getNavigationNode()).isDisposed() && !this.e4Runtime) {
                    return;
                }
                this.binding.unbind((IController)this.currentController);
            }
            if (this.getController() != null) {
                this.currentController = this.getController();
            }
            this.lnfUpdater.updateUIControlColors(this.getContentComposite());
            this.binding.bind((IController)this.currentController);
            this.currentController.afterBind();
        }
        this.lnfUpdater.updateUIControlsAfterBind(this.getContentComposite());
        this.activeNodeChanged((INavigationNode<?>)this.getNavigationNode());
        this.blockView(node.isBlocked());
    }

    private void activeNodeChanged(INavigationNode<?> node) {
        if (this.navigationSourceProvider == null && this.getSite() != null) {
            this.navigationSourceProvider = this.getNavigationSourceProvider();
        }
        if (this.navigationSourceProvider != null) {
            if (!this.navigationSourceProvider.isDisposed()) {
                this.navigationSourceProvider.activeNodeChanged(node);
            } else {
                this.navigationSourceProvider = null;
            }
        }
    }

    private NavigationSourceProvider getNavigationSourceProvider() {
        ISourceProvider[] sourceProviders;
        ISourceProviderService sourceProviderService = (ISourceProviderService)this.getSite().getService(ISourceProviderService.class);
        if (sourceProviderService == null) {
            return null;
        }
        ISourceProvider[] iSourceProviderArray = sourceProviders = sourceProviderService.getSourceProviders();
        int n = sourceProviders.length;
        int n2 = 0;
        while (n2 < n) {
            ISourceProvider sourceProvider = iSourceProviderArray[n2];
            if (sourceProvider instanceof NavigationSourceProvider) {
                return (NavigationSourceProvider)sourceProvider;
            }
            ++n2;
        }
        return null;
    }

    public void createPartControl(Composite parent) {
        this.parentComposite = parent;
        parent.setData(IS_SUB_MODULE_VIEW_COMPOSITE, (Object)Boolean.TRUE);
        if (!Beans.isDesignTime()) {
            this.observeRoot();
            SubModuleController controller = this.createController(this.getNavigationNode());
            if (controller != null) {
                this.setPartName(((ISubModuleNode)controller.getNavigationNode()).getLabel());
            }
            this.contentComposite = this.createContentComposite(parent);
        } else {
            this.contentComposite = parent;
        }
        this.blockHelper.registerOnContentComposite(this.contentComposite);
        this.contentComposite.setData("contentComposite", (Object)true);
        this.createWorkarea(this.contentComposite);
        if (Beans.isDesignTime()) {
            this.lnfUpdater.updateUIControls(this.getParentComposite(), true);
        } else {
            this.registerView();
            this.createViewFacade();
            this.doBinding();
        }
        if (this.getViewSite() != null && this.getViewSite().getSecondaryId() != null) {
            WidgetIdentificationSupport.setIdentification((Widget)this.contentComposite, (String[])new String[]{"subModuleView", this.getViewSite().getId(), this.getViewSite().getSecondaryId()});
        }
    }

    protected void registerView() {
        if (this.getViewSite() != null) {
            String id = this.getViewSite().getId();
            String secondaryId = this.getViewSite().getSecondaryId();
            SwtViewProvider.getInstance().registerView(id, secondaryId, this);
        }
    }

    public void dispose() {
        IApplicationNode appNode = this.getAppNode();
        if (this.navigationTreeObserver != null && appNode != null) {
            this.navigationTreeObserver.removeListenerFrom(appNode);
        }
        FALLBACK_NODES.remove(this);
        this.destroyView();
    }

    protected void destroyView() {
        super.dispose();
        if (this.getViewSite() != null) {
            String id = this.getViewSite().getId();
            String secondaryId = this.getViewSite().getSecondaryId();
            SwtViewProvider.getInstance().unregisterView(id, secondaryId);
        }
    }

    public SubModuleController getController() {
        if (this.getNavigationNode() != null && this.getNavigationNode().getNavigationNodeController() instanceof SubModuleController) {
            return (SubModuleController)this.getNavigationNode().getNavigationNodeController();
        }
        return null;
    }

    @Override
    public ISubModuleNode getNavigationNode() {
        String secondaryId;
        if (this.navigationNode != null) {
            return this.navigationNode;
        }
        if (this.getViewSite() == null) {
            return this.getFallbackNavigationNode();
        }
        String viewId = this.getViewSite().getId();
        SubModuleNode result = (SubModuleNode)this.getSubModuleNode(viewId, secondaryId = this.getViewSite().getSecondaryId());
        if (result == null) {
            result = this.getRCPSubModuleNode();
        }
        if (result == null) {
            result = this.getFallbackNavigationNode();
        }
        return result;
    }

    public void setNavigationNode(ISubModuleNode navigationNode) {
        this.navigationNode = navigationNode;
    }

    public void setFocus() {
        this.blockHelper.setFocus();
    }

    private IRidget getFocusRidget() {
        return this.currentController != null ? this.currentController.getFocusableRidget() : null;
    }

    @Override
    public void unbind() {
        SubModuleController controller = this.getController();
        if (controller != null) {
            this.binding.unbind((IController)controller);
        }
    }

    protected void addUIControl(Object uiControl) {
        this.binding.addUIControl(uiControl);
    }

    protected void addUIControl(Object uiControl, String bindingId) {
        this.binding.addUIControl(uiControl, bindingId);
    }

    protected void afterBasicCreatePartControl(Composite parent) {
    }

    protected abstract void basicCreatePartControl(Composite var1);

    protected void blockView(boolean block) {
        this.blockHelper.setBlocked(block);
    }

    protected IShellProvider getShellProvider() {
        return this.shellProvider;
    }

    private void setShellProvider(IShellProvider shellProvider) {
        this.shellProvider = shellProvider;
    }

    protected final boolean canRestoreFocus() {
        return this.blockHelper.canRestoreFocus();
    }

    protected boolean shouldRestoreFocus() {
        if (this.getController() != null && this.getController().getModuleController() instanceof SWTModuleController) {
            return !((SWTModuleController)this.getController().getModuleController()).getTree().hasFocus() && this.getController().isActivated();
        }
        return true;
    }

    protected AbstractViewBindingDelegate createBinding() {
        return new DefaultSwtBindingDelegate();
    }

    protected SubModuleController createController(ISubModuleNode node) {
        IWorkareaDefinition def;
        Assert.isNotNull((Object)node, (String)"navigation node must not be null");
        Assert.isNotNull((Object)node.getNodeId(), (String)"navigation node id must not be null");
        Assert.isNotNull((Object)node.getNodeId().getTypeId(), (String)"navigation node type id must not be null");
        SubModuleController controller = null;
        if (!SubModuleUtils.isPrepareView()) {
            controller = this.getController();
        }
        if (controller == null && (def = WorkareaManager.getInstance().getDefinition((Object)node)) != null) {
            try {
                controller = (SubModuleController)def.createController();
            }
            catch (Exception ex) {
                String message = String.format("cannnot create controller for class %s", def.getControllerClass());
                LOGGER.log(1, message, (Throwable)ex);
                throw new InvocationTargetFailure(message, (Throwable)ex);
            }
        }
        if (controller != null) {
            controller.setNavigationNode(node);
        }
        return controller;
    }

    protected void createViewFacade() {
        this.addUIControls(this.getParentComposite());
        if (this.getController() == null) {
            this.createController(this.getNavigationNode());
        }
        if (this.getController() != null) {
            this.binding.injectRidgets((IController)this.getController());
        }
    }

    protected void createWorkarea(Composite parent) {
        this.basicCreatePartControl(parent);
        this.afterBasicCreatePartControl(parent);
    }

    protected Composite getContentComposite() {
        return this.contentComposite;
    }

    protected Composite getParentComposite() {
        return this.parentComposite;
    }

    protected ISubModuleNode getSubModuleNode(String nodeId, String secondaryId) {
        boolean ignoreSharedState = secondaryId == null || !secondaryId.startsWith(SHARED_ID);
        return SwtViewProvider.getInstance().getNavigationNode(nodeId, secondaryId, ISubModuleNode.class, ignoreSharedState);
    }

    private void addMenuControl(Menu menu) {
        SWTBindingPropertyLocator locator = SWTBindingPropertyLocator.getInstance();
        int i = 0;
        while (i < menu.getItemCount()) {
            MenuItem item = menu.getItem(i);
            String bindingId = locator.locateBindingProperty((Object)item);
            if (StringUtils.isGiven((CharSequence)bindingId)) {
                this.addUIControl(item, bindingId);
            }
            if (item.getMenu() != null) {
                this.addMenuControl(item.getMenu());
            }
            ++i;
        }
    }

    protected void addUIControls(Composite composite) {
        SWTControlFinder finder = new SWTControlFinder(composite){

            public void handleBoundControl(Control control, String bindingProperty) {
                SubModuleView.this.addUIControl(control);
            }

            public void handleControl(Control control) {
                if (control.getMenu() != null) {
                    SubModuleView.this.addMenuControl(control.getMenu());
                }
                super.handleControl(control);
            }
        };
        finder.run();
    }

    private Composite createContentComposite(Composite parent) {
        Color bgColor = LnfManager.getLnf().getColor("SubModule.background");
        parent.setBackground(bgColor);
        parent.setLayout((Layout)new FormLayout());
        if (!this.isRCP()) {
            this.title = new EmbeddedTitleBar(parent, 0);
            this.addUIControl(this.title, "windowRidget");
            this.title.setWindowActive(true);
            FormData formData = new FormData();
            formData.top = new FormAttachment(0, -1);
            formData.left = new FormAttachment(0, -1);
            formData.bottom = new FormAttachment(0, this.title.getSize().y - 1);
            formData.right = new FormAttachment(100, 1);
            this.title.setLayoutData((Object)formData);
            SWTFacade.getDefault().createEmbeddedTitleBarToolTip(this.title);
        }
        Composite composite = new Composite(parent, 0x20000000);
        composite.setBackground(bgColor);
        FormData formData = new FormData();
        formData.top = this.title != null ? new FormAttachment((Control)this.title, 0, 0) : new FormAttachment(0, -1);
        formData.left = new FormAttachment(0, 0);
        formData.bottom = new FormAttachment(100);
        formData.right = new FormAttachment(100);
        composite.setLayoutData((Object)formData);
        return composite;
    }

    private void doBinding() {
        this.bind(this.getNavigationNode());
    }

    protected IApplicationNode getAppNode() {
        return ApplicationNodeManager.getApplicationNode();
    }

    private SubModuleNode getFallbackNavigationNode() {
        SubModuleNode fallbackNode = FALLBACK_NODES.get(this);
        if (fallbackNode == null) {
            fallbackNode = new SubModuleNode(new NavigationNodeId(String.valueOf(this.getClass().getName()) + FALLBACK_NODES.size()));
            FALLBACK_NODES.put(this, fallbackNode);
        }
        return fallbackNode;
    }

    private SubModuleNode getRCPSubModuleNode() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = registry.getConfigurationElementsFor("org.eclipse.riena.navigation.assemblies");
        String viewId = this.getViewSite().getId();
        return this.getRCPSubModuleNode(viewId, elements);
    }

    private SubModuleNode getRCPSubModuleNode(String viewId, IConfigurationElement[] elements) {
        int i = 0;
        while (this.rcpSubModuleNode == null && i < elements.length) {
            IConfigurationElement element = elements[i];
            if ("submodule".equals(element.getName())) {
                String typeId;
                String view = element.getAttribute("view");
                if (viewId.equals(view) && (typeId = element.getAttribute("typeId")) != null) {
                    this.rcpSubModuleNode = new SubModuleNode(new NavigationNodeId(typeId), this.getPartName());
                }
            } else if (element.getChildren().length > 0) {
                this.rcpSubModuleNode = this.getRCPSubModuleNode(viewId, element.getChildren());
            }
            ++i;
        }
        return this.rcpSubModuleNode;
    }

    private boolean isRCP() {
        this.getNavigationNode();
        return this.rcpSubModuleNode != null;
    }

    private void observeRoot() {
        IApplicationNode appNode = this.getAppNode();
        if (appNode != null) {
            Assert.isLegal((this.navigationTreeObserver == null ? 1 : 0) != 0);
            this.navigationTreeObserver = new NavigationTreeObserver();
            this.subModuleNodeListener = new SubModuleNodesListener();
            this.navigationTreeObserver.addListener((ISubModuleNodeListener)this.subModuleNodeListener);
            this.navigationTreeObserver.addListenerTo(appNode);
        }
    }

    protected String getSecondaryId() {
        return this.getViewSite().getSecondaryId();
    }

    protected void unbindActiveController() {
        this.binding.unbind((IController)this.currentController);
        this.currentController = null;
    }

    public void prepareNode(ISubModuleNode node) {
        SubModuleController controller = this.createController(node);
        if (controller != null) {
            this.binding.injectRidgets((IController)controller);
        }
    }

    private final class SubModuleNodesListener
    extends SubModuleNodeListener {
        private SubModuleNodesListener() {
        }

        public void activated(ISubModuleNode source) {
            if (source.equals(SubModuleView.this.getNavigationNode())) {
                if (SwtUtilities.isDisposed((Widget)SubModuleView.this.parentComposite)) {
                    return;
                }
                SubModuleView.this.doBinding();
            }
        }

        public void beforeDisposed(ISubModuleNode source) {
            if (SubModuleView.this.getViewSite() != null && this.disposingBoundNode(source)) {
                SubModuleView.this.unbindActiveController();
            }
        }

        protected boolean disposingBoundNode(ISubModuleNode source) {
            return SubModuleView.this.getSecondaryId().startsWith(SubModuleView.SHARED_ID) && SubModuleView.this.currentController != null && source.equals(SubModuleView.this.currentController.getNavigationNode());
        }

        public void block(ISubModuleNode source, boolean block) {
            if (source.equals(SubModuleView.this.getNavigationNode())) {
                SubModuleView.this.blockView(block);
            }
        }

        public void nodeIdChange(ISubModuleNode source, NavigationNodeId oldId, NavigationNodeId newId) {
            if (source.equals(SubModuleView.this.getNavigationNode())) {
                SwtViewProvider.getInstance().replaceNavigationNodeId((INavigationNode<?>)source, oldId, newId);
            }
        }
    }
}

