/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.sample.snippets;

import org.eclipse.riena.beans.common.WordNode;
import org.eclipse.riena.ui.ridgets.IColumnFormatter;
import org.eclipse.riena.ui.ridgets.IGroupedTreeTableRidget;
import org.eclipse.riena.ui.ridgets.swt.ColumnFormatter;
import org.eclipse.riena.ui.ridgets.swt.SwtRidgetFactory;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;

public class SnippetTreeTableRidget003 {
    public SnippetTreeTableRidget003(final Shell shell) {
        Tree tree = new Tree((Composite)shell, 65538);
        int i = 0;
        while (i < 2) {
            TreeColumn tc = new TreeColumn(tree, -1);
            tc.setWidth(200);
            ++i;
        }
        IGroupedTreeTableRidget treeTableRidget = (IGroupedTreeTableRidget)SwtRidgetFactory.createRidget((Object)tree);
        Object[] roots = this.createTreeInput();
        String[] columnValues = new String[]{"word", "upperCase"};
        String[] columnHeaders = new String[]{"Word", "Uppercase"};
        treeTableRidget.setGroupingEnabled(true);
        treeTableRidget.setRootsVisible(false);
        treeTableRidget.setColumnFormatter(0, (IColumnFormatter)new ColumnFormatter(){

            public Color getForeground(Object element) {
                String word = ((WordNode)element).getWord();
                if ('B' == word.charAt(0)) {
                    return shell.getDisplay().getSystemColor(3);
                }
                return null;
            }
        });
        treeTableRidget.setColumnFormatter(1, (IColumnFormatter)new ColumnFormatter(){

            public Image getImage(Object element) {
                if (((WordNode)element).isUpperCase()) {
                    return shell.getDisplay().getSystemImage(8);
                }
                return null;
            }
        });
        treeTableRidget.bindToModel(roots, WordNode.class, "children", "parent", columnValues, columnHeaders);
        treeTableRidget.expandAll();
    }

    public static void main(String[] args) {
        Display display = Display.getDefault();
        try {
            Shell shell = new Shell();
            shell.setLayout((Layout)new FillLayout());
            new SnippetTreeTableRidget003(shell);
            shell.pack();
            shell.open();
            while (!shell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        }
        finally {
            display.dispose();
        }
    }

    private WordNode[] createTreeInput() {
        WordNode root = new WordNode("Words");
        WordNode bTowns = new WordNode(root, "B");
        new WordNode(bTowns, "Boring");
        new WordNode(bTowns, "Buchanan");
        WordNode cTowns = new WordNode(root, "C");
        new WordNode(cTowns, "Cedar Mill").setUpperCase(true);
        new WordNode(cTowns, "Crater Lake");
        WordNode dTowns = new WordNode(root, "D");
        new WordNode(dTowns, "Dunes City");
        new WordNode(dTowns, "Damascus");
        return new WordNode[]{root};
    }
}

