/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt.layout;

import junit.framework.TestCase;
import org.eclipse.riena.core.test.collect.UITestCase;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.ui.swt.layout.DpiGridData;
import org.eclipse.riena.ui.swt.layout.DpiGridLayout;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

@UITestCase
public class DpiGridLayoutTest
extends TestCase {
    private Shell shell;

    protected void setUp() throws Exception {
        super.setUp();
        this.shell = new Shell();
        ReflectionUtils.setHidden(SwtUtilities.class, (String)"cachedDpiFactors", (Object)new float[]{0.0f, 0.0f});
    }

    protected void tearDown() throws Exception {
        SwtUtilities.dispose((Widget)this.shell);
        ReflectionUtils.setHidden(SwtUtilities.class, (String)"cachedDpiFactors", (Object)new float[]{0.0f, 0.0f});
        super.tearDown();
    }

    public void testGetMarginPoint() throws Exception {
        ReflectionUtils.setHidden(SwtUtilities.class, (String)"cachedDpiFactors", (Object)new float[]{2.0f, 3.0f});
        DpiGridLayout layout = new DpiGridLayout();
        layout.marginBottom = 2;
        layout.marginHeight = 3;
        layout.marginTop = 4;
        layout.marginLeft = 10;
        layout.marginWidth = 11;
        layout.marginRight = 12;
        Point point = (Point)ReflectionUtils.invokeHidden((Object)layout, (String)"getMarginPoint", (Object[])new Object[0]);
        DpiGridLayoutTest.assertEquals((int)88, (int)point.x);
        DpiGridLayoutTest.assertEquals((int)36, (int)point.y);
    }

    public void testGetDpiGridData() throws Exception {
        ReflectionUtils.setHidden(SwtUtilities.class, (String)"cachedDpiFactors", (Object)new float[]{2.0f, 3.0f});
        DpiGridLayout layout = new DpiGridLayout();
        Label label = new Label((Composite)this.shell, 0);
        DpiGridData data = (DpiGridData)ReflectionUtils.invokeHidden((Object)layout, (String)"getDpiGridData", (Object[])new Object[]{label});
        DpiGridLayoutTest.assertNull((Object)data);
        GridData gridData = new GridData(12, 34);
        label.setLayoutData((Object)gridData);
        data = (DpiGridData)ReflectionUtils.invokeHidden((Object)layout, (String)"getDpiGridData", (Object[])new Object[]{label});
        DpiGridLayoutTest.assertNotNull((Object)data);
        DpiGridLayoutTest.assertEquals((int)24, (int)data.widthHint);
        DpiGridLayoutTest.assertEquals((int)102, (int)data.heightHint);
        DpiGridLayoutTest.assertSame((Object)gridData, (Object)label.getLayoutData());
        DpiGridLayoutTest.assertEquals((int)12, (int)gridData.widthHint);
        DpiGridLayoutTest.assertEquals((int)34, (int)gridData.heightHint);
        gridData.widthHint = 10;
        data = (DpiGridData)ReflectionUtils.invokeHidden((Object)layout, (String)"getDpiGridData", (Object[])new Object[]{label});
        DpiGridLayoutTest.assertNotNull((Object)data);
        DpiGridLayoutTest.assertEquals((int)20, (int)data.widthHint);
        DpiGridLayoutTest.assertEquals((int)102, (int)data.heightHint);
        DpiGridLayoutTest.assertSame((Object)gridData, (Object)label.getLayoutData());
        DpiGridLayoutTest.assertEquals((int)10, (int)gridData.widthHint);
        DpiGridLayoutTest.assertEquals((int)34, (int)gridData.heightHint);
        gridData.heightHint = 1;
        data = (DpiGridData)ReflectionUtils.invokeHidden((Object)layout, (String)"getDpiGridData", (Object[])new Object[]{label});
        DpiGridLayoutTest.assertNotNull((Object)data);
        DpiGridLayoutTest.assertEquals((int)20, (int)data.widthHint);
        DpiGridLayoutTest.assertEquals((int)3, (int)data.heightHint);
        DpiGridLayoutTest.assertSame((Object)gridData, (Object)label.getLayoutData());
        DpiGridLayoutTest.assertEquals((int)10, (int)gridData.widthHint);
        DpiGridLayoutTest.assertEquals((int)1, (int)gridData.heightHint);
    }

    public void testGetData() throws Exception {
        ReflectionUtils.setHidden(SwtUtilities.class, (String)"cachedDpiFactors", (Object)new float[]{2.0f, 3.0f});
        DpiGridLayout layout = new DpiGridLayout();
        Label label = new Label((Composite)this.shell, 0);
        GridData gridData = new GridData(12, 34);
        label.setLayoutData((Object)gridData);
        Control[][] grid = new Control[1][1];
        grid[0][0] = label;
        DpiGridData data = (DpiGridData)ReflectionUtils.invokeHidden((Object)layout, (String)"getData", (Object[])new Object[]{grid, 0, 0, 1, 1, true});
        data = (DpiGridData)ReflectionUtils.invokeHidden((Object)layout, (String)"getDpiGridData", (Object[])new Object[]{label});
        DpiGridLayoutTest.assertNotNull((Object)data);
        DpiGridLayoutTest.assertEquals((int)24, (int)data.widthHint);
        DpiGridLayoutTest.assertEquals((int)102, (int)data.heightHint);
        DpiGridLayoutTest.assertSame((Object)gridData, (Object)label.getLayoutData());
        DpiGridLayoutTest.assertEquals((int)12, (int)gridData.widthHint);
        DpiGridLayoutTest.assertEquals((int)34, (int)gridData.heightHint);
    }
}

