/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import com.ibm.icu.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Pattern;
import org.eclipse.core.databinding.BindingException;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.riena.core.util.RAPDetector;
import org.eclipse.riena.internal.ui.ridgets.swt.SegmentedString;
import org.eclipse.riena.internal.ui.ridgets.swt.TextRidget;
import org.eclipse.riena.ui.core.marker.ValidationTime;
import org.eclipse.riena.ui.ridgets.IDateTextRidget;
import org.eclipse.riena.ui.ridgets.databinding.DateToStringConverter;
import org.eclipse.riena.ui.ridgets.databinding.StringToDateConverter;
import org.eclipse.riena.ui.ridgets.validation.ValidDate;
import org.eclipse.riena.ui.ridgets.validation.ValidIntermediateDate;
import org.eclipse.riena.ui.swt.DatePickerComposite;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class DateTextRidget
extends TextRidget
implements IDateTextRidget {
    private static final int Y2K_CUTOFF = 30;
    private final DateVerifyListener verifyListener = new DateVerifyListener();
    private final KeyListener keyListener = new DateKeyListener();
    private final FocusListener focusListener = new DateFocusListener();
    private String pattern;
    private ValidDate validDateRule;
    private ValidIntermediateDate validIntermediateDateRule;
    private StringToDateConverter uiControlToModelconverter;
    private DateToStringConverter modelToUIControlConverter;

    public DateTextRidget() {
        this.setFormat("dd.MM.yyyy");
    }

    @Override
    protected void checkUIControl(Object uiControl) {
        if (uiControl == null) {
            return;
        }
        boolean isValidDatePicker = this.isValidType(uiControl, DatePickerComposite.class);
        if (isValidDatePicker) {
            DatePickerComposite datePicker = (DatePickerComposite)uiControl;
            datePicker.setDateConverterStrategy((DatePickerComposite.IDateConverterStrategy)new RidgetAwareDateConverterStrategy());
        }
        if (!this.isValidType(uiControl, Text.class) && !isValidDatePicker) {
            throw new BindingException(String.format("uiControl must be a '%s' or a '%s' but was a %s ", Text.class.getSimpleName(), DatePickerComposite.class.getSimpleName(), uiControl.getClass().getSimpleName()));
        }
    }

    @Override
    protected final synchronized void addListeners(Text control) {
        control.addVerifyListener((VerifyListener)this.verifyListener);
        control.addKeyListener(this.keyListener);
        control.addFocusListener(this.focusListener);
        super.addListeners(control);
    }

    @Override
    protected final String getTextBasedOnMarkerState(String value) {
        if (this.isOutputOnly() && !this.isNotEmpty(value)) {
            return "";
        }
        return super.getTextBasedOnMarkerState(value);
    }

    @Override
    protected Text getTextWidget() {
        Control control = super.getUIControl();
        Text result = control instanceof DatePickerComposite ? ((DatePickerComposite)control).getTextfield() : (Text)control;
        return result;
    }

    @Override
    protected boolean isNotEmpty(String input) {
        boolean result = false;
        if (this.pattern != null) {
            String emptyString = new SegmentedString(this.pattern).toString();
            result = !emptyString.equals(input);
        }
        return result;
    }

    @Override
    protected final synchronized void removeListeners(Text control) {
        control.removeFocusListener(this.focusListener);
        control.removeKeyListener(this.keyListener);
        control.removeVerifyListener((VerifyListener)this.verifyListener);
        super.removeListeners(control);
    }

    @Override
    protected void updateEditable() {
        super.updateEditable();
        Control control = this.getUIControl();
        if (control instanceof DatePickerComposite) {
            ((DatePickerComposite)control).updateButtonEnablement();
        }
    }

    public final void setFormat(String datePattern) {
        boolean isBound;
        this.removeValidationRule((IValidator)this.validDateRule);
        this.removeValidationRule((IValidator)this.validIntermediateDateRule);
        this.pattern = datePattern;
        this.validDateRule = new ValidDate(this.pattern);
        this.validIntermediateDateRule = new ValidIntermediateDate(this.pattern);
        this.uiControlToModelconverter = new StringToDateConverter(this.pattern);
        this.modelToUIControlConverter = new DateToStringConverter(this.pattern);
        this.addValidationRule((IValidator)this.validDateRule, ValidationTime.ON_UPDATE_TO_MODEL);
        this.addValidationRule((IValidator)this.validIntermediateDateRule, ValidationTime.ON_UI_CONTROL_EDIT);
        this.setUIControlToModelConverter((IConverter)this.uiControlToModelconverter);
        this.setModelToUIControlConverter((IConverter)this.modelToUIControlConverter);
        this.getValueBindingSupport().rebindToModel();
        boolean bl = isBound = this.getValueBindingSupport().getModelObservable() != null;
        if (isBound && this.getValueBindingSupport().getModelObservable().getValueType() == Date.class) {
            this.updateFromModel();
        } else {
            this.setText(new SegmentedString(this.pattern).toString());
        }
    }

    @Override
    public synchronized void setText(String text) {
        String newText = this.checkAndFormatValue(text);
        super.setText(newText);
    }

    private boolean isValidType(Object uiControl, Class<?> type) {
        return uiControl != null && type.isAssignableFrom(uiControl.getClass());
    }

    private String checkAndFormatValue(String text) {
        SegmentedString ss = new SegmentedString(this.pattern);
        if (text != null) {
            if (!ss.isValidPartialMatch(text)) {
                String msg = String.format("'%s' is no partial match for '%s'", text, this.pattern);
                throw new IllegalArgumentException(msg);
            }
            ss.insert(0, text);
        }
        return ss.toString();
    }

    private String computeAutoFill(String input) {
        String yyyy;
        String result = null;
        int index = this.pattern.lastIndexOf("yyyy");
        if (index != -1 && this.pattern.length() == input.length() && Pattern.matches("  \\d\\d", yyyy = input.substring(index, index + 4))) {
            String yy = yyyy.substring(2);
            yyyy = Integer.parseInt(yy) < 30 ? "20" + yy : "19" + yy;
            result = String.valueOf(input.substring(0, index)) + yyyy + input.substring(index + 4);
        }
        return result;
    }

    private synchronized void forceTextToControl(Text control, String text) {
        this.verifyListener.setEnabled(false);
        control.setText(text);
        this.verifyListener.setEnabled(true);
    }

    private void transferTextToBean(Text control) {
        String autoFill = this.computeAutoFill(control.getText());
        if (autoFill != null) {
            this.forceTextToControl(control, autoFill);
        }
    }

    private final class DateFocusListener
    extends FocusAdapter {
        private DateFocusListener() {
        }

        public void focusLost(FocusEvent e) {
            DateTextRidget.this.transferTextToBean((Text)e.widget);
        }
    }

    private final class DateKeyListener
    extends KeyAdapter {
        private boolean shiftDown = false;

        private DateKeyListener() {
        }

        public void keyReleased(KeyEvent e) {
            if (131072 == e.keyCode) {
                this.shiftDown = false;
            }
        }

        public void keyPressed(KeyEvent e) {
            Text control = (Text)e.widget;
            if (131072 == e.keyCode) {
                this.shiftDown = true;
            } else {
                String text = control.getText();
                int caret = control.getCaretPosition();
                int selectionCount = control.getSelectionCount();
                if (0x1000003 == e.keyCode && selectionCount == 0 && !this.shiftDown) {
                    e.doit = false;
                    SegmentedString ss = new SegmentedString(DateTextRidget.this.pattern, text);
                    int index = ss.findNewCursorPosition(caret, -1);
                    control.setSelection(index);
                } else if (0x1000004 == e.keyCode && selectionCount == 0 && !this.shiftDown) {
                    e.doit = false;
                    SegmentedString ss = new SegmentedString(DateTextRidget.this.pattern, text);
                    int index = ss.findNewCursorPosition(caret, 1);
                    control.setSelection(index);
                } else if (127 == e.keyCode && selectionCount == 0 && !this.shiftDown) {
                    if (caret < text.length() && SegmentedString.isSeparator(text.charAt(caret))) {
                        e.doit = false;
                        SegmentedString ss = new SegmentedString(DateTextRidget.this.pattern, text);
                        int index = ss.findNewCursorPosition(caret, 1);
                        if (index < text.length() && SegmentedString.isDigit(text.charAt(index))) {
                            ss.delete(caret, index);
                            DateTextRidget.this.forceTextToControl(control, ss.toString());
                            ++index;
                        }
                        control.setSelection(index);
                    }
                } else if ('\b' == e.character && selectionCount == 0 && !this.shiftDown) {
                    if (caret > 0 && SegmentedString.isSeparator(text.charAt(caret - 1))) {
                        e.doit = false;
                        SegmentedString ss = new SegmentedString(DateTextRidget.this.pattern, text);
                        int index = ss.findNewCursorPosition(caret, -1);
                        if (index > 0 && SegmentedString.isDigit(text.charAt(index - 1))) {
                            ss.delete(index - 1, caret - 1);
                            DateTextRidget.this.forceTextToControl(control, ss.toString());
                        }
                        control.setSelection(index);
                    }
                } else if ('\r' == e.character) {
                    DateTextRidget.this.transferTextToBean((Text)e.widget);
                }
            }
        }
    }

    private final class DateVerifyListener
    implements VerifyListener {
        private volatile boolean isEnabled = true;

        private DateVerifyListener() {
        }

        public void setEnabled(boolean isEnabled) {
            this.isEnabled = isEnabled;
        }

        public void verifyText(VerifyEvent e) {
            if (!e.doit || !this.isEnabled) {
                return;
            }
            Text control = (Text)e.widget;
            String oldText = control.getText();
            int start = e.start;
            int end = e.end;
            char character = e.character;
            if (character == '\u0000' && RAPDetector.isRAPavailable()) {
                Point sel = control.getSelection();
                if (oldText.length() > e.text.length()) {
                    character = '\b';
                    start = this.findChangePos(oldText, e.text);
                    end = start + Math.max(sel.y - sel.x, 1);
                } else {
                    int pos = sel.x;
                    if (pos >= e.text.length()) {
                        pos = e.text.length() - 1;
                    }
                    character = e.text.charAt(pos);
                    start = sel.x;
                    end = sel.y;
                }
            }
            int oldPos = control.getCaretPosition();
            int newPos = -1;
            SegmentedString ss = new SegmentedString(DateTextRidget.this.pattern, oldText);
            if (character == '\b' || e.keyCode == 127) {
                newPos = ss.delete(start, end - 1);
                if (newPos == -1) {
                    newPos = character == '\b' ? start : end;
                }
            } else if (SegmentedString.isDigit(character)) {
                newPos = end - start > 0 ? ss.replace(start, end - 1, e.text) : ss.insert(start, String.valueOf(character));
            } else if (SegmentedString.isSeparator(character)) {
                newPos = end - start > 0 ? ss.replace(start, end - 1, String.valueOf(character)) : ss.insert(start, String.valueOf(character));
            }
            e.doit = false;
            if (newPos != -1) {
                DateTextRidget.this.forceTextToControl(control, ss.toString());
                control.setSelection(newPos);
                if (newPos == oldPos && oldText.equals(ss.toString())) {
                    DateTextRidget.this.flash();
                }
            } else {
                DateTextRidget.this.flash();
            }
        }

        private int findChangePos(String oldText, String newText) {
            int length = newText.length();
            int i = 0;
            while (i < length) {
                if (oldText.charAt(i) != newText.charAt(i)) {
                    return i;
                }
                ++i;
            }
            return length;
        }
    }

    public final class RidgetAwareDateConverterStrategy
    implements DatePickerComposite.IDateConverterStrategy {
        public void setDateToTextField(Date date) {
            SimpleDateFormat format = new SimpleDateFormat(DateTextRidget.this.pattern);
            String text = format.format(date);
            DateTextRidget.this.setText(text);
        }

        public Date getDateFromTextField(String dateString) {
            Date result;
            try {
                SimpleDateFormat format = new SimpleDateFormat(DateTextRidget.this.pattern);
                result = format.parse(dateString);
            }
            catch (Exception exception) {
                result = null;
            }
            return result;
        }
    }
}

