/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.riena.ui.ridgets.IRidgetContentFilter;
import org.eclipse.riena.ui.ridgets.IRidgetContentFilterHolder;

public class StructuredViewerFilterHolder
implements IRidgetContentFilterHolder<StructuredViewer> {
    private final Map<IRidgetContentFilter, ViewerFilter> ridgetFilterToViewerFilter = new HashMap<IRidgetContentFilter, ViewerFilter>();
    private final List<StructuredViewer> activeOnViewers = new ArrayList<StructuredViewer>();

    public void add(final IRidgetContentFilter filter) {
        if (this.ridgetFilterToViewerFilter.containsKey(filter)) {
            return;
        }
        ViewerFilter viewerFilter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return filter.isElementVisible(parentElement, element);
            }
        };
        this.ridgetFilterToViewerFilter.put(filter, viewerFilter);
        for (StructuredViewer structuredViewer : this.activeOnViewers) {
            if (structuredViewer == null) continue;
            structuredViewer.addFilter(viewerFilter);
            structuredViewer.refresh();
        }
    }

    public void remove(IRidgetContentFilter filter) {
        ViewerFilter viewerFilter = this.ridgetFilterToViewerFilter.remove(filter);
        for (StructuredViewer structuredViewer : this.activeOnViewers) {
            if (viewerFilter == null) continue;
            structuredViewer.removeFilter(viewerFilter);
            structuredViewer.refresh();
        }
    }

    public void activate(StructuredViewer structuredViewer) {
        if (structuredViewer == null) {
            return;
        }
        this.activeOnViewers.add(structuredViewer);
        for (ViewerFilter viewerFilter : this.ridgetFilterToViewerFilter.values()) {
            structuredViewer.addFilter(viewerFilter);
            structuredViewer.refresh();
        }
    }

    public void deactivate(StructuredViewer structuredViewer) {
        if (structuredViewer == null) {
            return;
        }
        this.activeOnViewers.remove(structuredViewer);
        for (ViewerFilter viewerFilter : this.ridgetFilterToViewerFilter.values()) {
            structuredViewer.removeFilter(viewerFilter);
            structuredViewer.refresh();
        }
    }
}

