/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt;

import org.eclipse.riena.ui.swt.lnf.IgnoreLnFUpdater;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

@IgnoreLnFUpdater(value={"background"})
public abstract class AbstractStatuslineComposite
extends Composite {
    private static final int LEFT_RIGHT_MARGIN = 5;
    private static final int TOP_BOTTOM_MARGIN = 0;

    public AbstractStatuslineComposite(Composite parent, int style) {
        super(parent, style);
        this.setBackground(LnfManager.getLnf().getColor("statusline.background"));
        this.setContentsLayout();
        this.createContents();
    }

    protected abstract void createContents();

    protected void setContentsLayout() {
        RowLayout rowLayout = new RowLayout();
        rowLayout.justify = false;
        rowLayout.marginLeft = SwtUtilities.convertXToDpiTruncate(this.getLeftMargin());
        rowLayout.marginTop = SwtUtilities.convertYToDpiTruncate(this.getTopMargin());
        rowLayout.marginRight = SwtUtilities.convertXToDpiTruncate(this.getRightMargin());
        rowLayout.marginBottom = SwtUtilities.convertYToDpiTruncate(this.getBottomMargin());
        rowLayout.pack = true;
        this.setLayout((Layout)rowLayout);
    }

    protected int getTopMargin() {
        return 0;
    }

    protected int getBottomMargin() {
        return 0;
    }

    protected int getLeftMargin() {
        return 5;
    }

    protected int getRightMargin() {
        return 5;
    }
}

