/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt.lnf.renderer;

import org.eclipse.core.runtime.Assert;
import org.eclipse.riena.core.util.StringUtils;
import org.eclipse.riena.ui.swt.ModuleTitleBar;
import org.eclipse.riena.ui.swt.facades.GCFacade;
import org.eclipse.riena.ui.swt.lnf.AbstractLnfRenderer;
import org.eclipse.riena.ui.swt.lnf.FlasherSupportForRenderer;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.lnf.renderer.HoverBorderRenderer;
import org.eclipse.riena.ui.swt.lnf.rienadefault.RienaDefaultLnf;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Control;

public class EmbeddedTitlebarRenderer
extends AbstractLnfRenderer {
    private static final int TITLEBAR_LABEL_PADDING_X = SwtUtilities.convertXToDpiTruncate(5);
    private static final int TITLEBAR_LABEL_PADDING_TOP = SwtUtilities.convertYToDpiTruncate(4);
    private static final int TITLEBAR_ICON_TEXT_GAP = SwtUtilities.convertXToDpiTruncate(4);
    private Color defaultColor = null;
    private Control control;
    private Image image = null;
    private String title;
    private boolean active = false;
    private boolean pressed = false;
    private boolean hover = false;
    private boolean closeable = false;
    private boolean closeButtonPressed;
    private boolean closeButtonHover;
    private final FlasherSupportForRenderer flasherSupport = new FlasherSupportForRenderer(this, new MarkerUpdater());

    @Override
    public void dispose() {
        SwtUtilities.dispose((Resource)this.getImage());
        SwtUtilities.dispose((Resource)this.defaultColor);
        this.control = null;
    }

    public Point computeSize(GC gc, int wHint, int hHint) {
        Font font = this.getTitlebarFont();
        gc.setFont(font);
        FontMetrics fontMetrics = gc.getFontMetrics();
        int h = fontMetrics.getHeight() + TITLEBAR_LABEL_PADDING_TOP * 2;
        return new Point(wHint, h);
    }

    protected Font getTitlebarFont() {
        RienaDefaultLnf lnf = LnfManager.getLnf();
        Font font = lnf.getFont("EmbeddedTitlebar.font");
        return font;
    }

    protected void drawBackground(GC gc, int x, int y, int w, int h) {
        Color startColor = this.getColor("EmbeddedTitlebar.activeBackgroundStartColor", "EmbeddedTitlebar.passiveBackgroundStartColor", null);
        Color endColor = this.getColor("EmbeddedTitlebar.activeBackgroundEndColor", "EmbeddedTitlebar.passiveBackgroundEndColor", null);
        gc.setForeground(startColor);
        gc.setBackground(endColor);
        if (this.isPressed() && !this.isActive() && !this.isCloseButtonPressed()) {
            gc.fillRectangle(x, y, w, h);
        } else {
            gc.fillGradientRectangle(x, y, w, h, true);
        }
    }

    protected void drawBorder(GC gc) {
        gc.setForeground(this.getBorderColor());
        Rectangle b = this.getBounds();
        gc.drawRectangle(b.x, b.y, b.width - 1, b.height - 1);
    }

    @Override
    public void paint(GC gc, Object value) {
        String text;
        Assert.isNotNull((Object)gc);
        Assert.isNotNull((Object)value);
        Assert.isTrue((boolean)(value instanceof Control));
        this.control = (Control)value;
        if (this.getBounds() == null) {
            return;
        }
        GCFacade gcFacade = GCFacade.getDefault();
        gcFacade.setAdvanced(gc, true);
        gcFacade.setAntialias(gc, 1);
        Font font = this.getTitlebarFont();
        gc.setFont(font);
        int x = this.getBounds().x;
        int y = this.getBounds().y;
        int w = this.getBounds().width;
        int h = this.getBounds().height;
        this.drawBackground(gc, x, y, w, h);
        this.drawBorder(gc);
        Rectangle closeBounds = this.computeCloseButtonBounds();
        if (this.isCloseable()) {
            Image closeImage = this.getCloseButtonImage();
            gc.drawImage(closeImage, closeBounds.x, closeBounds.y);
        } else {
            closeBounds.x = 0;
            closeBounds.y = 0;
            closeBounds.width = 0;
            closeBounds.height = 0;
        }
        x = this.getBounds().x + TITLEBAR_LABEL_PADDING_X;
        if (this.getImage() != null) {
            Rectangle imageBounds = this.getImage().getBounds();
            y = this.getBounds().y + (this.getHeight() - imageBounds.height) / 2;
            gc.drawImage(this.getImage(), x, ++y);
            x += imageBounds.width + TITLEBAR_ICON_TEXT_GAP;
        }
        if (!StringUtils.isEmpty((CharSequence)(text = this.getTitle()))) {
            Color fgColor = this.getColor("EmbeddedTitlebar.foreground", "EmbeddedTitlebar.passiveForeground", "EmbeddedTitlebar.disabledForeground");
            gc.setForeground(fgColor);
            int y2 = (this.getHeight() - gc.getFontMetrics().getHeight()) / 2;
            y = this.getBounds().y + y2;
            text = this.getClippedText(gc, text);
            gc.drawText(text, x, ++y, true);
        }
        if (this.control instanceof ModuleTitleBar && this.isHover() && (!this.isPressed() || this.isActive())) {
            x = this.getBounds().x;
            y = this.getBounds().y;
            w = this.getBounds().width;
            h = this.getHeight();
            this.getHoverBorderRenderer().setBounds(x, y, w, h);
            this.getHoverBorderRenderer().paint(gc, null);
        }
        this.getFlasherSupport().startFlasher();
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean isPressed() {
        return this.pressed;
    }

    public void setPressed(boolean pressed) {
        this.pressed = pressed;
    }

    public boolean isHover() {
        return this.hover;
    }

    public void setHover(boolean hover) {
        this.hover = hover;
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    protected int getHeight() {
        return this.getBounds().height - 1;
    }

    protected int getWidth() {
        return this.getBounds().width - 1;
    }

    protected HoverBorderRenderer getHoverBorderRenderer() {
        return (HoverBorderRenderer)LnfManager.getLnf().getRenderer("SubModuleView.hoverBorderRenderer");
    }

    public boolean isCloseable() {
        return this.closeable;
    }

    public void setCloseable(boolean closeable) {
        this.closeable = closeable;
    }

    protected Rectangle computeCloseButtonBounds() {
        Rectangle closeBounds = new Rectangle(0, 0, 0, 0);
        Image closeImage = this.getCloseButtonImage();
        if (closeImage == null) {
            return closeBounds;
        }
        Rectangle bounds = this.getBounds();
        if (bounds != null) {
            closeBounds.width = closeImage.getBounds().width;
            closeBounds.height = closeImage.getBounds().height;
            closeBounds.x = bounds.x + this.getWidth() - closeBounds.width - TITLEBAR_LABEL_PADDING_X;
            closeBounds.y = bounds.y + (this.getHeight() - closeBounds.height) / 2;
        }
        return closeBounds;
    }

    public boolean isInsideCloseButton(Point pt) {
        Rectangle closeBounds = this.computeCloseButtonBounds();
        return closeBounds.contains(pt);
    }

    protected Image getCloseButtonImage() {
        RienaDefaultLnf lnf = LnfManager.getLnf();
        String key = "EmbeddedTitlebar.closeIcon";
        if (this.isEnabled()) {
            if (this.isCloseButtonPressed()) {
                key = "EmbeddedTitlebar.closeHoverSelectedIcon";
            } else if (this.isCloseButtonHover()) {
                key = "EmbeddedTitlebar.closeHoverIcon";
            }
        } else {
            key = "EmbeddedTitlebar.closeInactiveIcon";
        }
        Image closeImage = lnf.getImage(key);
        return closeImage;
    }

    public boolean isCloseButtonPressed() {
        return this.closeButtonPressed;
    }

    public void setCloseButtonPressed(boolean pressed) {
        this.closeButtonPressed = pressed;
    }

    public boolean isCloseButtonHover() {
        return this.closeButtonHover;
    }

    public void setCloseButtonHover(boolean hover) {
        this.closeButtonHover = hover;
    }

    public Rectangle computeTextBounds(GC gc) {
        Rectangle textBounds = new Rectangle(0, 0, 0, 0);
        Rectangle bounds = this.getBounds();
        if (bounds != null) {
            textBounds.x = bounds.x + TITLEBAR_LABEL_PADDING_X;
            if (this.getImage() != null) {
                textBounds.x += this.getImage().getBounds().width + TITLEBAR_ICON_TEXT_GAP;
            }
            textBounds.width = this.getWidth() - (textBounds.x - bounds.x) - TITLEBAR_LABEL_PADDING_TOP;
            Font font = this.getTitlebarFont();
            gc.setFont(font);
            FontMetrics fontMetrics = gc.getFontMetrics();
            textBounds.height = fontMetrics.getHeight();
            textBounds.y = bounds.y + (bounds.height - textBounds.height) / 2;
        }
        return textBounds;
    }

    public String getClippedText(GC gc, String text) {
        if (StringUtils.isEmpty((CharSequence)text)) {
            return text;
        }
        Rectangle textBounds = this.computeTextBounds(gc);
        int maxWidth = textBounds.width;
        if (this.isCloseable()) {
            Rectangle closeBounds = this.computeCloseButtonBounds();
            maxWidth -= closeBounds.width;
        }
        Font font = this.getTitlebarFont();
        gc.setFont(font);
        return SwtUtilities.clipText(gc, text, maxWidth);
    }

    protected Color getBorderColor() {
        return this.getColor("EmbeddedTitlebar.activeBorderColor", "EmbeddedTitlebar.passiveBorderColor", "EmbeddedTitlebar.disabledBorderColor");
    }

    protected Color getColor(String activeColorKey, String passiveColorKey, String disabeldColorKey) {
        RienaDefaultLnf lnf;
        Color color = null;
        String colorKey = this.getKey(activeColorKey, passiveColorKey, disabeldColorKey);
        if (colorKey == null) {
            colorKey = activeColorKey;
        }
        if ((color = (lnf = LnfManager.getLnf()).getColor(colorKey)) == null) {
            return this.getDefaultColor();
        }
        return color;
    }

    private Color getDefaultColor() {
        if (this.defaultColor == null) {
            this.defaultColor = new Color(null, 0, 0, 0);
        }
        return this.defaultColor;
    }

    private String getKey(String activeKey, String passiveKey, String disabledKey) {
        String key = null;
        key = this.isEnabled() ? (this.isActive() || this.getFlasherSupport().isProcessMarkerVisible() ? activeKey : passiveKey) : disabledKey;
        if (key == null) {
            key = activeKey;
        }
        if (key == null) {
            key = passiveKey;
        }
        if (key == null) {
            key = disabledKey;
        }
        return key;
    }

    protected FlasherSupportForRenderer getFlasherSupport() {
        return this.flasherSupport;
    }

    private class MarkerUpdater
    implements Runnable {
        private MarkerUpdater() {
        }

        @Override
        public void run() {
            if (EmbeddedTitlebarRenderer.this.control != null && !EmbeddedTitlebarRenderer.this.control.isDisposed()) {
                EmbeddedTitlebarRenderer.this.control.redraw();
            }
        }
    }
}

