/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.core.IRienaActivator;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.core.util.StringUtils;
import org.eclipse.riena.internal.ui.swt.Activator;
import org.eclipse.riena.ui.common.IComplexComponent;
import org.eclipse.riena.ui.ridgets.uibinding.IBindingPropertyLocator;
import org.eclipse.riena.ui.swt.utils.IPropertyNameProvider;
import org.eclipse.riena.ui.swt.utils.SWTControlFinder;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

public final class SWTBindingPropertyLocator
implements IBindingPropertyLocator {
    public static final String BINDING_PROPERTY = "binding_property";
    private static SWTBindingPropertyLocator locator;

    private SWTBindingPropertyLocator() {
    }

    public static SWTBindingPropertyLocator getInstance() {
        if (locator == null) {
            locator = new SWTBindingPropertyLocator();
        }
        return locator;
    }

    public static List<Object> getControlsWithBindingProperty(Composite composite) {
        final HashMap id2control = new HashMap();
        SWTControlFinder finder = new SWTControlFinder(composite){

            @Override
            public void handleBoundControl(Control control, String bindingProperty) {
                if (id2control.containsKey(bindingProperty)) {
                    String msg = String.format("conflict: control with id '%s' already defined: %s, %s", bindingProperty, id2control.get(bindingProperty), control);
                    throw new RuntimeException(msg);
                }
                id2control.put(bindingProperty, control);
            }
        };
        finder.run();
        return new ArrayList<Object>(id2control.values());
    }

    public boolean hasBindingProperty(Object uiControl) {
        String prop = this.locateBindingProperty(uiControl);
        return !StringUtils.isDeepEmpty((String)prop);
    }

    public String locateBindingProperty(Object uiControl) {
        String result = null;
        if (uiControl instanceof Widget) {
            Widget widget = (Widget)uiControl;
            if (!widget.isDisposed()) {
                result = (String)widget.getData(BINDING_PROPERTY);
            }
        } else if (uiControl instanceof IPropertyNameProvider) {
            result = ((IPropertyNameProvider)uiControl).getPropertyName();
        }
        return result;
    }

    public void setBindingProperty(Object uiControl, String id) {
        Assert.isNotNull((Object)id, (String)"The binding property must not be null");
        Assert.isLegal((id.length() > 0 ? 1 : 0) != 0, (String)"The binding property must not be empty");
        if (uiControl instanceof Widget) {
            Widget widget = (Widget)uiControl;
            if (widget.isDisposed()) {
                return;
            }
            widget.setData(BINDING_PROPERTY, (Object)id);
        } else if (uiControl instanceof IPropertyNameProvider) {
            ((IPropertyNameProvider)uiControl).setPropertyName(id);
        } else {
            Logger log = Log4r.getLogger((IRienaActivator)Activator.getDefault(), SWTBindingPropertyLocator.class);
            String className = uiControl != null ? uiControl.getClass().getName() : "null";
            String msg = String.format("Failed to set binding property '%s' for %s", id, className);
            log.log(2, msg);
        }
    }

    public String getComplexBindingId(Object uiControl) {
        String parentId;
        IComplexComponent parent;
        Control swtControl;
        if (uiControl instanceof Control && !(swtControl = (Control)uiControl).isDisposed() && (parent = this.getComplexParent(swtControl)) != null && (parentId = this.locateBindingProperty(parent)) != null) {
            String id = this.locateBindingProperty(uiControl);
            id = String.valueOf(parentId) + "." + id;
            return id;
        }
        return this.locateBindingProperty(uiControl);
    }

    private IComplexComponent getComplexParent(Control control) {
        Composite parent = control.getParent();
        if (parent == null) {
            return null;
        }
        if (parent instanceof IComplexComponent) {
            return (IComplexComponent)parent;
        }
        return this.getComplexParent((Control)parent);
    }
}

