/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.communication.core.attachment;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.eclipse.core.runtime.Assert;
import org.eclipse.riena.communication.core.attachment.IDataSource;

public class HttpURLDataSource
implements IDataSource {
    private final HttpURLConnection httpUrlConnection;

    public HttpURLDataSource(URL url) throws IOException {
        HttpURLConnection myHttpUrlConnection = (HttpURLConnection)url.openConnection();
        Assert.isNotNull((Object)myHttpUrlConnection);
        this.httpUrlConnection = myHttpUrlConnection;
    }

    public String getContentType() {
        return this.httpUrlConnection.getContentType();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        InputStream input = this.httpUrlConnection.getInputStream();
        if (input.markSupported()) {
            input.reset();
        }
        return input;
    }

    @Override
    public String getName() {
        return this.httpUrlConnection.getURL().toString();
    }

    @Override
    public void checkValid() throws IOException {
        InputStream inputStream = this.httpUrlConnection.getInputStream();
        if (inputStream != null) {
            if (inputStream.markSupported()) {
                inputStream.reset();
            }
        } else {
            throw new RuntimeException("no inputstream for http url " + this.httpUrlConnection.getURL());
        }
    }
}

