/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.demo.server;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Random;
import org.eclipse.riena.demo.common.Email;
import org.eclipse.riena.demo.server.IEmailRepository;

public class EmailRepository
implements IEmailRepository {
    private final List<Email> emails = new ArrayList<Email>();
    private List<String> emailAddresses = new ArrayList<String>();
    private String myEmailAddress;
    private List<String> emailSubjects = new ArrayList<String>();
    private List<String> emailBodies = new ArrayList<String>();
    private final Random random = new Random();

    public EmailRepository() {
        this.initEmailGenerator();
        this.init();
    }

    private void initEmailGenerator() {
        this.emailAddresses = new ArrayList<String>(Arrays.asList("Josef.Mundl@mail.org", "Robert.Muster@mail.org", "Trulli.Muster-Maier@mail.org", "Elfriede.Mustermann@mail.org", "Ingo.Mustermann@mail.org", "Max.Mustermann@mail.org"));
        this.myEmailAddress = "riena@eclipse.org";
        this.emailSubjects = new ArrayList<String>(Arrays.asList("For your information", "Your request", "Your order", "Your monthly Newsletter", "The information to your order", "How to invest properly"));
        this.emailBodies = new ArrayList<String>(Arrays.asList("This email is just for your information...", "Here is the information you asked for...", "Hello! Send me please the missing data needed for your order completion.", "Here you find the latest highlights...", "Specially for you! This email contains the actual data to your account and the new offers.", "The following range of products may be of interest for you: insurance police, investment offers.. "));
    }

    private void init() {
        long emailDate;
        long currentTime;
        int number;
        Email email = new Email();
        int i = 0;
        while (i < 7) {
            number = this.random.nextInt(5);
            email = new Email();
            email.setEmailFrom(this.emailAddresses.get(number));
            email.setEmailTo(this.myEmailAddress);
            email.setEmailSubject(this.emailSubjects.get(number));
            currentTime = System.currentTimeMillis();
            emailDate = this.nextEmailDate(currentTime);
            email.setEmailDate(new Date(emailDate));
            email.setEmailBody(this.emailBodies.get(number));
            email.setDirectoryName("Inbox");
            this.emails.add(email);
            ++i;
        }
        i = 0;
        while (i < 2) {
            number = this.random.nextInt(6);
            email = new Email();
            email.setEmailFrom(this.myEmailAddress);
            email.setEmailTo(this.emailAddresses.get(this.random.nextInt(5)));
            email.setEmailSubject(this.emailSubjects.get(number));
            currentTime = System.currentTimeMillis();
            emailDate = this.nextEmailDate(currentTime);
            email.setEmailDate(new Date(emailDate));
            email.setEmailBody(this.emailBodies.get(number));
            email.setDirectoryName("Draft");
            this.emails.add(email);
            ++i;
        }
        i = 0;
        while (i < 5) {
            number = this.random.nextInt(5);
            email = new Email();
            email.setEmailFrom(this.myEmailAddress);
            email.setEmailTo(this.emailAddresses.get(this.random.nextInt(5)));
            email.setEmailSubject(this.emailSubjects.get(number));
            currentTime = System.currentTimeMillis();
            emailDate = this.nextEmailDate(currentTime);
            email.setEmailDate(new Date(emailDate));
            email.setEmailBody(this.emailBodies.get(number));
            email.setDirectoryName("Sent");
            this.emails.add(email);
            ++i;
        }
    }

    private long nextEmailDate(long currentTime) {
        long result = currentTime - (long)this.random.nextInt(1000000000);
        return result;
    }

    @Override
    public List<Email> emailsList(String directoryName) {
        ArrayList<Email> result = new ArrayList<Email>();
        for (Email email : this.emails) {
            if (!email.getDirectoryName().equals(directoryName)) continue;
            result.add(email);
        }
        return result;
    }

    @Override
    public List<Email> findEmailsForCustomer(String emailAddress) {
        ArrayList<Email> result = new ArrayList<Email>();
        for (Email email : this.emails) {
            if (!email.getEmailFrom().equals(emailAddress) && !email.getEmailTo().equals(emailAddress)) continue;
            result.add(email);
        }
        return result;
    }

    @Override
    public void store(Email email) {
        this.emails.add(email);
    }
}

