/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.e4.launcher.rendering;

import org.eclipse.e4.ui.model.application.MContribution;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.workbench.renderers.swt.ContributedPartRenderer;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.e4.launcher.part.NavigationPart;
import org.eclipse.riena.e4.launcher.part.PartWrapper;
import org.eclipse.riena.e4.launcher.part.RienaPartHelper;
import org.eclipse.riena.e4.launcher.part.ViewInstanceProvider;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.listener.INavigationNodeListener;
import org.eclipse.riena.navigation.listener.SubModuleNodeListener;
import org.eclipse.riena.navigation.ui.swt.presentation.SwtViewId;
import org.eclipse.riena.navigation.ui.swt.presentation.SwtViewProvider;
import org.eclipse.riena.navigation.ui.swt.views.SubModuleView;
import org.eclipse.swt.widgets.Composite;

public final class RienaPartRenderer
extends ContributedPartRenderer {
    public Object createWidget(MUIElement element, Object parent) {
        SwtViewId swtViewId = RienaPartHelper.extractRienaCompoundId(element);
        if (this.isSubModuleNodePart(swtViewId)) {
            Composite parentComposite = null;
            String typeId = swtViewId.getId();
            String secondayId = swtViewId.getSecondary();
            ISubModuleNode node = (ISubModuleNode)SwtViewProvider.getInstance().getNavigationNode(typeId, secondayId, ISubModuleNode.class);
            if (RienaPartHelper.isSharedView(node) && (parentComposite = ViewInstanceProvider.getInstance().getParentComposite(swtViewId)) != null && element.getWidget() == null) {
                element.setWidget((Object)parentComposite);
                ViewInstanceProvider.getInstance().increaseViewCounter(swtViewId);
            }
            if (parentComposite == null) {
                parentComposite = (Composite)super.createWidget(element, parent);
                this.initializeView(swtViewId, parentComposite, node);
            } else {
                this.updateViewNode(swtViewId, node);
            }
            if (RienaPartHelper.isSharedView(node)) {
                node.addListener((INavigationNodeListener)new SharedViewNodeBinder(swtViewId));
            }
            return parentComposite;
        }
        return super.createWidget(element, parent);
    }

    public void forceFocus(MUIElement element) {
        if (element instanceof MContribution) {
            Object object = ((MContribution)element).getObject();
            if (object instanceof PartWrapper) {
                ((PartWrapper)object).getView().setFocus();
                return;
            }
            if (object instanceof NavigationPart) {
                ((NavigationPart)object).getView().setFocus();
                return;
            }
        }
        super.forceFocus(element);
    }

    private boolean isSubModuleNodePart(SwtViewId rienaCompoundId) {
        return rienaCompoundId.getSecondary() != null;
    }

    private void updateViewNode(SwtViewId swtViewId, ISubModuleNode node) {
        SubModuleView viewInstance = ViewInstanceProvider.getInstance().getView(swtViewId);
        viewInstance.setNavigationNode(node);
    }

    private void initializeView(SwtViewId swtViewId, Composite parentComposite, ISubModuleNode node) {
        ViewInstanceProvider viewInstanceProvider = ViewInstanceProvider.getInstance();
        SubModuleView viewInstance = viewInstanceProvider.getView(swtViewId);
        viewInstance.setE4Runtime(true);
        viewInstanceProvider.registerParentComposite(swtViewId, parentComposite);
        this.updateViewNode(swtViewId, node);
        ReflectionUtils.invokeHidden((Object)viewInstance, (String)"setShellProvider", (Object[])new Object[]{RienaPartHelper.toShellProvider(parentComposite.getShell())});
        viewInstance.createPartControl(parentComposite);
    }

    private final class SharedViewNodeBinder
    extends SubModuleNodeListener {
        private final SwtViewId swtViewId;

        private SharedViewNodeBinder(SwtViewId swtViewId) {
            this.swtViewId = swtViewId;
        }

        public void activated(ISubModuleNode source) {
            SubModuleView viewInstance = ViewInstanceProvider.getInstance().getView(this.swtViewId);
            viewInstance.setNavigationNode(source);
            viewInstance.bind(source);
        }
    }
}

