/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.navigation.ui.filter;

import org.eclipse.riena.core.marker.IMarker;
import org.eclipse.riena.core.util.StringMatcher;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.NavigationNodeUtility;
import org.eclipse.riena.ui.filter.IUIFilterRuleMarkerNavigation;
import org.eclipse.riena.ui.filter.impl.AbstractUIFilterRuleMarker;

public abstract class AbstractUIFilterRuleNavigationMarker
extends AbstractUIFilterRuleMarker
implements IUIFilterRuleMarkerNavigation {
    private String nodeIdPattern;

    public AbstractUIFilterRuleNavigationMarker(String nodeIdPattern, IMarker marker) {
        super(marker);
        this.nodeIdPattern = nodeIdPattern;
    }

    public boolean matches(Object ... args) {
        if (args == null || args.length <= 0) {
            return false;
        }
        if (args[0] instanceof INavigationNode) {
            INavigationNode node = (INavigationNode)args[0];
            String longNodeId = NavigationNodeUtility.getNodeLongId((INavigationNode)node);
            StringMatcher stringMatcher = new StringMatcher(this.nodeIdPattern);
            return stringMatcher.match(longNodeId);
        }
        return false;
    }

    public void apply(Object object) {
        if (object instanceof INavigationNode) {
            INavigationNode node = (INavigationNode)object;
            node.addMarker(this.getMarker());
        }
    }

    public void remove(Object object) {
        if (object instanceof INavigationNode) {
            INavigationNode node = (INavigationNode)object;
            node.removeMarker(this.getMarker());
        }
    }

    public void setNode(String id) {
        this.nodeIdPattern = id;
    }
}

