/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import org.eclipse.core.databinding.BindingException;
import org.eclipse.riena.internal.ui.ridgets.swt.AbstractItemProperties;
import org.eclipse.riena.internal.ui.ridgets.swt.AbstractItemRidget;
import org.eclipse.riena.internal.ui.ridgets.swt.MenuItemMarkerSupport;
import org.eclipse.riena.internal.ui.ridgets.swt.MenuItemProperties;
import org.eclipse.riena.ui.ridgets.AbstractMarkerSupport;
import org.eclipse.riena.ui.ridgets.IMenuItemRidget;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;

public class MenuItemRidget
extends AbstractItemRidget
implements IMenuItemRidget {
    private final MenuListener enablementWatcher = new MenuAdapter(){

        public void menuShown(MenuEvent e) {
            if (!SwtUtilities.isDisposed((Widget)MenuItemRidget.this.getUIControl()) && MenuItemRidget.this.isEnabled() != MenuItemRidget.this.getUIControl().getEnabled()) {
                MenuItemRidget.this.getUIControl().setEnabled(MenuItemRidget.this.isEnabled());
            }
        }
    };

    protected boolean isMenu(MenuItem menuItem) {
        if (menuItem == null) {
            return false;
        }
        return (menuItem.getStyle() & 0x40) == 64;
    }

    @Override
    protected void bindUIControl() {
        super.bindUIControl();
        MenuItem menuItem = this.getUIControl();
        if (!SwtUtilities.isDisposed((Widget)menuItem)) {
            menuItem.addSelectionListener((SelectionListener)this.getActionObserver());
            menuItem.getParent().addMenuListener(this.enablementWatcher);
        }
    }

    @Override
    protected void unbindUIControl() {
        this.savedVisibleState = this.isVisible();
        MenuItem menuItem = this.getUIControl();
        if (!SwtUtilities.isDisposed((Widget)menuItem) && !this.isMenu(menuItem)) {
            menuItem.getParent().removeMenuListener(this.enablementWatcher);
            menuItem.removeSelectionListener((SelectionListener)this.getActionObserver());
        }
        super.unbindUIControl();
    }

    @Override
    protected void checkUIControl(Object uiControl) {
        this.checkType(uiControl, MenuItem.class);
        if (this.isMenu((MenuItem)uiControl)) {
            throw new BindingException("Menu item is a cascade menu item!");
        }
    }

    public MenuItem getUIControl() {
        return (MenuItem)super.getUIControl();
    }

    @Override
    protected AbstractMarkerSupport createMarkerSupport() {
        return new MenuItemMarkerSupport(this, this.propertyChangeSupport);
    }

    @Override
    protected void updateEnabled() {
        if (!SwtUtilities.isDisposed((Widget)this.getUIControl())) {
            this.getUIControl().setEnabled(this.isEnabled());
        }
    }

    @Override
    AbstractItemProperties createProperties() {
        return new MenuItemProperties(this);
    }
}

