/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.beans.PojoProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.ui.ridgets.swt.AbstractSWTRidget;

public final class Observable {
    private static final Logger LOGGER = Log4r.getLogger(Observable.class);

    private Observable() {
    }

    public static IObservableValue forValue(Object valueHolder, String valuePropertyName) {
        Class<?> valueType = Observable.getValueType(valueHolder, valuePropertyName);
        if (AbstractSWTRidget.isBean(valueHolder.getClass())) {
            return BeanProperties.value(valueHolder.getClass(), (String)valuePropertyName, valueType).observe(valueHolder);
        }
        return PojoProperties.value(valueHolder.getClass(), (String)valuePropertyName, valueType).observe(valueHolder);
    }

    private static Class<?> getValueType(Object valueHolder, String valuePropertyName) {
        PropertyDescriptor valueDescriptor;
        block6: {
            if (valueHolder.getClass().getTypeParameters().length != 1) {
                return null;
            }
            BeanInfo beanInfo = Introspector.getBeanInfo(valueHolder.getClass());
            PropertyDescriptor valueTypeDescriptor = Observable.getPropertyDescriptor(beanInfo, String.valueOf(valuePropertyName) + "Type");
            if (valueTypeDescriptor != null && valueTypeDescriptor.getPropertyType() == Class.class) {
                return (Class)valueTypeDescriptor.getReadMethod().invoke(valueHolder, new Object[0]);
            }
            valueDescriptor = Observable.getPropertyDescriptor(beanInfo, valuePropertyName);
            if (valueDescriptor != null) break block6;
            return null;
        }
        try {
            Object value = valueDescriptor.getReadMethod().invoke(valueHolder, new Object[0]);
            if (value != null) {
                return value.getClass();
            }
        }
        catch (Exception e) {
            LOGGER.log(2, "retrieving type information for value holder" + valueHolder.getClass() + " failed", (Throwable)e);
        }
        return null;
    }

    private static PropertyDescriptor getPropertyDescriptor(BeanInfo beanInfo, String propertyName) {
        PropertyDescriptor[] propertyDescriptors;
        PropertyDescriptor[] propertyDescriptorArray = propertyDescriptors = beanInfo.getPropertyDescriptors();
        int n = propertyDescriptors.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyDescriptor propertyDescriptor = propertyDescriptorArray[n2];
            if (propertyDescriptor.getName().equals(propertyName)) {
                return propertyDescriptor;
            }
            ++n2;
        }
        return null;
    }
}

