/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.runtime.Assert;
import org.eclipse.equinox.log.Logger;
import org.eclipse.jface.databinding.viewers.ObservableMapLabelProvider;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.internal.ui.ridgets.swt.Activator;
import org.eclipse.riena.internal.ui.swt.utils.RcpUtilities;
import org.eclipse.riena.ui.ridgets.IColumnFormatter;
import org.eclipse.riena.ui.ridgets.ITableFormatter;
import org.eclipse.riena.ui.ridgets.swt.TableFormatter;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Display;

public class TableRidgetLabelProvider
extends ObservableMapLabelProvider
implements ITableColorProvider,
ITableFontProvider {
    private static final Logger LOGGER = Log4r.getLogger(TableRidgetLabelProvider.class);
    private static final ITableFormatter DEFAULT_TABLE_FORMATTER = new TableFormatter();
    private static Image checkedImage;
    private static Image uncheckedImage;
    private final int numColumns;
    private IColumnFormatter[] formatters;
    private ITableFormatter tableFormatter;
    private Map<Object, Image> imageMap;
    private boolean checkBoxInFirstColumn;

    public TableRidgetLabelProvider(IObservableMap[] attributeMap, IColumnFormatter[] formatters) {
        this(attributeMap, formatters, attributeMap.length);
    }

    protected TableRidgetLabelProvider(IObservableMap[] attributeMap, IColumnFormatter[] formatters, int numColumns) {
        super(attributeMap);
        Assert.isLegal((numColumns == formatters.length ? 1 : 0) != 0, (String)String.format("expected %d formatters, got %d", numColumns, formatters.length));
        this.numColumns = numColumns;
        this.formatters = new IColumnFormatter[formatters.length];
        System.arraycopy(formatters, 0, this.formatters, 0, this.formatters.length);
        this.imageMap = new HashMap<Object, Image>();
        this.checkBoxInFirstColumn = false;
    }

    public Image getImage(Object element) {
        return this.getColumnImage(element, 0);
    }

    public Image getColumnImage(Object element, int columnIndex) {
        Object value;
        Object formatterImage = null;
        IColumnFormatter formatter = this.getFormatter(columnIndex);
        formatterImage = formatter != null ? formatter.getImage(element) : this.getTableFormatter().getImage(element, this.getColumnValue(element, columnIndex), columnIndex);
        Image result = null;
        if (formatterImage instanceof Image) {
            result = (Image)formatterImage;
        } else if (formatterImage instanceof ImageData) {
            ImageData formatterImageData = (ImageData)formatterImage;
            Display display = RcpUtilities.getDisplay();
            if (display != null) {
                Image oldImage = this.imageMap.get(element);
                if (!SwtUtilities.isDisposed((Resource)oldImage)) {
                    oldImage.dispose();
                }
                result = new Image((Device)display, formatterImageData);
                this.imageMap.put(element, result);
            }
        }
        if (result == null && columnIndex < this.attributeMaps.length && (value = this.attributeMaps[columnIndex].get(element)) instanceof Boolean) {
            if (columnIndex == 0 && this.isCheckBoxInFirstColumn()) {
                return null;
            }
            result = this.getCheckBoxImage((Boolean)value);
        }
        return result;
    }

    private Image getCheckBoxImage(boolean checked) {
        if (checked) {
            if (checkedImage == null) {
                checkedImage = this.getCheckBoxImage("IMG_CHECKED");
            }
            return checkedImage;
        }
        if (uncheckedImage == null) {
            uncheckedImage = this.getCheckBoxImage("IMG_UNCHECKED");
        }
        return uncheckedImage;
    }

    private Image getCheckBoxImage(String key) {
        Image image = Activator.getSharedImage(key);
        if (image != null && ((double)SwtUtilities.getDpiFactors()[0] > 1.0 || (double)SwtUtilities.getDpiFactors()[1] > 1.0)) {
            int width = image.getBounds().width;
            int height = image.getBounds().height;
            width = SwtUtilities.convertXToDpi((int)width);
            height = SwtUtilities.convertYToDpi((int)height);
            image = this.resize(image, width, height);
        }
        return image;
    }

    private Image resize(Image image, int width, int height) {
        ImageData scaledImageData = image.getImageData().scaledTo(width, height);
        Image scaled = new Image((Device)RcpUtilities.getDisplay(), scaledImageData);
        return scaled;
    }

    public void dispose() {
        super.dispose();
        this.disposeImages();
        this.imageMap = null;
    }

    public void disposeImages() {
        for (Map.Entry<Object, Image> entry : this.imageMap.entrySet()) {
            Image image = entry.getValue();
            if (SwtUtilities.isDisposed((Resource)image)) continue;
            image.dispose();
        }
        this.imageMap.clear();
    }

    public void disposeImageOfElement(Object element) {
        Image image = this.imageMap.get(element);
        if (image == null) {
            LOGGER.log(2, "No image found for element: " + element.toString());
            return;
        }
        image.dispose();
        this.imageMap.remove(element);
    }

    public String getColumnText(Object element, int columnIndex) {
        Object value;
        String result = null;
        IColumnFormatter formatter = this.getFormatter(columnIndex);
        result = formatter != null ? formatter.getText(element) : this.getTableFormatter().getText(element, this.getColumnValue(element, columnIndex), columnIndex);
        if (result == null) {
            result = super.getColumnText(element, columnIndex);
        }
        if ((value = this.getColumnValue(element, columnIndex)) instanceof Boolean && columnIndex == 0 && this.isCheckBoxInFirstColumn()) {
            return null;
        }
        return result;
    }

    public Color getForeground(Object element, int columnIndex) {
        IColumnFormatter formatter = this.getFormatter(columnIndex);
        Object color = formatter != null ? formatter.getForeground(element) : this.getTableFormatter().getForeground(element, this.getColumnValue(element, columnIndex), columnIndex);
        if (color instanceof Color) {
            return (Color)color;
        }
        return null;
    }

    public Color getBackground(Object element, int columnIndex) {
        IColumnFormatter formatter = this.getFormatter(columnIndex);
        Object color = formatter != null ? formatter.getBackground(element) : this.getTableFormatter().getBackground(element, this.getColumnValue(element, columnIndex), columnIndex);
        if (color instanceof Color) {
            return (Color)color;
        }
        return null;
    }

    public Font getFont(Object element, int columnIndex) {
        IColumnFormatter formatter = this.getFormatter(columnIndex);
        Object font = formatter != null ? formatter.getFont(element) : this.getTableFormatter().getFont(element, this.getColumnValue(element, columnIndex), columnIndex);
        if (font instanceof Font) {
            return (Font)font;
        }
        return null;
    }

    public Object getColumnValue(Object element, int columnIndex) {
        if (columnIndex < this.attributeMaps.length) {
            return this.attributeMaps[columnIndex].get(element);
        }
        return null;
    }

    public String getToolTipText(Object element, int columnIndex) {
        IColumnFormatter formatter = this.getFormatter(columnIndex);
        if (formatter != null) {
            return formatter.getToolTip(element);
        }
        return this.getTableFormatter().getToolTip(element, this.getColumnValue(element, columnIndex), columnIndex);
    }

    public Image getToolTipImage(Object object, int columnIndex) {
        IColumnFormatter formatter = this.getFormatter(columnIndex);
        Object image = formatter != null ? formatter.getToolTipImage(object) : this.getTableFormatter().getToolTipImage(object, this.getColumnValue(object, columnIndex), columnIndex);
        if (image instanceof Image) {
            return (Image)image;
        }
        return null;
    }

    public Color getToolTipBackgroundColor(Object object, int columnIndex) {
        IColumnFormatter formatter = this.getFormatter(columnIndex);
        Object color = formatter != null ? formatter.getToolTipBackgroundColor(object) : this.getTableFormatter().getToolTipBackgroundColor(object, this.getColumnValue(object, columnIndex), columnIndex);
        if (color instanceof Color) {
            return (Color)color;
        }
        return null;
    }

    public Color getToolTipForegroundColor(Object object, int columnIndex) {
        IColumnFormatter formatter = this.getFormatter(columnIndex);
        Object color = formatter != null ? formatter.getToolTipForegroundColor(object) : this.getTableFormatter().getToolTipForegroundColor(object, this.getColumnValue(object, columnIndex), columnIndex);
        if (color instanceof Color) {
            return (Color)color;
        }
        return null;
    }

    public Font getToolTipFont(Object object, int columnIndex) {
        IColumnFormatter formatter = this.getFormatter(columnIndex);
        Object font = formatter != null ? formatter.getToolTipFont(object) : this.getTableFormatter().getToolTipFont(object, this.getColumnValue(object, columnIndex), columnIndex);
        if (font instanceof Font) {
            return (Font)font;
        }
        return null;
    }

    public Point getToolTipShift(Object object, int columnIndex) {
        IColumnFormatter formatter = this.getFormatter(columnIndex);
        Object point = formatter != null ? formatter.getToolTipShift(object) : this.getTableFormatter().getToolTipShift(object, this.getColumnValue(object, columnIndex), columnIndex);
        if (point instanceof Point) {
            return (Point)point;
        }
        return null;
    }

    public int getToolTipTimeDisplayed(Object object, int columnIndex) {
        IColumnFormatter formatter = this.getFormatter(columnIndex);
        if (formatter != null) {
            return formatter.getToolTipTimeDisplayed(object);
        }
        return this.getTableFormatter().getToolTipTimeDisplayed(object, this.getColumnValue(object, columnIndex), columnIndex);
    }

    public int getToolTipDisplayDelayTime(Object object, int columnIndex) {
        IColumnFormatter formatter = this.getFormatter(columnIndex);
        if (formatter != null) {
            return formatter.getToolTipDisplayDelayTime(object);
        }
        return this.getTableFormatter().getToolTipDisplayDelayTime(object, this.getColumnValue(object, columnIndex), columnIndex);
    }

    public int getToolTipStyle(Object object, int columnIndex) {
        IColumnFormatter formatter = this.getFormatter(columnIndex);
        if (formatter != null) {
            return formatter.getToolTipStyle(object);
        }
        return this.getTableFormatter().getToolTipStyle(object, this.getColumnValue(object, columnIndex), columnIndex);
    }

    protected IColumnFormatter getFormatter(int columnIndex) {
        return columnIndex < this.formatters.length ? this.formatters[columnIndex] : null;
    }

    protected ITableFormatter getTableFormatter() {
        return this.tableFormatter != null ? this.tableFormatter : DEFAULT_TABLE_FORMATTER;
    }

    public int getColumnCount() {
        return this.formatters.length;
    }

    public void setFormatters(IColumnFormatter[] formatters) {
        Assert.isLegal((this.numColumns == formatters.length ? 1 : 0) != 0, (String)String.format("expected %d formatters, got %d", this.numColumns, formatters.length));
        this.formatters = new IColumnFormatter[formatters.length];
        System.arraycopy(formatters, 0, this.formatters, 0, this.formatters.length);
    }

    public void setTableFormatter(ITableFormatter formatter) {
        this.tableFormatter = formatter;
    }

    public boolean isCheckBoxInFirstColumn() {
        return this.checkBoxInFirstColumn;
    }

    public void setCheckBoxInFirstColumn(boolean checkBoxInFirstColumn) {
        this.checkBoxInFirstColumn = checkBoxInFirstColumn;
    }
}

