/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.riena.core.util.RienaConfiguration;
import org.eclipse.riena.ui.ridgets.ITextRidget;
import org.eclipse.riena.ui.ridgets.swt.AbstractEditableRidget;
import org.eclipse.riena.ui.ridgets.swt.MarkerSupport;
import org.eclipse.riena.ui.swt.facades.SWTFacade;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class TextRidget
extends AbstractEditableRidget
implements ITextRidget {
    private static final String PROPERTY_TEXT_INTERNAL = "textInternal";
    private static final String EMPTY_STRING = "";
    protected final FocusListener focusListener;
    protected final KeyListener crKeyListener = new CRKeyListener();
    protected final ModifyListener modifyListener;
    protected final ValidationListener verifyListener;
    private String textValue = "";
    private boolean isDirectWriting;
    private IConverter inputConverter;
    private boolean multilineIgnoreEnterKey;
    private static final boolean DEFAULT_DIRECTWRITING = TextRidget.getDefaultTextRidgetDirectWritingEnabled();
    private static final String RIENA_TEXT_RIDGET_DIRECTWRITING_PROPERTY = "riena.textridget.directwriting";
    private static final String DIRECTWRITING_DEFAULT = "false";

    private static boolean getDefaultTextRidgetDirectWritingEnabled() {
        return Boolean.parseBoolean(System.getProperty(RIENA_TEXT_RIDGET_DIRECTWRITING_PROPERTY, DIRECTWRITING_DEFAULT));
    }

    public TextRidget() {
        this.focusListener = new FocusManager();
        this.modifyListener = new SyncModifyListener();
        this.verifyListener = new ValidationListener();
        this.isDirectWriting = DEFAULT_DIRECTWRITING;
        this.addPropertyChangeListener("enabled", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                TextRidget.this.forceTextToControl(TextRidget.this.textValue);
            }
        });
        this.addPropertyChangeListener("output", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                TextRidget.this.updateEditable();
                TextRidget.this.forceTextToControl(TextRidget.this.textValue);
            }
        });
        this.multilineIgnoreEnterKey = Boolean.valueOf(RienaConfiguration.getInstance().getProperty("riena.ITextRidget.multilineIgnoreEnterKey"));
    }

    protected TextRidget(String initialValue) {
        this();
        Assert.isNotNull((Object)initialValue);
        this.textValue = initialValue;
    }

    @Override
    protected IObservableValue getRidgetObservable() {
        return BeansObservables.observeValue((Object)((Object)this), (String)PROPERTY_TEXT_INTERNAL);
    }

    @Override
    protected void checkUIControl(Object uiControl) {
        this.checkType(uiControl, Text.class);
    }

    protected boolean isNotEmpty(String input) {
        return input.length() > 0;
    }

    @Override
    protected final synchronized void bindUIControl() {
        Text control = this.getTextWidget();
        if (control != null) {
            this.setUIText(this.textValue);
            this.updateEditable();
            this.addListeners(control);
        }
    }

    @Override
    protected final synchronized void unbindUIControl() {
        super.unbindUIControl();
        Text control = this.getTextWidget();
        if (control != null) {
            this.removeListeners(control);
        }
    }

    protected synchronized void addListeners(Text control) {
        control.addKeyListener(this.crKeyListener);
        control.addFocusListener(this.focusListener);
        control.addModifyListener(this.modifyListener);
        control.addVerifyListener((VerifyListener)this.verifyListener);
    }

    protected synchronized void removeListeners(Text control) {
        control.removeKeyListener(this.crKeyListener);
        control.removeFocusListener(this.focusListener);
        control.removeModifyListener(this.modifyListener);
        control.removeVerifyListener((VerifyListener)this.verifyListener);
    }

    public void setMultilineIgnoreEnterKey(boolean multilineIgnoreEnterKey) {
        this.multilineIgnoreEnterKey = multilineIgnoreEnterKey;
    }

    public boolean isMultilineIgnoreEnterKey() {
        return this.multilineIgnoreEnterKey;
    }

    protected String getTextBasedOnMarkerState(String value) {
        boolean hideValue = !this.isEnabled() && MarkerSupport.isHideDisabledRidgetContent();
        return hideValue ? EMPTY_STRING : value;
    }

    protected Text getTextWidget() {
        return (Text)this.getUIControl();
    }

    protected String getUIText() {
        Text control = this.getTextWidget();
        Assert.isNotNull((Object)control);
        return control.getText();
    }

    protected void updateEditable() {
        Text control = this.getTextWidget();
        if (control != null && !control.isDisposed()) {
            boolean isEditable;
            boolean bl = isEditable = !this.isOutputOnly();
            if (isEditable != control.getEditable()) {
                Color bgColor = control.getBackground();
                control.setEditable(isEditable);
                control.setBackground(bgColor);
            }
        }
    }

    protected void setUIText(String text) {
        Text control = this.getTextWidget();
        if (control != null) {
            control.setText(this.getTextBasedOnMarkerState(text));
            control.setSelection(0, 0);
        }
    }

    protected void selectAll() {
        Text text = this.getTextWidget();
        if (text != null && (text.getStyle() & 2) == 0) {
            text.selectAll();
        }
    }

    public synchronized String getText() {
        return this.textValue;
    }

    public final synchronized String getTextInternal() {
        return this.getText();
    }

    public void setInputToUIControlConverter(IConverter converter) {
        if (converter != null) {
            Assert.isLegal((converter.getFromType() == String.class ? 1 : 0) != 0, (String)"Invalid from-type. Need a String-to-String converter");
            Assert.isLegal((converter.getToType() == String.class ? 1 : 0) != 0, (String)"Invalid to-type. Need a String-to-String converter");
        }
        this.inputConverter = converter;
    }

    public synchronized void setText(String text) {
        String oldValue = this.textValue;
        this.textValue = text != null ? text : EMPTY_STRING;
        this.forceTextToControl(this.textValue);
        this.disableMandatoryMarkers(this.isNotEmpty(this.textValue));
        IStatus onEdit = this.checkOnEditRules(this.textValue, new AbstractEditableRidget.ValidationCallback(this, false));
        if (onEdit.isOK()) {
            this.firePropertyChange(PROPERTY_TEXT_INTERNAL, oldValue, this.textValue);
            this.firePropertyChange("text", oldValue, this.textValue);
        }
    }

    public final synchronized void setTextInternal(String text) {
        this.setText(text);
    }

    public synchronized boolean revalidate() {
        if (this.getUIControl() != null) {
            this.textValue = this.getUIText();
        }
        this.forceTextToControl(this.textValue);
        this.disableMandatoryMarkers(this.isNotEmpty(this.textValue));
        IStatus status = this.checkAllRules(this.textValue, new AbstractEditableRidget.ValidationCallback(this, false));
        if (status.isOK()) {
            this.getValueBindingSupport().updateFromTarget();
        }
        return !this.isErrorMarked();
    }

    @Override
    public synchronized void updateFromModel() {
        super.updateFromModel();
        this.checkAllRules(this.getText(), new AbstractEditableRidget.ValidationCallback(this, false));
    }

    public synchronized boolean isDirectWriting() {
        return this.isDirectWriting;
    }

    public synchronized void setDirectWriting(boolean directWriting) {
        if (this.isDirectWriting != directWriting) {
            this.isDirectWriting = directWriting;
        }
    }

    @Override
    public final boolean isDisableMandatoryMarker() {
        return this.isNotEmpty(this.textValue);
    }

    private synchronized void forceTextToControl(String newValue) {
        Text control = this.getTextWidget();
        if (control != null) {
            SWTFacade facade = SWTFacade.getDefault();
            Object[] vListeners = facade.removeListeners((Control)control, 25);
            Object[] mListeners = facade.removeListeners((Control)control, 24);
            this.setUIText(newValue);
            facade.addListeners((Control)control, 24, mListeners);
            facade.addListeners((Control)control, 25, vListeners);
        }
    }

    private synchronized void updateTextValue() {
        if (this.isOutputOnly()) {
            return;
        }
        String oldValue = this.textValue;
        String newValue = this.getUIText();
        if (!oldValue.equals(newValue)) {
            this.textValue = newValue;
            if (this.checkOnEditRules(newValue, null).isOK()) {
                this.firePropertyChange(PROPERTY_TEXT_INTERNAL, oldValue, newValue);
                if (this.isExternalValueChange(oldValue, newValue)) {
                    this.firePropertyChange("text", oldValue, newValue);
                }
            }
        }
    }

    protected boolean isExternalValueChange(String oldValue, String newValue) {
        return true;
    }

    protected void enterKeyReleased() {
        if (this.multilineIgnoreEnterKey && this.isMultiline()) {
            return;
        }
        this.updateTextValue();
    }

    private boolean isMultiline() {
        Control textField = this.getUIControl();
        return textField != null && (textField.getStyle() & 2) != 0;
    }

    private final class CRKeyListener
    extends KeyAdapter
    implements KeyListener {
        private CRKeyListener() {
        }

        public void keyReleased(KeyEvent e) {
            if (e.character == '\r') {
                TextRidget.this.enterKeyReleased();
            }
        }
    }

    private final class FocusManager
    implements FocusListener {
        private FocusManager() {
        }

        public void focusGained(FocusEvent e) {
            if (TextRidget.this.isFocusable() && !TextRidget.this.isOutputOnly()) {
                TextRidget.this.selectAll();
            }
        }

        public void focusLost(FocusEvent e) {
            TextRidget.this.updateTextValue();
        }
    }

    private final class SyncModifyListener
    implements ModifyListener {
        private SyncModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            if (TextRidget.this.isDirectWriting) {
                TextRidget.this.updateTextValue();
            }
            String text = TextRidget.this.getUIText();
            TextRidget.this.disableMandatoryMarkers(TextRidget.this.isNotEmpty(text));
        }
    }

    private final class ValidationListener
    implements VerifyListener {
        private ValidationListener() {
        }

        public synchronized void verifyText(VerifyEvent e) {
            String oldText;
            String newText;
            IStatus status;
            boolean doit;
            if (!e.doit) {
                return;
            }
            if (TextRidget.this.inputConverter != null) {
                e.text = (String)TextRidget.this.inputConverter.convert((Object)e.text);
            }
            boolean bl = doit = (status = TextRidget.this.checkOnEditRules(newText = this.getText(oldText = TextRidget.this.getUIText(), e), new AbstractEditableRidget.ValidationCallback(TextRidget.this, true))).getCode() != 1024;
            if (!doit) {
                TextRidget.this.checkOnEditRules(oldText, new AbstractEditableRidget.ValidationCallback(TextRidget.this, false));
            }
            e.doit = doit;
        }

        private String getText(String oldText, VerifyEvent e) {
            String newText = e.keyCode == 127 || e.keyCode == 8 ? String.valueOf(oldText.substring(0, e.start)) + oldText.substring(e.end) : String.valueOf(oldText.substring(0, e.start)) + e.text + oldText.substring(e.end);
            return newText;
        }
    }
}

