/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.swt;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.IStatuslineRidget;
import org.eclipse.riena.ui.ridgets.RidgetToStatuslineSubscriber;
import org.eclipse.riena.ui.ridgets.controller.IController;

public abstract class AbstractRidgetController
implements IController {
    private final Map<String, IRidget> map;
    private boolean isBlocked;
    private boolean configured = false;
    private final RidgetToStatuslineSubscriber ridgetToStatuslineSubscriber = new RidgetToStatuslineSubscriber();

    public AbstractRidgetController() {
        this.map = new HashMap<String, IRidget>();
    }

    public final void addRidget(String id, IRidget ridget) {
        this.map.put(id, ridget);
        this.ridgetToStatuslineSubscriber.addRidget(ridget);
    }

    public boolean removeRidget(String id) {
        this.ridgetToStatuslineSubscriber.removeRidget(this.getRidget(id));
        return this.map.remove(id) != null;
    }

    public void setStatuslineToShowMarkerMessages(IStatuslineRidget statuslineToShowMarkerMessages) {
        this.ridgetToStatuslineSubscriber.setStatuslineToShowMarkerMessages(statuslineToShowMarkerMessages, this.getRidgets());
    }

    public final void afterBind() {
    }

    public final <R extends IRidget> R getRidget(String id) {
        return (R)this.map.get(id);
    }

    public <R extends IRidget> R getRidget(Class<R> ridgetClazz, String id) {
        return this.getRidget(id);
    }

    public final Collection<? extends IRidget> getRidgets() {
        return Collections.unmodifiableCollection(this.map.values());
    }

    public abstract void configureRidgets();

    public boolean isBlocked() {
        return this.isBlocked;
    }

    public void setBlocked(boolean blocked) {
        this.isBlocked = blocked;
    }

    public void setConfigured(boolean configured) {
        this.configured = configured;
    }

    public boolean isConfigured() {
        return this.configured;
    }
}

