/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.swt;

import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.TypedListener;

public class MenuManagerHelper {
    public Menu createMenu(Composite parent, ToolItem toolItem, MenuManager topMenuManager) {
        Menu menu = topMenuManager.createContextMenu((Control)parent);
        toolItem.setData((Object)topMenuManager);
        topMenuManager.updateAll(true);
        this.addListeners(toolItem, menu);
        return menu;
    }

    public void addListeners(ToolItem toolItem, Menu menu) {
        menu.addMenuListener((MenuListener)new TopMenuListener(menu, toolItem));
    }

    public void removeListeners(ToolItem toolItem, Menu menu) {
        Listener[] listeners;
        Listener[] listenerArray = listeners = menu.getListeners(23);
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            TypedListener typedListener;
            Listener listener = listenerArray[n2];
            if (listener instanceof TypedListener && (typedListener = (TypedListener)listener).getEventListener() instanceof TopMenuListener) {
                menu.removeMenuListener((MenuListener)((TopMenuListener)typedListener.getEventListener()));
            }
            ++n2;
        }
    }

    private static class TopMenuListener
    implements MenuListener {
        private final ToolItem toolItem;
        private final Menu menu;

        public TopMenuListener(Menu menu, ToolItem toolItem) {
            this.menu = menu;
            this.toolItem = toolItem;
        }

        public void menuHidden(MenuEvent e) {
            if (e.getSource() == this.menu && !this.toolItem.isDisposed()) {
                this.toolItem.setSelection(false);
            }
        }

        public void menuShown(MenuEvent e) {
        }
    }
}

