/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.swt;

import com.ibm.icu.text.NumberFormat;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.conversion.NumberToStringConverter;

public final class ToStringConverterFactory {
    private ToStringConverterFactory() {
    }

    public static IConverter createNumberConverter(Class<?> type, int precision) {
        NumberToStringConverter result = null;
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setMaximumFractionDigits(precision);
        if (BigDecimal.class.isAssignableFrom(type)) {
            result = NumberToStringConverter.fromBigDecimal((NumberFormat)nf);
        } else if (BigInteger.class.isAssignableFrom(type)) {
            result = NumberToStringConverter.fromBigInteger((NumberFormat)nf);
        } else if (Byte.class.isAssignableFrom(type)) {
            result = NumberToStringConverter.fromByte((NumberFormat)nf, (boolean)false);
        } else if (Double.class.isAssignableFrom(type)) {
            result = NumberToStringConverter.fromDouble((NumberFormat)nf, (boolean)false);
        } else if (Float.class.isAssignableFrom(type)) {
            result = NumberToStringConverter.fromFloat((NumberFormat)nf, (boolean)false);
        } else if (Integer.class.isAssignableFrom(type)) {
            result = NumberToStringConverter.fromInteger((NumberFormat)nf, (boolean)false);
        } else if (Long.class.isAssignableFrom(type)) {
            result = NumberToStringConverter.fromLong((NumberFormat)nf, (boolean)false);
        } else if (Short.class.isAssignableFrom(type)) {
            result = NumberToStringConverter.fromShort((NumberFormat)nf, (boolean)false);
        }
        return result;
    }
}

