/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.swt.views;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.riena.ui.ridgets.IMarkableRidget;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.IRidgetContainer;
import org.eclipse.riena.ui.ridgets.controller.AbstractWindowController;
import org.eclipse.riena.ui.ridgets.controller.ControllerHelper;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;

public abstract class BlockHelper
implements AbstractWindowController.Blocker {
    private boolean blocked;
    private Cursor oldCursor;
    private final Map<Integer, Control> focusControlMap = new HashMap<Integer, Control>(1);
    private Composite contentComposite;

    public void setBlocked(boolean blocked) {
        if (!this.getParentComposite().isDisposed()) {
            if (blocked) {
                this.blockView();
            } else {
                this.unBlockView();
            }
        }
    }

    public boolean isBlocked() {
        return this.blocked;
    }

    public void registerOnContentComposite(Composite contentComposite) {
        this.contentComposite = contentComposite;
        final FocusListener focusListener = new FocusListener();
        contentComposite.getDisplay().addFilter(15, (Listener)focusListener);
        contentComposite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                event.widget.getDisplay().removeFilter(15, (Listener)focusListener);
            }
        });
    }

    private void blockView() {
        if (!this.blocked) {
            this.oldCursor = this.getParentComposite().getCursor();
            if (this.getController() != null) {
                for (IRidget ridget : this.getController().getRidgets()) {
                    Object uiControl;
                    if (!ridget.hasFocus() || !((uiControl = ridget.getUIControl()) instanceof Control)) continue;
                    this.saveFocus((Control)uiControl);
                }
            }
            this.getParentComposite().setCursor(this.getWaitCursor());
            this.contentComposite.setEnabled(false);
            this.blocked = true;
        }
    }

    private void unBlockView() {
        this.blocked = false;
        this.getParentComposite().setCursor(this.oldCursor);
        this.contentComposite.setEnabled(true);
        this.contentComposite.setRedraw(false);
        this.contentComposite.setRedraw(true);
        if (this.shouldRestoreFocus() && this.canRestoreFocus()) {
            this.setFocus();
        }
        this.oldCursor = null;
        if (this.getController() != null) {
            for (IRidget ridget : this.getController().getRidgets()) {
                if (!(ridget instanceof IMarkableRidget)) continue;
                ((IMarkableRidget)ridget).updateMarkers();
            }
            ControllerHelper.restoreFocusRequestFromRidget((Collection)this.getController().getRidgets(), (boolean)this.blocked);
        }
    }

    public void setFocus() {
        if (this.canRestoreFocus()) {
            Integer id = this.getControllerId();
            Control lastFocusedControl = this.focusControlMap.get(id);
            lastFocusedControl.setFocus();
        } else if (this.canFocusOnRidget()) {
            this.getFocusRidget().requestFocus();
        } else {
            this.contentComposite.setFocus();
        }
    }

    protected abstract IRidgetContainer getController();

    protected abstract Control getParentComposite();

    protected abstract boolean shouldRestoreFocus();

    protected abstract IRidget getFocusRidget();

    private boolean canFocusOnRidget() {
        boolean result = false;
        IRidget ridget = this.getFocusRidget();
        if (ridget != null) {
            boolean bl = result = ridget.isFocusable() && ridget.isEnabled() && ridget.isVisible();
            if (ridget instanceof IMarkableRidget) {
                result &= !((IMarkableRidget)ridget).isOutputOnly();
            }
        }
        return result;
    }

    private void saveFocus(Control control) {
        int id = this.getControllerId();
        if (id != 0) {
            this.focusControlMap.put(id, control);
        }
    }

    private int getControllerId() {
        IRidgetContainer controller = this.getController();
        return controller == null ? 0 : controller.hashCode();
    }

    public final boolean canRestoreFocus() {
        Integer id = this.getControllerId();
        Control control = this.focusControlMap.get(id);
        return !SwtUtilities.isDisposed((Widget)control);
    }

    private Cursor getWaitCursor() {
        return this.contentComposite.getDisplay().getSystemCursor(1);
    }

    private final class FocusListener
    implements Listener {
        private FocusListener() {
        }

        public void handleEvent(Event event) {
            if (BlockHelper.this.contentComposite.isVisible() && event.widget instanceof Control) {
                Control control = (Control)event.widget;
                if (this.contains(BlockHelper.this.contentComposite, control)) {
                    BlockHelper.this.saveFocus(control);
                }
            }
        }

        private boolean contains(Composite container, Control control) {
            boolean result = false;
            Composite parent = control.getParent();
            while (!result && parent != null) {
                result = container == parent;
                parent = parent.getParent();
            }
            return result;
        }
    }
}

