/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.e4.launcher.binder;

import javax.inject.Inject;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.riena.internal.ui.ridgets.swt.uiprocess.UIProcessRidget;
import org.eclipse.riena.navigation.IModuleGroupNode;
import org.eclipse.riena.navigation.IModuleNode;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.ISubApplicationNode;
import org.eclipse.riena.navigation.NavigationNodeId;
import org.eclipse.riena.navigation.listener.INavigationNodeListener;
import org.eclipse.riena.navigation.listener.SubApplicationNodeListener;
import org.eclipse.riena.navigation.ui.controllers.SubApplicationController;
import org.eclipse.riena.navigation.ui.swt.binding.DelegatingRidgetMapper;
import org.eclipse.riena.navigation.ui.swt.binding.InjectSwtViewBindingDelegate;
import org.eclipse.riena.navigation.ui.swt.presentation.SwtViewProvider;
import org.eclipse.riena.ui.ridgets.controller.IController;
import org.eclipse.riena.ui.ridgets.swt.uibinding.AbstractViewBindingDelegate;
import org.eclipse.riena.ui.ridgets.swt.uibinding.SwtControlRidgetMapper;
import org.eclipse.riena.ui.ridgets.uibinding.IControlRidgetMapper;
import org.eclipse.riena.ui.swt.uiprocess.UIProcessControl;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class SubApplicationBinder {
    @Inject
    private IEclipseContext context;
    @Inject
    private IEventBroker eventBroker;
    private final ISubApplicationNode subApplicationNode;
    private final AbstractViewBindingDelegate binding;
    private SubApplicationListener subApplicationListener;
    private SubApplicationController subApplicationController;

    public SubApplicationBinder(ISubApplicationNode subApplicationNode) {
        this.subApplicationNode = subApplicationNode;
        this.binding = this.createBinding();
    }

    protected AbstractViewBindingDelegate createBinding() {
        DelegatingRidgetMapper ridgetMapper = new DelegatingRidgetMapper(SwtControlRidgetMapper.getInstance());
        ridgetMapper.addMapping(UIProcessControl.class, UIProcessRidget.class);
        return new InjectSwtViewBindingDelegate((IControlRidgetMapper)ridgetMapper);
    }

    private void createUIProcessControl(Shell shell) {
        UIProcessControl uiControl = new UIProcessControl(shell);
        uiControl.setPropertyName("uiProcessRidget");
        this.binding.addUIControl((Object)uiControl);
    }

    public void bind() {
        this.subApplicationController = new SubApplicationController(this.subApplicationNode);
        this.subApplicationController.installNavigationListeners();
        Object shell = this.context.get("activeShell");
        if (shell == null) {
            this.eventBroker.subscribe("shellCreated", (EventHandler)new LazyBinder());
            return;
        }
        this.internalBind(shell);
    }

    private void internalBind(Object shell) {
        this.createUIProcessControl((Shell)shell);
        this.bindController();
    }

    private void bindController() {
        if (this.subApplicationController.getRidgets().isEmpty()) {
            this.binding.injectRidgets((IController)this.subApplicationController);
            this.binding.bind((IController)this.subApplicationController);
            this.observeSubApplicationNode();
            this.subApplicationController.afterBind();
        }
    }

    private void observeSubApplicationNode() {
        this.subApplicationListener = new SubApplicationListener();
        this.getNavigationNode().addListener((INavigationNodeListener)this.subApplicationListener);
    }

    public void unbind() {
        if (this.getNavigationNode() != null) {
            this.getNavigationNode().removeListener((INavigationNodeListener)this.subApplicationListener);
            if (this.getNavigationNode().getNavigationNodeController() instanceof IController) {
                IController controller = (IController)this.getNavigationNode().getNavigationNodeController();
                this.binding.unbind(controller);
            }
        }
    }

    private ISubApplicationNode getNavigationNode() {
        return this.subApplicationNode;
    }

    private final class LazyBinder
    implements EventHandler {
        private LazyBinder() {
        }

        public void handleEvent(Event event) {
            SubApplicationBinder.this.internalBind(event.getProperty("org.eclipse.e4.data"));
        }
    }

    private class SubApplicationListener
    extends SubApplicationNodeListener {
        private SubApplicationListener() {
        }

        public void block(ISubApplicationNode source, boolean block) {
            super.block((INavigationNode)source, block);
            for (IModuleGroupNode group : source.getChildren()) {
                for (IModuleNode module : group.getChildren()) {
                    module.setBlocked(block);
                }
            }
        }

        public void disposed(ISubApplicationNode source) {
            SubApplicationBinder.this.unbind();
        }

        public void nodeIdChange(ISubApplicationNode source, NavigationNodeId oldId, NavigationNodeId newId) {
            SwtViewProvider.getInstance().replaceNavigationNodeId((INavigationNode)source, oldId, newId);
        }
    }
}

