/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.example.client.controllers;

import java.util.Collection;
import java.util.Comparator;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.riena.beans.common.Person;
import org.eclipse.riena.beans.common.PersonFactory;
import org.eclipse.riena.beans.common.PersonManager;
import org.eclipse.riena.beans.common.TypedComparator;
import org.eclipse.riena.internal.example.client.beans.PersonModificationBean;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.NavigationArgument;
import org.eclipse.riena.navigation.ui.controllers.SubModuleController;
import org.eclipse.riena.ui.ridgets.IActionRidget;
import org.eclipse.riena.ui.ridgets.IListRidget;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.ISelectableRidget;
import org.eclipse.riena.ui.ridgets.ITableRidget;
import org.eclipse.riena.ui.ridgets.ITextRidget;
import org.eclipse.riena.ui.ridgets.IToggleButtonRidget;
import org.eclipse.riena.ui.ridgets.annotation.OnActionCallback;
import org.eclipse.riena.ui.ridgets.annotation.OnClick;
import org.eclipse.riena.ui.ridgets.annotation.OnDoubleClick;
import org.eclipse.riena.ui.ridgets.annotation.OnPropertyChange;
import org.eclipse.riena.ui.ridgets.listener.ClickEvent;

public class ListSubModuleController
extends SubModuleController {
    private final PersonManager manager = new PersonManager((Collection)PersonFactory.createPersonList());
    private final PersonModificationBean value;
    private ITableRidget listPersons;
    private ITextRidget textFirst;
    private ITextRidget textLast;
    private IToggleButtonRidget buttonSort;
    private int count = 0;

    public ListSubModuleController() {
        this(null);
    }

    public ListSubModuleController(ISubModuleNode navigationNode) {
        super(navigationNode);
        this.manager.setSelectedPerson((Person)this.manager.getPersons().iterator().next());
        this.value = new PersonModificationBean();
    }

    public void configureRidgets() {
        this.listPersons = this.getListRidget();
        this.listPersons.setSelectionType(ISelectableRidget.SelectionType.SINGLE);
        this.listPersons.setComparator(0, (Comparator)new TypedComparator());
        this.listPersons.setSortedColumn(0);
        this.listPersons.bindToModel((Object)this.manager, "persons", Person.class, new String[]{"listEntry"}, null);
        this.listPersons.updateFromModel();
        this.listPersons.bindSingleSelectionToModel((Object)this.manager, "selectedPerson");
        this.textFirst = (ITextRidget)this.getRidget(ITextRidget.class, "textFirst");
        this.textFirst.bindToModel((Object)this.value, "firstName");
        this.textFirst.updateFromModel();
        this.textLast = (ITextRidget)this.getRidget(ITextRidget.class, "textLast");
        this.textLast.bindToModel((Object)this.value, "lastName");
        this.textLast.updateFromModel();
        this.buttonSort = (IToggleButtonRidget)this.getRidget(IToggleButtonRidget.class, "buttonSort");
        this.buttonSort.setText("Sort ascending");
        this.buttonSort.setSelected(true);
        this.listPersons.setSortedAscending(this.buttonSort.isSelected());
        IActionRidget buttonAdd = (IActionRidget)this.getRidget(IActionRidget.class, "buttonAdd");
        buttonAdd.setText("&Add");
        IActionRidget buttonRemove = (IActionRidget)this.getRidget(IActionRidget.class, "buttonRemove");
        buttonRemove.setText("&Remove");
        IActionRidget buttonSave = (IActionRidget)this.getRidget(IActionRidget.class, "buttonSave");
        buttonSave.setText("&Save");
        final IObservableValue viewerSelection = this.listPersons.getSingleSelectionObservable();
        ComputedValue hasSelection = new ComputedValue(Boolean.TYPE){

            protected Object calculate() {
                return viewerSelection.getValue() != null;
            }
        };
        DataBindingContext dbc = new DataBindingContext();
        this.bindEnablementToValue(dbc, (IRidget)buttonRemove, (IObservableValue)hasSelection);
        this.bindEnablementToValue(dbc, (IRidget)buttonSave, (IObservableValue)hasSelection);
        if (((ISubModuleNode)this.getNavigationNode()).getNavigationArgument() != null) {
            this.setValuesFromNavigation();
        }
    }

    protected ITableRidget getListRidget() {
        return (ITableRidget)this.getRidget(IListRidget.class, "listPersons");
    }

    @OnPropertyChange(ridgetId="listPersons", propertyName="selection")
    public void selectionChanged() {
        this.value.setPerson(this.manager.getSelectedPerson());
        this.textFirst.updateFromModel();
        this.textLast.updateFromModel();
    }

    @OnActionCallback(ridgetId="buttonSort")
    public void sortAction() {
        boolean ascending = this.buttonSort.isSelected();
        this.listPersons.setSortedAscending(ascending);
    }

    @OnDoubleClick(ridgetId="listPersons")
    @OnActionCallback(ridgetId="buttonSort")
    public void dumpDoubleClickedItem() {
        System.out.println("List of selected item(s): " + this.listPersons.getSelection());
    }

    @OnClick(ridgetId="listPersons")
    public void dumpClickedItem(ClickEvent clickEvent) {
        System.out.println("Clicked item: " + this.listPersons.getSelection());
    }

    @OnActionCallback(ridgetId="buttonAdd")
    public void addAction() {
        Person newPerson = new Person("Average", "Joe #" + ++this.count);
        this.manager.getPersons().add(newPerson);
        this.listPersons.updateFromModel();
        this.manager.setSelectedPerson(newPerson);
        this.listPersons.updateSingleSelectionFromModel();
    }

    @OnActionCallback(ridgetId="buttonRemove")
    public void removeAction() {
        Person selPerson = this.manager.getSelectedPerson();
        if (selPerson != null) {
            this.manager.getPersons().remove(selPerson);
            this.listPersons.updateFromModel();
            this.manager.setSelectedPerson(null);
        }
    }

    @OnActionCallback(ridgetId="buttonSave")
    public void saveAction() {
        this.value.update();
        this.listPersons.updateFromModel();
    }

    private void setValuesFromNavigation() {
        NavigationArgument navigationArgument = ((ISubModuleNode)this.getNavigationNode()).getNavigationArgument();
        if (navigationArgument.getParameter() instanceof Integer) {
            int modelIndex = (Integer)navigationArgument.getParameter();
            this.listPersons.setSelection(modelIndex);
        }
    }

    private void bindEnablementToValue(DataBindingContext dbc, IRidget ridget, IObservableValue value) {
        dbc.bindValue(BeansObservables.observeValue((Object)ridget, (String)"enabled"), value, null, null);
    }
}

