/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.example.client.controllers;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.osgi.util.NLS;
import org.eclipse.riena.beans.common.AbstractBean;
import org.eclipse.riena.beans.common.TypedComparator;
import org.eclipse.riena.core.util.Nop;
import org.eclipse.riena.core.util.StringUtils;
import org.eclipse.riena.example.client.controllers.SystemPropertySourceProvider;
import org.eclipse.riena.internal.ui.swt.facades.WorkbenchFacade;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.ui.controllers.SubModuleController;
import org.eclipse.riena.navigation.ui.swt.views.RienaMenuHelper;
import org.eclipse.riena.ui.ridgets.IActionListener;
import org.eclipse.riena.ui.ridgets.IActionRidget;
import org.eclipse.riena.ui.ridgets.ISelectableRidget;
import org.eclipse.riena.ui.ridgets.ITableFormatter;
import org.eclipse.riena.ui.ridgets.ITableRidget;
import org.eclipse.riena.ui.ridgets.ITextRidget;
import org.eclipse.riena.ui.ridgets.IToggleButtonRidget;
import org.eclipse.riena.ui.ridgets.swt.TableFormatter;
import org.eclipse.riena.ui.swt.RienaMessageDialog;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.ISourceProvider;

public class SystemPropertiesSubModuleController
extends SubModuleController {
    private final List<KeyValueBean> properties;
    private final Properties sysProperties;
    private final KeyValueBean valueBean = new KeyValueBean();
    private final IActionListener doubleClickListener = new DoubleClickListener();
    private ITableRidget tableProperties;
    private ITextRidget textKey;
    private ITextRidget textValue;
    private final Font italicFont;
    private SystemPropertySourceProvider systemPropertySourceProvider;

    public SystemPropertiesSubModuleController() {
        this(null);
    }

    public SystemPropertiesSubModuleController(ISubModuleNode navigationNode) {
        super(navigationNode);
        Font tableFont = LnfManager.getLnf().getFont("Table.font");
        FontData fontData = tableFont.getFontData()[0];
        fontData.setStyle(2);
        this.italicFont = new Font(tableFont.getDevice(), fontData);
        this.properties = new ArrayList<KeyValueBean>();
        this.sysProperties = System.getProperties();
        Set<Object> keys = this.sysProperties.keySet();
        for (Object key : keys) {
            KeyValueBean bean = new KeyValueBean();
            bean.setKey((String)key);
            bean.setValue(System.getProperty((String)key));
            this.properties.add(bean);
        }
    }

    private boolean isNewKey(KeyValueBean keyValue) {
        return this.sysProperties.get(keyValue.getKey()) == null;
    }

    private boolean isNewValue(KeyValueBean keyValue) {
        Object value = this.sysProperties.get(keyValue.getKey());
        if (value instanceof String) {
            return !StringUtils.equals((CharSequence)((String)value), (CharSequence)keyValue.getValue());
        }
        return false;
    }

    public void afterBind() {
        super.afterBind();
        this.bindModels();
    }

    private void bindModels() {
        this.tableProperties.bindToModel((IObservableList)new WritableList(this.properties, KeyValueBean.class), KeyValueBean.class, new String[]{"key", "value"}, new String[]{"Key", "Value"});
        this.tableProperties.updateFromModel();
        this.tableProperties.setSelectionType(ISelectableRidget.SelectionType.SINGLE);
        this.tableProperties.setComparator(0, (Comparator)new TypedComparator());
        this.tableProperties.setComparator(1, (Comparator)new TypedComparator());
        this.tableProperties.setMoveableColumns(true);
        if (!this.properties.isEmpty()) {
            this.tableProperties.setSelection(0);
        }
        this.textKey.bindToModel((Object)this.valueBean, "key");
        this.textKey.updateFromModel();
        this.textValue.bindToModel((Object)this.valueBean, "value");
        this.textValue.updateFromModel();
    }

    public void configureRidgets() {
        this.tableProperties = (ITableRidget)this.getRidget(ITableRidget.class, "tableProperties");
        this.textKey = (ITextRidget)this.getRidget(ITextRidget.class, "textKey");
        this.textValue = (ITextRidget)this.getRidget(ITextRidget.class, "textValue");
        IActionRidget buttonAdd = (IActionRidget)this.getRidget(IActionRidget.class, "buttonAdd");
        final IToggleButtonRidget toggleDoubleClick = (IToggleButtonRidget)this.getRidget(IToggleButtonRidget.class, "toggleDoubleClick");
        IActionRidget buttonSave = (IActionRidget)this.getRidget(IActionRidget.class, "buttonSave");
        this.tableProperties.addPropertyChangeListener("selection", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                List selection = SystemPropertiesSubModuleController.this.tableProperties.getSelection();
                if (!selection.isEmpty()) {
                    SystemPropertiesSubModuleController.this.valueBean.setBean((KeyValueBean)((Object)selection.get(0)));
                    SystemPropertiesSubModuleController.this.textKey.updateFromModel();
                    SystemPropertiesSubModuleController.this.textValue.updateFromModel();
                }
            }
        });
        this.tableProperties.setTableFormatter((ITableFormatter)new MyTableFormatter());
        buttonAdd.setText("&Add");
        buttonAdd.addListener(new IActionListener(){
            private int count = 0;

            public void callback() {
                KeyValueBean bean = new KeyValueBean();
                bean.setKey("key" + ++this.count);
                bean.setValue("newValue");
                SystemPropertiesSubModuleController.this.properties.add(bean);
                SystemPropertiesSubModuleController.this.tableProperties.updateFromModel();
                SystemPropertiesSubModuleController.this.tableProperties.setSelection((Object)bean);
                ((Table)SystemPropertiesSubModuleController.this.tableProperties.getUIControl()).showSelection();
            }
        });
        toggleDoubleClick.setText("Handle &Double Click");
        toggleDoubleClick.addListener(new IActionListener(){

            public void callback() {
                if (toggleDoubleClick.isSelected()) {
                    SystemPropertiesSubModuleController.this.tableProperties.addDoubleClickListener(SystemPropertiesSubModuleController.this.doubleClickListener);
                } else {
                    SystemPropertiesSubModuleController.this.tableProperties.removeDoubleClickListener(SystemPropertiesSubModuleController.this.doubleClickListener);
                }
            }
        });
        buttonSave.setText("&Save");
        buttonSave.addListener(new IActionListener(){

            public void callback() {
                SystemPropertiesSubModuleController.this.valueBean.update();
                System.setProperty(SystemPropertiesSubModuleController.this.valueBean.getKey(), SystemPropertiesSubModuleController.this.valueBean.getValue());
                SystemPropertiesSubModuleController.this.propertyChanged(SystemPropertiesSubModuleController.this.valueBean.getKey());
                SystemPropertiesSubModuleController.this.tableProperties.updateFromModel();
            }
        });
    }

    private SystemPropertySourceProvider getSystemPropertySourceProvider() {
        ISourceProvider[] sourceProviders;
        RienaMenuHelper menuBindHelper = new RienaMenuHelper();
        ISourceProvider[] iSourceProviderArray = sourceProviders = menuBindHelper.getSourceProviders();
        int n = sourceProviders.length;
        int n2 = 0;
        while (n2 < n) {
            ISourceProvider sourceProvider = iSourceProviderArray[n2];
            if (sourceProvider instanceof SystemPropertySourceProvider) {
                return (SystemPropertySourceProvider)sourceProvider;
            }
            ++n2;
        }
        return null;
    }

    private void propertyChanged(String propName) {
        if (this.systemPropertySourceProvider == null) {
            this.systemPropertySourceProvider = this.getSystemPropertySourceProvider();
        }
        if (this.systemPropertySourceProvider != null) {
            if (!this.systemPropertySourceProvider.isDisposed()) {
                this.systemPropertySourceProvider.propertyChanged(propName);
            } else {
                this.systemPropertySourceProvider = null;
            }
        }
    }

    private final class DoubleClickListener
    implements IActionListener {
        private DoubleClickListener() {
        }

        public void callback() {
            Shell shell = WorkbenchFacade.getInstance().getActiveShell();
            String message = "The key ''{0}'' is selected and has the value ''{1}''";
            message = NLS.bind((String)message, (Object)SystemPropertiesSubModuleController.this.valueBean.getKey(), (Object)SystemPropertiesSubModuleController.this.valueBean.getValue());
            RienaMessageDialog.openInformation((Shell)shell, (String)"Information", (String)message);
        }
    }

    public static final class KeyValueBean
    extends AbstractBean {
        private KeyValueBean bean;
        private String tempKey;
        private String tempValue;

        public String getKey() {
            return this.tempKey;
        }

        public void setKey(String key) {
            this.tempKey = key;
        }

        public String getValue() {
            return this.tempValue;
        }

        public void setValue(String value) {
            this.tempValue = value;
        }

        public void setBean(KeyValueBean bean) {
            this.bean = bean;
            this.setKey(bean.getKey());
            this.setValue(bean.getValue());
        }

        public void update() {
            this.bean.setKey(this.tempKey);
            this.bean.setValue(this.tempValue);
        }
    }

    private final class MyTableFormatter
    extends TableFormatter {
        private MyTableFormatter() {
        }

        public Object getFont(Object rowElement, Object cellElement, int columnIndex) {
            if (cellElement instanceof String && columnIndex == 1) {
                try {
                    Double.parseDouble((String)cellElement);
                    return SystemPropertiesSubModuleController.this.italicFont;
                }
                catch (NumberFormatException numberFormatException) {
                    Nop.reason((String)"No number, use default font.");
                }
            }
            return super.getFont(rowElement, cellElement, columnIndex);
        }

        public Object getForeground(Object rowElement, Object cellElement, int columnIndex) {
            if (rowElement instanceof KeyValueBean) {
                KeyValueBean keyValue = (KeyValueBean)((Object)rowElement);
                if (SystemPropertiesSubModuleController.this.isNewKey(keyValue)) {
                    return LnfManager.getLnf().getColor("red");
                }
                if (columnIndex == 1 && SystemPropertiesSubModuleController.this.isNewValue(keyValue)) {
                    return LnfManager.getLnf().getColor("blue");
                }
            }
            return super.getForeground(rowElement, cellElement, columnIndex);
        }
    }
}

