/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.controllers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.riena.navigation.ApplicationNodeManager;
import org.eclipse.riena.navigation.IModuleNode;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.listener.INavigationNodeListener;
import org.eclipse.riena.navigation.listener.ModuleNodeListener;
import org.eclipse.riena.navigation.ui.controllers.NavigationNodeController;
import org.eclipse.riena.navigation.ui.controllers.SubModuleController;
import org.eclipse.riena.ui.ridgets.IWindowRidget;
import org.eclipse.riena.ui.ridgets.listener.IWindowRidgetListener;

public class ModuleController
extends NavigationNodeController<IModuleNode> {
    private IWindowRidget windowRidget;
    private final IWindowRidgetListener windowListener;
    private boolean closeable = true;
    private boolean dragEnabled = true;

    public ModuleController(IModuleNode navigationNode) {
        super(navigationNode);
        ((IModuleNode)this.getNavigationNode()).addListener((INavigationNodeListener)new MyModuleNodeListener());
        this.windowListener = new WindowListener();
    }

    public void setWindowRidget(IWindowRidget windowRidget) {
        if (this.getWindowRidget() != null) {
            this.getWindowRidget().removeWindowRidgetListener(this.windowListener);
        }
        this.windowRidget = windowRidget;
        if (this.getWindowRidget() != null) {
            this.getWindowRidget().addWindowRidgetListener(this.windowListener);
        }
    }

    public IWindowRidget getWindowRidget() {
        return this.windowRidget;
    }

    public void configureRidgets() {
        this.setCloseable(((IModuleNode)this.getNavigationNode()).isClosable());
    }

    @Override
    public void afterBind() {
        super.afterBind();
        this.updateWindowTitle();
        this.updateToolTipText();
        this.updateIcon();
        this.updateCloseable();
        this.updateActive();
    }

    private void updateIcon() {
        this.updateIcon(this.getWindowRidget());
    }

    private void updateWindowTitle() {
        if (this.getWindowRidget() != null) {
            this.getWindowRidget().setTitle(((IModuleNode)this.getNavigationNode()).getLabel());
            ISubModuleNode subModule = ApplicationNodeManager.getActiveSubModule((IModuleNode)((IModuleNode)this.getNavigationNode()));
            if (subModule != null && subModule.getNavigationNodeController() instanceof SubModuleController) {
                ((SubModuleController)subModule.getNavigationNodeController()).updateWindowTitle();
            }
        }
    }

    private void updateToolTipText() {
        if (this.getWindowRidget() != null) {
            this.getWindowRidget().setToolTipText(((IModuleNode)this.getNavigationNode()).getToolTipText());
        }
    }

    private void updateCloseable() {
        if (this.getWindowRidget() != null) {
            this.getWindowRidget().setCloseable(((IModuleNode)this.getNavigationNode()).isClosable());
        }
    }

    private void updateActive() {
        if (this.getWindowRidget() != null) {
            this.getWindowRidget().setActive(((IModuleNode)this.getNavigationNode()).isActivated());
        }
    }

    public boolean hasSingleLeafChild() {
        List<INavigationNode<?>> children = this.getVisibleChildren((INavigationNode<?>)this.getNavigationNode());
        return children.size() == 1 && children.get(0).isLeaf();
    }

    public List<INavigationNode<?>> getVisibleChildren(INavigationNode<?> parent) {
        ArrayList visibleChildren = new ArrayList();
        for (Object child : parent.getChildren()) {
            INavigationNode childNode;
            if (!(child instanceof INavigationNode) || !(childNode = (INavigationNode)child).isVisible()) continue;
            visibleChildren.add(childNode);
        }
        return visibleChildren;
    }

    public boolean isFirstChild() {
        return ((IModuleNode)this.getNavigationNode()).getParent().getChild(0) == this.getNavigationNode();
    }

    public boolean isCloseable() {
        return this.closeable;
    }

    public void setCloseable(boolean closeable) {
        this.closeable = closeable;
    }

    public boolean isDragEnabled() {
        return this.dragEnabled;
    }

    public void setDragEnabled(boolean dragEnabled) {
        this.dragEnabled = dragEnabled;
    }

    private final class MyModuleNodeListener
    extends ModuleNodeListener {
        private MyModuleNodeListener() {
        }

        public void labelChanged(IModuleNode moduleNode) {
            ModuleController.this.updateWindowTitle();
        }

        public void iconChanged(IModuleNode source) {
            ModuleController.this.updateIcon();
        }
    }

    private class WindowListener
    implements IWindowRidgetListener {
        private WindowListener() {
        }

        public void activated() {
            ((IModuleNode)ModuleController.this.getNavigationNode()).activate();
        }

        public void closed() {
            ((IModuleNode)ModuleController.this.getNavigationNode()).dispose();
        }
    }
}

