/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.model;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.riena.core.util.VariableManagerUtil;
import org.eclipse.riena.navigation.AbstractNavigationAssembler;
import org.eclipse.riena.navigation.ApplicationModelFailure;
import org.eclipse.riena.navigation.IAssemblerProvider;
import org.eclipse.riena.navigation.IGenericNavigationAssembler;
import org.eclipse.riena.navigation.IModuleGroupNode;
import org.eclipse.riena.navigation.IModuleNode;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.ISubApplicationNode;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.NavigationArgument;
import org.eclipse.riena.navigation.NavigationNodeId;
import org.eclipse.riena.navigation.extension.IModuleGroupNode2Extension;
import org.eclipse.riena.navigation.extension.IModuleNode2Extension;
import org.eclipse.riena.navigation.extension.INode2Extension;
import org.eclipse.riena.navigation.extension.ISubApplicationNode2Extension;
import org.eclipse.riena.navigation.extension.ISubModuleNode2Extension;
import org.eclipse.riena.navigation.extension.Node2Extension;
import org.eclipse.riena.navigation.model.ExtensionPointFailure;
import org.eclipse.riena.navigation.model.ModuleGroupNode;
import org.eclipse.riena.navigation.model.ModuleNode;
import org.eclipse.riena.navigation.model.SubApplicationNode;
import org.eclipse.riena.navigation.model.SubModuleNode;
import org.eclipse.riena.navigation.model.ThreadLocalMapResolver;

public class GenericNavigationAssembler
extends AbstractNavigationAssembler
implements IGenericNavigationAssembler {
    public static final String VAR_NAVIGATION_NODEID = "riena.navigation.nodeid";
    public static final String VAR_NAVIGATION_NODECONTEXT = "riena.navigation.nodecontext";
    public static final String VAR_NAVIGATION_PARAMETER = "riena.navigation.parameter";
    protected Set<String> acceptedTargetIds = null;
    private IAssemblerProvider assemblerProvider;

    protected final void initializeAcceptedTargetIds() {
        if (this.getAssembly() != null) {
            ISubModuleNode2Extension[] subModules;
            IModuleNode2Extension[] modules;
            IModuleGroupNode2Extension[] groups;
            ISubApplicationNode2Extension[] subApplications;
            ISubApplicationNode2Extension[] iSubApplicationNode2ExtensionArray = subApplications = this.getAssembly().getSubApplications();
            int n = subApplications.length;
            int n2 = 0;
            while (n2 < n) {
                ISubApplicationNode2Extension subApplication = iSubApplicationNode2ExtensionArray[n2];
                this.resolveTargetIds(subApplication);
                ++n2;
            }
            IModuleGroupNode2Extension[] iModuleGroupNode2ExtensionArray = groups = this.getAssembly().getModuleGroups();
            int n3 = groups.length;
            n = 0;
            while (n < n3) {
                IModuleGroupNode2Extension group = iModuleGroupNode2ExtensionArray[n];
                this.resolveTargetIds(group);
                ++n;
            }
            IModuleNode2Extension[] iModuleNode2ExtensionArray = modules = this.getAssembly().getModules();
            int n4 = modules.length;
            n3 = 0;
            while (n3 < n4) {
                IModuleNode2Extension module = iModuleNode2ExtensionArray[n3];
                this.resolveTargetIds(module);
                ++n3;
            }
            ISubModuleNode2Extension[] iSubModuleNode2ExtensionArray = subModules = this.getAssembly().getSubModules();
            int n5 = subModules.length;
            n4 = 0;
            while (n4 < n5) {
                ISubModuleNode2Extension subModule = iSubModuleNode2ExtensionArray[n4];
                this.resolveTargetIds(subModule);
                ++n4;
            }
        }
    }

    private void resolveTargetIds(ISubApplicationNode2Extension subapplicationDefinition) {
        this.updateAcceptedTargetIds(subapplicationDefinition.getNodeId());
        if (subapplicationDefinition.getChildNodes() != null) {
            IModuleGroupNode2Extension[] iModuleGroupNode2ExtensionArray = subapplicationDefinition.getChildNodes();
            int n = iModuleGroupNode2ExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IModuleGroupNode2Extension groupDefinition = iModuleGroupNode2ExtensionArray[n2];
                this.resolveTargetIds(groupDefinition);
                ++n2;
            }
        }
    }

    private void resolveTargetIds(IModuleGroupNode2Extension groupDefinition) {
        this.updateAcceptedTargetIds(groupDefinition.getNodeId());
        if (groupDefinition.getChildNodes() != null) {
            IModuleNode2Extension[] iModuleNode2ExtensionArray = groupDefinition.getChildNodes();
            int n = iModuleNode2ExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IModuleNode2Extension moduleDefinition = iModuleNode2ExtensionArray[n2];
                this.resolveTargetIds(moduleDefinition);
                ++n2;
            }
        }
    }

    private void resolveTargetIds(IModuleNode2Extension moduleDefinition) {
        this.updateAcceptedTargetIds(moduleDefinition.getNodeId());
        if (moduleDefinition.getChildNodes() != null) {
            ISubModuleNode2Extension[] iSubModuleNode2ExtensionArray = moduleDefinition.getChildNodes();
            int n = iSubModuleNode2ExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                ISubModuleNode2Extension submoduleDefinition = iSubModuleNode2ExtensionArray[n2];
                this.resolveTargetIds(submoduleDefinition);
                ++n2;
            }
        }
    }

    private void resolveTargetIds(ISubModuleNode2Extension submoduleDefinition) {
        this.updateAcceptedTargetIds(submoduleDefinition.getNodeId());
        if (submoduleDefinition.getChildNodes() != null) {
            ISubModuleNode2Extension[] iSubModuleNode2ExtensionArray = submoduleDefinition.getChildNodes();
            int n = iSubModuleNode2ExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                ISubModuleNode2Extension nestedDefinition = iSubModuleNode2ExtensionArray[n2];
                this.resolveTargetIds(nestedDefinition);
                ++n2;
            }
        }
    }

    @Override
    public INavigationNode<?>[] buildNode(NavigationNodeId targetId, NavigationArgument navigationArgument) {
        if (this.getAssembly() != null) {
            HashMap<String, Object> context = new HashMap<String, Object>();
            ISubApplicationNode2Extension[] subApplications = this.getAssembly().getSubApplications();
            if (subApplications != null && subApplications.length > 0) {
                INavigationNode[] nodes = new INavigationNode[subApplications.length];
                int i = 0;
                while (i < subApplications.length) {
                    nodes[i] = this.build(subApplications[i], targetId, navigationArgument, context);
                    ++i;
                }
                return nodes;
            }
            IModuleGroupNode2Extension[] groups = this.getAssembly().getModuleGroups();
            if (groups != null && groups.length > 0) {
                INavigationNode[] nodes = new INavigationNode[groups.length];
                int i = 0;
                while (i < groups.length) {
                    nodes[i] = this.build(groups[i], targetId, navigationArgument, context);
                    ++i;
                }
                return nodes;
            }
            IModuleNode2Extension[] modules = this.getAssembly().getModules();
            if (modules != null && modules.length > 0) {
                INavigationNode[] nodes = new INavigationNode[modules.length];
                int i = 0;
                while (i < modules.length) {
                    nodes[i] = this.build(modules[i], targetId, navigationArgument, context);
                    ++i;
                }
                return nodes;
            }
            ISubModuleNode2Extension[] subModules = this.getAssembly().getSubModules();
            if (subModules != null && subModules.length > 0) {
                INavigationNode[] nodes = new INavigationNode[subModules.length];
                int i = 0;
                while (i < subModules.length) {
                    nodes[i] = this.build(subModules[i], targetId, navigationArgument, context);
                    ++i;
                }
                return nodes;
            }
        }
        throw new ExtensionPointFailure("'subapplication', 'modulegroup', 'module' or 'submodule' element expected. ID=" + targetId.getTypeId());
    }

    protected ISubApplicationNode build(ISubApplicationNode2Extension subApplicationDefinition, NavigationNodeId targetId, NavigationArgument navigationArgument, Map<String, Object> context) {
        Assert.isNotNull((Object)subApplicationDefinition, (String)"Error building sub-application. Sub\u00e4-application cannot be null");
        Assert.isNotNull((Object)subApplicationDefinition.getPerspectiveId(), (String)("Error building sub-application. Attribute 'perspectiveId' cannot be null for sub-application = " + subApplicationDefinition.getPerspectiveId()));
        SubApplicationNode subapplication = new SubApplicationNode(this.createNavigationNodeIdFromTemplate(targetId, subApplicationDefinition, navigationArgument), subApplicationDefinition.getName());
        subapplication.setIcon(subApplicationDefinition.getIcon());
        this.updateContext(subapplication, navigationArgument);
        if (subApplicationDefinition.getChildNodes() != null) {
            IModuleGroupNode2Extension[] iModuleGroupNode2ExtensionArray = subApplicationDefinition.getChildNodes();
            int n = iModuleGroupNode2ExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IModuleGroupNode2Extension child = iModuleGroupNode2ExtensionArray[n2];
                subapplication.addChild(this.build(child, targetId, navigationArgument, this.copy(context)));
                ++n2;
            }
        }
        return subapplication;
    }

    protected IModuleGroupNode build(IModuleGroupNode2Extension groupDefinition, NavigationNodeId targetId, NavigationArgument navigationArgument, Map<String, Object> context) {
        ModuleGroupNode moduleGroup = new ModuleGroupNode(this.createNavigationNodeIdFromTemplate(targetId, groupDefinition, navigationArgument));
        moduleGroup.setLabel(groupDefinition.getName());
        moduleGroup.setIcon(groupDefinition.getIcon());
        this.updateContext(moduleGroup, navigationArgument);
        if (groupDefinition.getChildNodes() != null) {
            IModuleNode2Extension[] iModuleNode2ExtensionArray = groupDefinition.getChildNodes();
            int n = iModuleNode2ExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IModuleNode2Extension child = iModuleNode2ExtensionArray[n2];
                moduleGroup.addChild(this.build(child, targetId, navigationArgument, this.copy(context)));
                ++n2;
            }
        }
        return moduleGroup;
    }

    protected IModuleNode build(IModuleNode2Extension moduleDefinition, NavigationNodeId targetId, NavigationArgument navigationArgument, Map<String, Object> context) {
        ModuleNode module = null;
        Map<String, Object> mapping = this.createMapping(targetId, navigationArgument);
        try {
            this.startVariableResolver(mapping);
            String label = moduleDefinition.getName();
            if (moduleDefinition instanceof Node2Extension) {
                label = this.resolveVariables(label);
            }
            module = new ModuleNode(this.createNavigationNodeIdFromTemplate(targetId, moduleDefinition, navigationArgument), label);
            module.setIcon(moduleDefinition.getIcon());
            module.setClosable(moduleDefinition.isClosable());
            this.updateContext(module, navigationArgument);
            if (moduleDefinition.getChildNodes() != null) {
                ISubModuleNode2Extension[] iSubModuleNode2ExtensionArray = moduleDefinition.getChildNodes();
                int n = iSubModuleNode2ExtensionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ISubModuleNode2Extension child = iSubModuleNode2ExtensionArray[n2];
                    module.addChild(this.build(child, targetId, navigationArgument, this.copy(context)));
                    ++n2;
                }
            }
        }
        finally {
            this.cleanupVariableResolver();
        }
        return module;
    }

    protected ISubModuleNode build(ISubModuleNode2Extension subModuleDefinition, NavigationNodeId targetId, NavigationArgument navigationArgument, Map<String, Object> context) {
        SubModuleNode submodule = null;
        Map<String, Object> mapping = this.createMapping(targetId, navigationArgument);
        mapping.put(VAR_NAVIGATION_NODECONTEXT, context);
        try {
            this.startVariableResolver(mapping);
            String label = subModuleDefinition.getName();
            if (subModuleDefinition instanceof Node2Extension) {
                label = this.resolveVariables(label);
            }
            submodule = new SubModuleNode(this.createNavigationNodeIdFromTemplate(targetId, subModuleDefinition, navigationArgument), label);
            submodule.setIcon(subModuleDefinition.getIcon());
            submodule.setVisible(subModuleDefinition.isVisible());
            submodule.setExpanded(subModuleDefinition.isExpanded());
            submodule.setClosable(subModuleDefinition.isClosable());
            submodule.setSelectable(subModuleDefinition.isSelectable());
            this.updateContext(submodule, navigationArgument);
            if (subModuleDefinition.getChildNodes() != null) {
                ISubModuleNode2Extension[] iSubModuleNode2ExtensionArray = subModuleDefinition.getChildNodes();
                int n = iSubModuleNode2ExtensionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ISubModuleNode2Extension child = iSubModuleNode2ExtensionArray[n2];
                    submodule.addChild(this.build(child, targetId, navigationArgument, this.copy(context)));
                    ++n2;
                }
            }
        }
        finally {
            this.cleanupVariableResolver();
        }
        return submodule;
    }

    protected NavigationNodeId createNavigationNodeIdFromTemplate(NavigationNodeId template, INode2Extension nodeExtension, NavigationArgument navigationArgument) {
        String typeId = nodeExtension.getNodeId();
        String instanceId = template.getInstanceId();
        return new NavigationNodeId(typeId, instanceId);
    }

    @Override
    public void setAssemblerProvider(IAssemblerProvider assemblyProvider) {
        this.assemblerProvider = assemblyProvider;
    }

    public IAssemblerProvider getAssemblerProvider() {
        return this.assemblerProvider;
    }

    @Override
    public boolean acceptsToBuildNode(NavigationNodeId nodeId, NavigationArgument argument) {
        return this.getAcceptedTargetIds().contains(nodeId.getTypeId());
    }

    public Collection<String> getAcceptedTargetIds() {
        if (this.acceptedTargetIds == null) {
            this.acceptedTargetIds = new HashSet<String>();
            this.initializeAcceptedTargetIds();
            this.acceptedTargetIds = Collections.unmodifiableSet(this.acceptedTargetIds);
        }
        return new HashSet<String>(this.acceptedTargetIds);
    }

    protected void updateAcceptedTargetIds(String typeId) {
        if (typeId != null) {
            this.acceptedTargetIds.add(typeId);
        }
    }

    protected Map<String, Object> copy(Map<String, Object> context) {
        return new HashMap<String, Object>(context);
    }

    protected void updateContext(INavigationNode<?> node, NavigationArgument navigationArgument) {
    }

    protected Map<String, Object> createMapping(NavigationNodeId targetId, NavigationArgument navigationArgument) {
        HashMap<String, Object> mapping = new HashMap<String, Object>();
        mapping.put(VAR_NAVIGATION_NODEID, targetId);
        if (navigationArgument != null) {
            mapping.put(VAR_NAVIGATION_PARAMETER, navigationArgument.getParameter());
        }
        return mapping;
    }

    protected void startVariableResolver(Map<String, Object> mapping) {
        ThreadLocalMapResolver.configure(mapping);
    }

    protected void cleanupVariableResolver() {
        ThreadLocalMapResolver.cleanup();
    }

    protected String resolveVariables(String string) {
        try {
            return VariableManagerUtil.substitute((String)string);
        }
        catch (CoreException e) {
            throw new ApplicationModelFailure("Resolving variables in '" + string + "' failed", e);
        }
    }
}

