/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.security.ui.filter;

import java.lang.reflect.Constructor;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.riena.core.injector.InjectionFailure;
import org.eclipse.riena.core.service.Service;
import org.eclipse.riena.core.util.StringUtils;
import org.eclipse.riena.core.wire.InjectExtension;
import org.eclipse.riena.core.wire.InjectService;
import org.eclipse.riena.internal.navigation.ui.filter.IUIFilterApplier;
import org.eclipse.riena.navigation.IApplicationNode;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.ISimpleNavigationNodeListener;
import org.eclipse.riena.navigation.NavigationNodeUtility;
import org.eclipse.riena.navigation.model.SimpleNavigationNodeAdapter;
import org.eclipse.riena.security.common.authorization.ISentinelService;
import org.eclipse.riena.security.ui.filter.IPermissionFilterMappingExtension;
import org.eclipse.riena.security.ui.filter.NodeStructureObserver;
import org.eclipse.riena.security.ui.filter.UserInterfacePermission;
import org.eclipse.riena.ui.filter.IUIFilter;
import org.eclipse.riena.ui.filter.IUIFilterContainer;
import org.eclipse.riena.ui.filter.IUIFilterProvider;

public class PermissionUIFilterApplier
implements IUIFilterApplier {
    private IApplicationNode applicationNode;
    private final List<PermissionFilterMapping> permissionFilterMappings = new ArrayList<PermissionFilterMapping>();
    private ISentinelService sentinel;

    public void applyFilter(INavigationNode<?> navigationNode) {
        if (!(navigationNode instanceof IApplicationNode)) {
            return;
        }
        this.applicationNode = (IApplicationNode)navigationNode;
        this.updateFilters();
        this.observeNavigationModel();
    }

    protected void observeNavigationModel() {
        new NodeStructureObserver(this.applicationNode, this.createStructureEventDelegation()).start();
    }

    private void updateFilters() {
        if (this.permissionFilterMappings.size() == 0) {
            return;
        }
        for (PermissionFilterMapping mapper : this.permissionFilterMappings) {
            if (this.sentinel.checkAccess(mapper.getPermission())) continue;
            IUIFilterContainer container = mapper.getFilterContainer();
            IUIFilter filter = container.getFilter();
            Collection targetNodeIds = container.getFilterTargetNodeIds();
            for (String targetNodeId : targetNodeIds) {
                ArrayList nodes = new ArrayList();
                NavigationNodeUtility.findNodesByLongId((String)targetNodeId, (INavigationNode)this.applicationNode, nodes);
                for (INavigationNode node : nodes) {
                    if (node.getFilters().contains(filter)) continue;
                    node.addFilter(filter);
                }
            }
        }
    }

    private ISimpleNavigationNodeListener createStructureEventDelegation() {
        return new SimpleNavigationNodeAdapter(){

            public void childAdded(INavigationNode<?> source, INavigationNode<?> childAdded) {
                PermissionUIFilterApplier.this.updateFilters();
            }

            public void childRemoved(INavigationNode<?> source, INavigationNode<?> childRemoved) {
                PermissionUIFilterApplier.this.updateFilters();
            }
        };
    }

    @InjectService
    public void bind(ISentinelService sentinel) {
        this.sentinel = sentinel;
    }

    public void unbind(ISentinelService sentinel) {
        if (this.sentinel == sentinel) {
            this.sentinel = null;
        }
    }

    @InjectExtension
    public void update(IPermissionFilterMappingExtension[] principalFilterMappers) {
        this.permissionFilterMappings.clear();
        IUIFilterProvider uiFilterProvider = this.getUIFilterProvider();
        IPermissionFilterMappingExtension[] iPermissionFilterMappingExtensionArray = principalFilterMappers;
        int n = principalFilterMappers.length;
        int n2 = 0;
        while (n2 < n) {
            IPermissionFilterMappingExtension mapping = iPermissionFilterMappingExtensionArray[n2];
            this.permissionFilterMappings.add(new PermissionFilterMapping(this.createPermission(mapping), uiFilterProvider.provideFilter(mapping.getFilterID())));
            ++n2;
        }
    }

    protected IUIFilterProvider getUIFilterProvider() {
        return (IUIFilterProvider)Service.get(IUIFilterProvider.class);
    }

    private Permission createPermission(IPermissionFilterMappingExtension mapping) {
        Class<? extends Permission> permissionClass = mapping.getPermissionClass();
        if (permissionClass == null) {
            permissionClass = UserInterfacePermission.class;
        }
        try {
            if (StringUtils.isEmpty((CharSequence)mapping.getPermissionAction())) {
                Constructor<? extends Permission> constructor = permissionClass.getConstructor(String.class);
                return constructor.newInstance(mapping.getPermissionName());
            }
            Constructor<? extends Permission> constructor = permissionClass.getConstructor(String.class, String.class);
            return constructor.newInstance(mapping.getPermissionName(), mapping.getPermissionAction());
        }
        catch (Exception e) {
            throw new InjectionFailure("Could not create permission from '" + mapping + "'s.", (Throwable)e);
        }
    }

    private class PermissionFilterMapping {
        private final Permission permission;
        private final IUIFilterContainer filterContainer;

        public PermissionFilterMapping(Permission permission, IUIFilterContainer filterContainer) {
            this.permission = permission;
            this.filterContainer = filterContainer;
        }

        public Permission getPermission() {
            return this.permission;
        }

        public IUIFilterContainer getFilterContainer() {
            return this.filterContainer;
        }
    }
}

