/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import java.beans.PropertyDescriptor;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.Assert;
import org.eclipse.equinox.log.Logger;
import org.eclipse.jface.viewers.AbstractTableViewer;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.core.util.RAPDetector;
import org.eclipse.riena.core.util.StringUtils;
import org.eclipse.riena.internal.ui.ridgets.swt.AbstractTableRidget;
import org.eclipse.riena.internal.ui.ridgets.swt.TableComparator;
import org.eclipse.riena.internal.ui.ridgets.swt.TableRidgetLabelProvider;
import org.eclipse.riena.internal.ui.ridgets.swt.TableRidgetTableViewer;
import org.eclipse.riena.internal.ui.ridgets.swt.TableWrapper;
import org.eclipse.riena.ui.common.ISortableByColumn;
import org.eclipse.riena.ui.core.marker.RowErrorMessageMarker;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.listener.ClickEvent;
import org.eclipse.riena.ui.ridgets.swt.MarkerSupport;
import org.eclipse.riena.ui.ridgets.swt.SortableComparator;
import org.eclipse.riena.ui.swt.facades.SWTFacade;
import org.eclipse.riena.ui.swt.facades.TableRidgetToolTipSupportFacade;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class TableRidget
extends AbstractTableRidget {
    private static final Logger LOGGER = Log4r.getLogger(TableRidget.class);
    private TableTooltipManager tooltipManager;
    private ControlListener columnResizeListener;
    private final Listener itemEraser;

    public TableRidget() {
        this.sortListener = new ColumnSortListener();
        this.itemEraser = new TableItemEraser();
    }

    @Override
    protected final void checkUIControl(Object uiControl) {
        this.checkType(uiControl, Table.class);
    }

    @Override
    protected final void bindUIControl() {
        final Table control = this.getUIControl();
        if (control != null) {
            control.removeAll();
        }
        super.bindUIControl();
        if (control != null) {
            this.columnResizeListener = new ControlListener(){

                public void controlResized(ControlEvent e) {
                    TableRidget.this.applyTableColumnHeaders();
                }

                public void controlMoved(ControlEvent e) {
                    TableRidget.this.applyTableColumnHeaders();
                }
            };
            TableColumn[] tableColumnArray = control.getColumns();
            int n = tableColumnArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableColumn column = tableColumnArray[n2];
                column.addSelectionListener(this.sortListener);
                column.addControlListener(this.columnResizeListener);
                ++n2;
            }
            control.addSelectionListener(this.selectionTypeEnforcer);
            SWTFacade facade = SWTFacade.getDefault();
            facade.addEraseItemListener(control, this.itemEraser);
            control.addListener(9, new Listener(){
                private boolean disable;

                public void handleEvent(Event event) {
                    if (this.disable) {
                        return;
                    }
                    this.disable = true;
                    control.getParent().layout(true, true);
                }
            });
        }
    }

    @Override
    protected final void unbindUIControl() {
        super.unbindUIControl();
        Table control = this.getUIControl();
        if (control != null) {
            TableColumn[] tableColumnArray = control.getColumns();
            int n = tableColumnArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableColumn column = tableColumnArray[n2];
                column.removeSelectionListener(this.sortListener);
                column.removeControlListener(this.columnResizeListener);
                ++n2;
            }
            control.removeSelectionListener(this.selectionTypeEnforcer);
            SWTFacade facade = SWTFacade.getDefault();
            facade.removeEraseItemListener(control, this.itemEraser);
            if (this.tooltipManager != null) {
                facade.removeMouseTrackListener((Control)control, (MouseTrackListener)this.tooltipManager);
                facade.removeMouseMoveListener((Control)control, (Object)this.tooltipManager);
            }
        }
    }

    @Override
    protected final int getUiSelectionCount() {
        Table control = this.getUIControl();
        return control == null ? -1 : control.getSelectionCount();
    }

    @Override
    protected final void setUiSelection(Widget item) {
        Assert.isTrue((boolean)(item instanceof TableItem));
        Table control = this.getUIControl();
        if (control != null) {
            control.setSelection((TableItem)item);
        }
    }

    @Override
    public int getSelectionIndex() {
        Table control = this.getUIControl();
        return control == null ? -1 : control.getSelectionIndex();
    }

    @Override
    public int[] getSelectionIndices() {
        Table control = this.getUIControl();
        return control == null ? new int[]{} : control.getSelectionIndices();
    }

    public Table getUIControl() {
        return (Table)super.getUIControl();
    }

    protected TableViewer getTableViewer() {
        return (TableViewer)super.getTableViewer();
    }

    @Override
    protected final void applyColumns() {
        Table control = this.getUIControl();
        if (control == null) {
            return;
        }
        int expectedCols = this.getExpectedColumnCount();
        if (this.getColumnCount() != expectedCols) {
            TableColumn[] tableColumnArray = control.getColumns();
            int n = tableColumnArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableColumn column = tableColumnArray[n2];
                column.dispose();
                ++n2;
            }
            int i = 0;
            while (i < expectedCols) {
                new TableColumn(control, 0);
                ++i;
            }
            this.applyColumnWidths();
        }
        TableColumn[] columns = control.getColumns();
        int columnIndex = 0;
        while (columnIndex < columns.length) {
            TableViewerColumn viewerColumn = new TableViewerColumn(this.getTableViewer(), columns[columnIndex]);
            this.applyEditingSupport((ViewerColumn)viewerColumn, columnIndex);
            ++columnIndex;
        }
    }

    @Override
    protected final void applyColumnsMovable() {
        Table control = this.getUIControl();
        if (control == null) {
            return;
        }
        TableColumn[] tableColumnArray = control.getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            column.setMoveable(this.hasMoveableColumns());
            ++n2;
        }
    }

    @Override
    protected final void applyComparator(Map<Integer, Comparator<?>> comparatorMap) {
        if (this.getTableViewer() != null) {
            Comparator<?> compi = null;
            if (this.getSortedColumn() != -1) {
                Integer key = this.getSortedColumn();
                compi = comparatorMap.get(key);
            }
            Table table = this.getUIControl();
            if (compi != null) {
                TableColumn column = table.getColumn(this.getSortedColumn());
                table.setSortColumn(column);
                int direction = this.getSortDirection();
                table.setSortDirection(direction);
                SortableComparator sortableComparator = new SortableComparator((ISortableByColumn)this, compi);
                this.getTableViewer().setComparator((ViewerComparator)new TableComparator(sortableComparator));
            } else {
                this.getTableViewer().setComparator(null);
                table.setSortColumn(null);
                table.setSortDirection(0);
            }
        }
    }

    @Override
    protected final void applyTableColumnHeaders() {
        Table control = this.getUIControl();
        if (control == null) {
            return;
        }
        boolean headersVisible = this.columnHeaders != null;
        control.setHeaderVisible(headersVisible);
        if (headersVisible) {
            TableColumn[] columns = control.getColumns();
            int i = 0;
            while (i < columns.length) {
                String columnHeader = "";
                if (i < this.columnHeaders.length && this.columnHeaders[i] != null) {
                    columnHeader = this.columnHeaders[i];
                }
                columns[i].setText(columnHeader);
                String tooltip = this.isShowColumnTooltip(columns[i], columnHeader) ? columnHeader : "";
                columns[i].setToolTipText(tooltip);
                ++i;
            }
        }
    }

    @Override
    protected int getColumnStyle(int columnIndex) {
        this.checkColumnRange(columnIndex);
        Table control = this.getUIControl();
        if (control == null) {
            return -1;
        }
        TableColumn[] columns = control.getColumns();
        return columns[columnIndex].getStyle();
    }

    @Override
    protected final void updateToolTipSupport() {
        SWTFacade facade = SWTFacade.getDefault();
        if (this.isNativeToolTip() || !TableRidgetToolTipSupportFacade.getDefault().isSupported()) {
            TableRidgetToolTipSupportFacade.getDefault().disable();
            if (this.tooltipManager == null) {
                this.tooltipManager = new TableTooltipManager();
                this.tooltipManager.init((Control)this.getUIControl());
            }
            facade.addMouseTrackListener((Control)this.getUIControl(), (MouseTrackListener)this.tooltipManager);
            facade.addMouseMoveListener((Control)this.getUIControl(), (MouseMoveListener)this.tooltipManager);
        } else {
            if (this.tooltipManager != null) {
                facade.removeMouseTrackListener((Control)this.getUIControl(), (MouseTrackListener)this.tooltipManager);
                facade.removeMouseMoveListener((Control)this.getUIControl(), (Object)this.tooltipManager);
            }
            if (this.getTableViewer() instanceof TableRidgetTableViewer) {
                TableRidgetToolTipSupportFacade.getDefault().enableFor((ColumnViewer)this.getTableViewer());
            }
        }
    }

    @Override
    protected void configureViewer(AbstractTableViewer viewer) {
        if (viewer instanceof TableRidgetTableViewer) {
            ((TableRidgetTableViewer)viewer).setAllowRefresh(false);
        }
        super.configureViewer(viewer);
        if (viewer instanceof TableRidgetTableViewer) {
            ((TableRidgetTableViewer)viewer).setAllowRefresh(true);
        }
        if (this.isCheckBoxInFirstColumn(viewer)) {
            ((CheckboxTableViewer)viewer).setCheckStateProvider((ICheckStateProvider)new TableRidgetCheckStateProvider());
        }
        viewer.refresh();
    }

    @Override
    protected void configureLableProvider(IBaseLabelProvider labelProvider, AbstractTableViewer viewer) {
        super.configureLableProvider(labelProvider, viewer);
        if (labelProvider instanceof TableRidgetLabelProvider) {
            ((TableRidgetLabelProvider)labelProvider).setCheckBoxInFirstColumn(this.isCheckBoxInFirstColumn(viewer));
        }
    }

    public boolean isCheckBoxInFirstColumn(AbstractTableViewer viewer) {
        if (SwtUtilities.isDisposed((Widget)viewer.getControl())) {
            return false;
        }
        if (!(viewer.getControl() instanceof Table)) {
            return false;
        }
        if ((viewer.getControl().getStyle() & 0x20) != 32) {
            return false;
        }
        Table table = (Table)viewer.getControl();
        if (table.getColumnCount() <= 0) {
            LOGGER.log(2, "SWT table with style SWT.CHECK but no columns (column count <= 0)");
            return false;
        }
        if (!(viewer instanceof CheckboxTableViewer)) {
            LOGGER.log(2, "SWT table with style SWT.CHECK but with wrong viewer (not CheckboxTableViewer)");
            return false;
        }
        PropertyDescriptor property = this.getPropertyDescriptor(this.renderingMethods[0]);
        if (property.getPropertyType() != Boolean.TYPE) {
            LOGGER.log(2, "SWT table with style SWT.CHECK but wrong property type at first column (not boolean)");
            return false;
        }
        return true;
    }

    @Override
    protected AbstractTableViewer createTableViewer() {
        return new TableRidgetTableViewer(this);
    }

    @Override
    protected TableWrapper createTableWrapper() {
        Assert.isNotNull((Object)this.getUIControl());
        return new TableWrapper(this.getUIControl());
    }

    @Override
    protected ClickEvent createClickEvent(MouseEvent e) {
        Table table = (Table)e.widget;
        int colIndex = SwtUtilities.findColumn((Table)table, (Point)new Point(e.x, e.y));
        Item item = this.getItem(new Point(0, e.y));
        Object rowData = item != null ? item.getData() : null;
        ClickEvent event = new ClickEvent((IRidget)this, e.button, colIndex, rowData);
        return event;
    }

    private int columnTextWidth(TableColumn control, String str) {
        GC g = new GC((Drawable)control.getParent());
        Font of = g.getFont();
        g.setFont(control.getParent().getFont());
        Point extent = g.stringExtent(str);
        g.setFont(of);
        g.dispose();
        return extent.x + 16;
    }

    private boolean isShowColumnTooltip(TableColumn col, String columnText) {
        if (RAPDetector.isRAPavailable()) {
            return false;
        }
        return col.getWidth() < this.columnTextWidth(col, columnText);
    }

    private final class ColumnSortListener
    extends SelectionAdapter {
        private ColumnSortListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            TableColumn column = (TableColumn)e.widget;
            int columnIndex = column.getParent().indexOf(column);
            int direction = column.getParent().getSortDirection();
            if (columnIndex == TableRidget.this.getSortedColumn()) {
                if (direction == 128) {
                    TableRidget.this.setSortedAscending(false);
                } else if (direction == 1024) {
                    TableRidget.this.setSortedColumn(-1);
                }
            } else if (TableRidget.this.isColumnSortable(columnIndex)) {
                TableRidget.this.setSortedColumn(columnIndex);
                if (direction == 0) {
                    TableRidget.this.setSortedAscending(true);
                }
            }
            column.getParent().showSelection();
        }
    }

    private final class TableItemEraser
    implements Listener {
        private final Color borderColor = LnfManager.getLnf().getColor("errorMarker.borderColor");
        private final int borderThickness = LnfManager.getLnf().getIntegerSetting("rwErrorMarker.borderthickness", Integer.valueOf(1));

        public void handleEvent(Event event) {
            if (this.isHidingWhenDisabled()) {
                this.hideContent(event);
            } else if (TableRidget.this.isErrorMarked(event.item)) {
                this.markRow(event);
            }
        }

        private void hideContent(Event event) {
            event.detail &= 0xFFFFFFEF;
        }

        private boolean isHidingWhenDisabled() {
            return !TableRidget.this.isEnabled() && MarkerSupport.isHideDisabledRidgetContent();
        }

        private void markRow(Event event) {
            GC gc = event.gc;
            Color oldForeground = gc.getForeground();
            gc.setForeground(this.borderColor);
            try {
                int x = 0;
                int y = 0;
                int width = 0;
                int height = 0;
                int colCount = TableRidget.this.getColumnCount();
                if (colCount > 0) {
                    TableItem item = (TableItem)event.item;
                    int i = 0;
                    while (i < colCount) {
                        Rectangle bounds = item.getBounds(i);
                        if (i == 0) {
                            x = bounds.x - 3;
                            y = bounds.y;
                            width += 3;
                        }
                        width += bounds.width;
                        height = Math.max(height, bounds.height);
                        ++i;
                    }
                    width = Math.max(0, width - 1);
                    height = Math.max(0, height - 1);
                } else {
                    width = Math.max(0, event.width - 1);
                    height = Math.max(0, event.height - 1);
                    x = event.x;
                    y = event.y;
                }
                int i = 0;
                while (i < this.borderThickness) {
                    int arc = 3;
                    if (i > 0) {
                        arc = 0;
                    }
                    gc.drawRoundRectangle(x + i, y + i, width - 2 * i, height - 2 * i, arc, arc);
                    ++i;
                }
            }
            finally {
                gc.setForeground(oldForeground);
            }
        }
    }

    private final class TableRidgetCheckStateProvider
    implements ICheckStateProvider {
        private TableRidgetCheckStateProvider() {
        }

        public boolean isGrayed(Object element) {
            return false;
        }

        public boolean isChecked(Object element) {
            if (TableRidget.this.renderingMethods == null || TableRidget.this.renderingMethods.length <= 0) {
                LOGGER.log(2, "No property found for first column!");
                return false;
            }
            String propertyName = TableRidget.this.renderingMethods[0];
            IObservableValue observableValue = PojoObservables.observeValue((Object)element, (String)propertyName);
            Object value = observableValue.getValue();
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            LOGGER.log(2, "Unexpected property type of first column!");
            return false;
        }
    }

    private final class TableTooltipManager
    extends MouseTrackAdapter
    implements MouseMoveListener {
        private String defaultToolTip;

        private TableTooltipManager() {
        }

        public void init(Control table) {
            String tableToolTip = table.getToolTipText();
            this.defaultToolTip = tableToolTip != null ? tableToolTip : "";
        }

        public void mouseMove(MouseEvent event) {
            Control table = (Control)event.widget;
            this.hideToolTip(table);
        }

        public void mouseExit(MouseEvent event) {
            Control table = (Control)event.widget;
            this.resetToolTip(table);
        }

        public void mouseHover(MouseEvent event) {
            String errorToolTip = "";
            String itemToolTip = "";
            Point mousePt = new Point(event.x, event.y);
            TableItem item = this.getItem(mousePt);
            if (item != null) {
                errorToolTip = this.getErrorToolTip((Item)item);
                itemToolTip = this.getItemToolTip(item, mousePt);
            }
            Control table = (Control)event.widget;
            if (!StringUtils.isEmpty((CharSequence)errorToolTip)) {
                table.setToolTipText(errorToolTip);
            } else if (!StringUtils.isEmpty((CharSequence)itemToolTip)) {
                table.setToolTipText(itemToolTip);
            } else {
                this.resetToolTip(table);
            }
        }

        private TableItem getItem(Point point) {
            Table control = TableRidget.this.getUIControl();
            if (control == null) {
                return null;
            }
            return control.getItem(point);
        }

        private String getItemToolTip(TableItem item, Point mousePt) {
            String result = null;
            int column = SwtUtilities.findColumn((Table)item.getParent(), (Point)mousePt);
            if (column != -1) {
                IBaseLabelProvider labelProvider = TableRidget.this.getTableViewer().getLabelProvider();
                if (labelProvider != null) {
                    Object element = item.getData();
                    result = ((TableRidgetLabelProvider)labelProvider).getToolTipText(element, column);
                }
                if (result == null) {
                    result = item.getText(column);
                }
            }
            return result;
        }

        private String getErrorToolTip(Item item) {
            if (item != null) {
                Object data = item.getData();
                Collection<RowErrorMessageMarker> markers = TableRidget.this.getMarkersOfType(RowErrorMessageMarker.class);
                for (RowErrorMessageMarker marker : markers) {
                    if (marker.getRowValue() != data) continue;
                    return marker.getMessage();
                }
            }
            return null;
        }

        private void hideToolTip(Control table) {
            if (!"".equals(table.getToolTipText())) {
                table.setToolTipText("");
            }
        }

        private void resetToolTip(Control table) {
            if (table.getToolTipText() == null || !table.getToolTipText().equals(this.defaultToolTip)) {
                table.setToolTipText(this.defaultToolTip);
            }
        }
    }
}

