/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.singleton;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.eclipse.riena.core.singleton.ISingletonInitializer;
import org.eclipse.riena.core.singleton.SingletonFailure;
import org.eclipse.riena.internal.core.singleton.RAPSingletonProvider;
import org.eclipse.riena.internal.core.singleton.RCPSingletonProvider;

public final class SessionServiceProvider {
    private SessionServiceProvider() {
    }

    public static <S> S createService(Class<? super S> serviceInterfaceType, Class<S> serviceType) {
        return SessionServiceProvider.createService(serviceInterfaceType, serviceType, null);
    }

    public static <S> S createService(Class<? super S> serviceInterfaceType, Class<S> serviceType, ISingletonInitializer<S> initializer) {
        if (RAPSingletonProvider.isAvailable()) {
            return (S)Proxy.newProxyInstance(serviceInterfaceType.getClassLoader(), new Class[]{serviceInterfaceType}, new ServiceInvocationHandler<S>(serviceType, initializer));
        }
        return RCPSingletonProvider.getInstance(serviceType, initializer);
    }

    private static class ServiceInvocationHandler<S>
    implements InvocationHandler {
        private final Class<S> serviceType;
        private final ISingletonInitializer<S> initializer;

        public ServiceInvocationHandler(Class<S> serviceType, ISingletonInitializer<S> initializer) {
            this.serviceType = serviceType;
            this.initializer = initializer;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            S instance = RAPSingletonProvider.getInstance(this.serviceType, this.initializer);
            if (instance != null) {
                try {
                    return method.invoke(instance, args);
                }
                catch (InvocationTargetException e) {
                    throw e.getTargetException();
                }
            }
            throw new SingletonFailure("Could not create a session based RAP instance for type " + this.serviceType);
        }
    }
}

