/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.util;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.core.Log4r;

public class WeakRef<T> {
    private final Reference<T> ref;
    private static final ReferenceQueue<? super Object> REF_QUEUE = new ReferenceQueue();
    private static final Map<Reference<?>, Runnable> REMOVE_ACTIONS = new HashMap();
    private static final Logger LOGGER;

    static {
        new Remover();
        LOGGER = Log4r.getLogger(WeakRef.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WeakRef(T referent, Runnable runnable) {
        this.ref = new WeakReference<Object>(referent, REF_QUEUE);
        Map<Reference<?>, Runnable> map = REMOVE_ACTIONS;
        synchronized (map) {
            REMOVE_ACTIONS.put(this.ref, runnable);
        }
    }

    public T get() {
        return this.ref.get();
    }

    private static class Remover
    extends Job {
        private static final int REMOVE_TIMEOUT = 1;
        private static final String WE_ARE_FAMILY = "org.eclipse.riena.core";

        public Remover() {
            super("WeakRef remover");
            this.setSystem(true);
            this.schedule();
        }

        public boolean belongsTo(Object family) {
            return WE_ARE_FAMILY.equals(family);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected IStatus run(IProgressMonitor monitor) {
            try {
                while (true) {
                    Runnable runnable;
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    Reference removed = REF_QUEUE.remove(1L);
                    if (removed == null) continue;
                    Map map = REMOVE_ACTIONS;
                    synchronized (map) {
                        runnable = (Runnable)REMOVE_ACTIONS.remove(removed);
                    }
                    if (runnable == null) continue;
                    try {
                        runnable.run();
                    }
                    catch (Throwable t) {
                        LOGGER.log(1, "Got exception executing remove notification.", t);
                    }
                }
            }
            catch (InterruptedException e) {
                LOGGER.log(1, "WeakRef remover has been interrupted.", (Throwable)e);
                Thread.currentThread().interrupt();
                return Status.CANCEL_STATUS;
            }
        }
    }
}

