/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.e4.launcher.rendering;

import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.workbench.renderers.swt.ContributedPartRenderer;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.e4.launcher.part.RienaPartHelper;
import org.eclipse.riena.e4.launcher.part.ViewInstanceProvider;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.listener.INavigationNodeListener;
import org.eclipse.riena.navigation.listener.SubModuleNodeListener;
import org.eclipse.riena.navigation.ui.swt.presentation.SwtViewProvider;
import org.eclipse.riena.navigation.ui.swt.views.SubModuleView;
import org.eclipse.swt.widgets.Composite;

public final class RienaPartRenderer
extends ContributedPartRenderer {
    public Object createWidget(MUIElement element, Object parent) {
        String[] rienaCompoundId = RienaPartHelper.extractRienaCompoundId(element);
        if (this.isSubModuleNodePart(rienaCompoundId)) {
            Composite parentComposite = null;
            String typeId = rienaCompoundId[0];
            String secondayId = rienaCompoundId[1];
            ISubModuleNode node = (ISubModuleNode)SwtViewProvider.getInstance().getNavigationNode(typeId, secondayId, ISubModuleNode.class);
            if (RienaPartHelper.isSharedView(node) && (parentComposite = ViewInstanceProvider.getInstance().getParentComposite(typeId)) != null && element.getWidget() == null) {
                element.setWidget((Object)parentComposite);
                ViewInstanceProvider.getInstance().increaseViewCounter(typeId);
            }
            if (parentComposite == null) {
                parentComposite = (Composite)super.createWidget(element, parent);
                this.initializeView(typeId, parentComposite, node);
            } else {
                this.updateViewNode(typeId, node);
            }
            if (RienaPartHelper.isSharedView(node)) {
                node.addListener((INavigationNodeListener)new SharedViewNodeBinder(typeId));
            }
            return parentComposite;
        }
        return super.createWidget(element, parent);
    }

    private boolean isSubModuleNodePart(String[] rienaCompoundId) {
        return rienaCompoundId.length > 1;
    }

    private void updateViewNode(String typeId, ISubModuleNode node) {
        SubModuleView viewInstance = ViewInstanceProvider.getInstance().getView(typeId);
        viewInstance.setNavigationNode(node);
    }

    private void initializeView(String typeId, Composite parentComposite, ISubModuleNode node) {
        ViewInstanceProvider viewInstanceProvider = ViewInstanceProvider.getInstance();
        SubModuleView viewInstance = viewInstanceProvider.getView(typeId);
        viewInstance.setE4Runtime(true);
        viewInstanceProvider.registerParentComposite(typeId, parentComposite);
        this.updateViewNode(typeId, node);
        ReflectionUtils.invokeHidden((Object)viewInstance, (String)"setShellProvider", (Object[])new Object[]{RienaPartHelper.toShellProvider(parentComposite.getShell())});
        viewInstance.createPartControl(parentComposite);
    }

    private final class SharedViewNodeBinder
    extends SubModuleNodeListener {
        private final String typeId;

        private SharedViewNodeBinder(String typeId) {
            this.typeId = typeId;
        }

        public void activated(ISubModuleNode source) {
            SubModuleView viewInstance = ViewInstanceProvider.getInstance().getView(this.typeId);
            viewInstance.setNavigationNode(source);
            viewInstance.bind(source);
        }
    }
}

