/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.example.client.controllers;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.riena.beans.common.TypedComparator;
import org.eclipse.riena.internal.example.client.beans.Car;
import org.eclipse.riena.navigation.ui.controllers.SubModuleController;
import org.eclipse.riena.ui.ridgets.IColumnFormatter;
import org.eclipse.riena.ui.ridgets.ITableRidget;
import org.eclipse.riena.ui.ridgets.listener.ISelectionListener;
import org.eclipse.riena.ui.ridgets.listener.SelectionEvent;
import org.eclipse.riena.ui.ridgets.swt.NumberColumnFormatter;

public class CarCatalogSubModuleController
extends SubModuleController {
    public void configureRidgets() {
        super.configureRidgets();
        ITableRidget table = (ITableRidget)this.getRidget(ITableRidget.class, "table");
        String[] columnPropertyNames = new String[]{"make", "model", "power", "capacity", "speedup", "milage"};
        String[] columnHeaders = new String[]{"Make", "Model", "Power (KW)", "Capacity", "Speedup", "Milage"};
        List<Car> input = this.createInput();
        table.setNativeToolTip(false);
        table.bindToModel((IObservableList)new WritableList(input, Car.class), Car.class, columnPropertyNames, columnHeaders);
        table.updateFromModel();
        table.setComparator(0, (Comparator)new TypedComparator());
        table.setComparator(2, (Comparator)new TypedComparator());
        table.setComparator(3, (Comparator)new TypedComparator());
        table.setComparator(4, (Comparator)new TypedComparator());
        table.setComparator(5, (Comparator)new TypedComparator());
        table.setColumnEditable(1, true);
        table.setColumnEditable(2, true);
        table.setColumnEditable(3, true);
        table.setColumnEditable(4, true);
        table.setColumnEditable(5, true);
        table.setColumnFormatter(3, (IColumnFormatter)new NumberColumnFormatter(Integer.class, 0){

            protected Number getValue(Object element) {
                return ((Car)element).getCapacity();
            }

            public String getToolTip(Object element) {
                return String.valueOf(this.getText(element)) + " ccm";
            }
        });
        table.setColumnFormatter(4, (IColumnFormatter)new NumberColumnFormatter(Float.class, 2){

            protected Number getValue(Object element) {
                return Float.valueOf(((Car)element).getSpeedup());
            }

            public String getToolTip(Object element) {
                return String.valueOf(this.getText(element)) + " (0-100 km/h)";
            }
        });
        table.setColumnFormatter(5, (IColumnFormatter)new NumberColumnFormatter(Float.class, 2){

            protected Number getValue(Object element) {
                return Float.valueOf(((Car)element).getMilage());
            }

            public String getToolTip(Object element) {
                return String.valueOf(this.getText(element)) + " (l/100 km)";
            }
        });
        table.addSelectionListener(new ISelectionListener(){

            public void ridgetSelected(SelectionEvent event) {
                if (event.getNewSelection() != null) {
                    System.out.println(event.getNewSelection());
                } else {
                    System.out.println("no selection");
                }
            }
        });
    }

    private List<Car> createInput() {
        ArrayList<Car> cars = new ArrayList<Car>();
        cars.add(new Car("Audi", "A1 1.2 TFSI", 63, 1197, 11.7f, 5.1f));
        cars.add(new Car("BMW", "116i", 90, 1995, 9.8f, 6.1f));
        cars.add(new Car("Jeep", "Grand Cherokee 3.0 V6", 177, 2987, 8.2f, 8.3f));
        cars.add(new Car("Peugeot", "207 75", 54, 1360, 14.4f, 6.3f));
        cars.add(new Car("Cadillac", "Escalade 6.2 V8", 301, 6162, 6.7f, 14.5f));
        cars.add(new Car("Mini", "Cooper", 90, 1598, 9.1f, 5.4f));
        cars.add(new Car("Volvo", "V70 T4", 132, 1596, 8.7f, 6.8f));
        cars.add(new Car("Toyota", "Prius 1.8 Hybrid", 100, 1798, 10.4f, 3.9f));
        cars.add(new Car("Peugeot", "205", 44, 0, 0.0f, 0.0f));
        cars.add(new Car("Toyota", "Corolla 1,3 LXi", 55, 0, 0.0f, 0.0f));
        cars.add(new Car("Opel", "Kadett E Caravan GL", 44, 1389, 0.0f, 0.0f));
        return cars;
    }
}

