/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.views;

import java.util.List;
import org.eclipse.riena.internal.ui.swt.MouseWheelAdapter;
import org.eclipse.riena.navigation.IModuleGroupNode;
import org.eclipse.riena.navigation.IModuleNode;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.ui.swt.views.IModuleNavigationComponentProvider;
import org.eclipse.riena.navigation.ui.swt.views.ModuleView;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

public abstract class AbstractScrollingSupport {
    @Deprecated
    protected static final int SCROLLING_STEP = 20;
    protected final IModuleNavigationComponentProvider navigationComponentProvider;

    public AbstractScrollingSupport(IModuleNavigationComponentProvider navigationComponentProvider) {
        this.navigationComponentProvider = navigationComponentProvider;
        this.initMouseWheelObserver(this.getNavigationComponent());
    }

    public abstract void scroll();

    protected abstract boolean scrollTo(Composite var1, Composite var2);

    protected abstract boolean scrollTo(Tree var1);

    protected abstract void scrollUp(int var1);

    protected abstract void scrollDown(int var1);

    protected boolean scrollTo(IModuleNode module) {
        boolean result = false;
        if (module != null) {
            boolean isClosed;
            ModuleView moduleView = this.navigationComponentProvider.getModuleViewForNode(module);
            if (moduleView == null) {
                return result;
            }
            boolean bl = isClosed = moduleView.getOpenHeight() == 0;
            if (isClosed) {
                result = this.scrollTo((Composite)moduleView.getTitle(), moduleView.getBody());
            } else {
                int moduleHeight = moduleView.getParent().getSize().y;
                if (moduleHeight < this.getNavigationComponentHeight()) {
                    result = this.scrollTo((Composite)moduleView.getTitle(), moduleView.getBody());
                }
                result = result || this.scrollTo(moduleView.getTree());
            }
        }
        return result;
    }

    protected INavigationNode<?> getActiveNode() {
        IModuleGroupNode group = this.navigationComponentProvider.getActiveModuleGroupNode();
        IModuleNode module = null;
        ISubModuleNode submodule = null;
        if (group != null) {
            for (IModuleNode candidate : group.getChildren()) {
                if (!candidate.isActivated()) continue;
                module = candidate;
                break;
            }
        }
        if (module != null) {
            submodule = this.getActiveSubModuleNode(module.getChildren());
        }
        return submodule != null ? submodule : (module != null ? module : group);
    }

    protected ISubModuleNode getActiveSubModuleNode(List<ISubModuleNode> nodes) {
        ISubModuleNode result = null;
        for (ISubModuleNode candidate : nodes) {
            if (!candidate.isActivated()) continue;
            ISubModuleNode activeChild = this.getActiveSubModuleNode(candidate.getChildren());
            result = activeChild != null ? activeChild : candidate;
            break;
        }
        return result;
    }

    protected int getScrolledComponentHeight() {
        return this.getScrolledComponent().getBounds().height;
    }

    protected Composite getScrolledComponent() {
        return this.navigationComponentProvider.getScrolledComponent();
    }

    protected int getNavigationComponentHeight() {
        return this.getNavigationComponent().getBounds().height;
    }

    protected Composite getNavigationComponent() {
        return this.navigationComponentProvider.getNavigationComponent();
    }

    protected boolean mayScroll() {
        int navigationComponentHeight = this.getNavigationComponentHeight();
        return this.getScrolledComponentHeight() > navigationComponentHeight && navigationComponentHeight > 0;
    }

    private void initMouseWheelObserver(Composite control) {
        if (SwtUtilities.isDisposed((Widget)control)) {
            return;
        }
        new MouseWheelAdapter((Control)control, new MouseWheelAdapter.Scroller(){

            public boolean mayScroll() {
                return AbstractScrollingSupport.this.mayScroll();
            }

            public void scrollUp(int scrollingStep) {
                AbstractScrollingSupport.this.scrollUp(scrollingStep);
            }

            public void scrollDown(int scrollingStep) {
                AbstractScrollingSupport.this.scrollDown(scrollingStep);
            }
        });
    }
}

