/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.controllers;

import org.eclipse.riena.navigation.IApplicationNode;
import org.eclipse.riena.navigation.listener.ApplicationNodeListener;
import org.eclipse.riena.navigation.listener.INavigationNodeListener;
import org.eclipse.riena.navigation.ui.controllers.NavigationNodeController;
import org.eclipse.riena.navigation.ui.controllers.NodeEventDelegation;
import org.eclipse.riena.ui.ridgets.IInfoFlyoutRidget;
import org.eclipse.riena.ui.ridgets.IStatuslineRidget;
import org.eclipse.riena.ui.ridgets.IVisualContextManager;
import org.eclipse.riena.ui.ridgets.IWindowRidget;
import org.eclipse.riena.ui.ridgets.listener.IWindowRidgetListener;

public class ApplicationController
extends NavigationNodeController<IApplicationNode> {
    private IWindowRidget applicationWindow;
    private IWindowRidgetListener windowRidgetListener;
    private IStatuslineRidget statuslineRidget;
    private IInfoFlyoutRidget infoFlyout;
    private boolean menuBarVisible;
    private boolean done = false;
    private final NodeEventDelegation contextUpdater = new NodeEventDelegation();

    public ApplicationController(IApplicationNode applicationNode) {
        super(applicationNode);
        applicationNode.addListener((INavigationNodeListener)new ApplicationNodeListener(){

            public void labelChanged(IApplicationNode source) {
                ApplicationController.this.updateLabel();
            }

            public void iconChanged(IApplicationNode source) {
                ApplicationController.this.updateIcon();
            }
        });
    }

    public IStatuslineRidget getStatusline() {
        if (!this.done && this.statuslineRidget != null) {
            if (this.statuslineRidget.getStatuslineUIProcessRidget() != null) {
                this.statuslineRidget.getStatuslineUIProcessRidget().setContextLocator((IVisualContextManager)this.contextUpdater);
            }
            this.done = true;
        }
        return this.statuslineRidget;
    }

    public void setStatusline(IStatuslineRidget statuslineRidget) {
        this.statuslineRidget = statuslineRidget;
    }

    public void setApplicationWindow(IWindowRidget pWindowRidget) {
        if (this.windowRidgetListener == null) {
            this.windowRidgetListener = new FrameListener();
        }
        this.applicationWindow = pWindowRidget;
        if (this.applicationWindow != null && this.windowRidgetListener != null) {
            this.applicationWindow.addWindowRidgetListener(this.windowRidgetListener);
        }
    }

    public void setVisible(boolean pVisible) {
        if (this.applicationWindow != null) {
            this.applicationWindow.setVisible(pVisible);
        }
    }

    public IWindowRidget getApplicationWindow() {
        return this.applicationWindow;
    }

    public void configureRidgets() {
    }

    @Override
    public void afterBind() {
        super.afterBind();
        this.updateLabel();
        this.updateIcon();
    }

    private void updateLabel() {
        this.applicationWindow.setTitle(((IApplicationNode)this.getNavigationNode()).getLabel());
    }

    private void updateIcon() {
        this.updateIcon(this.applicationWindow);
    }

    public void setMenubarVisible(boolean visible) {
        this.menuBarVisible = visible;
    }

    public boolean isMenubarVisible() {
        return this.menuBarVisible;
    }

    public void setInfoFlyout(IInfoFlyoutRidget infoFlyout) {
        this.infoFlyout = infoFlyout;
    }

    public IInfoFlyoutRidget getInfoFlyout() {
        return this.infoFlyout;
    }

    private static class FrameListener
    implements IWindowRidgetListener {
        private FrameListener() {
        }

        public void closed() {
        }

        public void activated() {
        }
    }
}

