/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.controllers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.riena.internal.navigation.ui.filter.AbstractUIFilterRuleMenuItemMarker;
import org.eclipse.riena.navigation.IApplicationNode;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.INavigationNodeController;
import org.eclipse.riena.navigation.ISubApplicationNode;
import org.eclipse.riena.navigation.listener.NavigationNodeListener;
import org.eclipse.riena.navigation.ui.controllers.IUIFilterRuleClosure;
import org.eclipse.riena.ui.filter.IUIFilter;
import org.eclipse.riena.ui.filter.IUIFilterRule;
import org.eclipse.riena.ui.ridgets.IComplexRidget;
import org.eclipse.riena.ui.ridgets.IMenuItemRidget;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.IRidgetContainer;
import org.eclipse.riena.ui.ridgets.IToolItemRidget;

public class NavigationUIFilterApplier<N>
extends NavigationNodeListener {
    private static final IUIFilterRuleClosure APPLY_CLOSURE = new ApplyClosure();
    private static final IUIFilterRuleClosure REMOVE_CLOSURE = new RemoveClosure();

    private void applyFilters(INavigationNode<?> node) {
        if (node == null) {
            return;
        }
        ArrayList<IUIFilter> filters = new ArrayList<IUIFilter>();
        this.collectFilters(node, filters);
        for (IUIFilter filter : filters) {
            this.applyFilter(node, filter, APPLY_CLOSURE);
        }
        ISubApplicationNode subAppNode = (ISubApplicationNode)node.getParentOfType(ISubApplicationNode.class);
        if (subAppNode != null && subAppNode != node) {
            for (IUIFilter filter : filters) {
                this.applyFilter((INavigationNode<?>)subAppNode, filter, APPLY_CLOSURE);
            }
        }
    }

    private void removeAllMenuItemRules(INavigationNode<?> node) {
        if (node == null) {
            return;
        }
        for (IUIFilter filter : node.getFilters()) {
            for (IUIFilterRule rule : filter.getFilterRules()) {
                if (!(rule instanceof AbstractUIFilterRuleMenuItemMarker)) continue;
                this.applyFilterRule(node, rule, REMOVE_CLOSURE);
            }
        }
        List children = node.getChildren();
        for (Object child : children) {
            if (!(child instanceof INavigationNode)) continue;
            this.removeAllMenuItemRules((INavigationNode)child);
        }
    }

    private void collectFilters(INavigationNode<?> node, Collection<IUIFilter> filters) {
        if (node == null) {
            return;
        }
        if (node.getFilters() != null) {
            filters.addAll(node.getFilters());
        }
        this.collectFilters(node.getParent(), filters);
    }

    private void applyFilter(INavigationNode<?> node, IUIFilter filter, IUIFilterRuleClosure closure) {
        Collection rules = filter.getFilterRules();
        for (IUIFilterRule rule : rules) {
            this.applyFilterRule(node, rule, closure);
        }
        List children = node.getChildren();
        for (Object child : children) {
            if (!(child instanceof INavigationNode)) continue;
            this.applyFilter((INavigationNode)child, filter, closure);
        }
    }

    private void applyFilterRule(INavigationNode<?> node, IUIFilterRule filterRule, IUIFilterRuleClosure closure) {
        INavigationNodeController controller;
        if (filterRule.matches(new Object[]{node})) {
            closure.execute(node, filterRule, node);
        }
        if ((controller = node.getNavigationNodeController()) instanceof IRidgetContainer) {
            IRidgetContainer container = (IRidgetContainer)controller;
            this.executeFilter(node, filterRule, closure, container.getRidgets());
        }
    }

    private void executeFilter(INavigationNode<?> node, IUIFilterRule filterRule, IUIFilterRuleClosure closure, Collection<? extends IRidget> ridgets) {
        for (IRidget iRidget : ridgets) {
            if (iRidget instanceof IComplexRidget) {
                this.executeFilter(node, filterRule, closure, ((IComplexRidget)iRidget).getRidgets());
            }
            if (!filterRule.matches(new Object[]{iRidget, node})) continue;
            closure.execute(node, filterRule, iRidget);
        }
    }

    public void afterActivated(INavigationNode source) {
        super.afterActivated(source);
        this.applyFilters(source);
    }

    public void beforeDeactivated(INavigationNode source) {
        super.beforeDeactivated(source);
        IApplicationNode appNode = (IApplicationNode)source.getParentOfType(IApplicationNode.class);
        this.removeAllMenuItemRules((INavigationNode<?>)appNode);
    }

    public void filterAdded(INavigationNode source, IUIFilter filter) {
        super.filterAdded(source, filter);
        this.applyFilter(source, filter, APPLY_CLOSURE);
    }

    public void filterRemoved(INavigationNode source, IUIFilter filter) {
        super.filterRemoved(source, filter);
        this.applyFilter(source, filter, REMOVE_CLOSURE);
    }

    private static boolean isMenuItemOfDeactivatedNode(INavigationNode<?> node, IRidget ridget) {
        if (!(node instanceof IApplicationNode) && (ridget instanceof IToolItemRidget || ridget instanceof IMenuItemRidget)) {
            return node.isDeactivated();
        }
        return false;
    }

    private static class ApplyClosure
    implements IUIFilterRuleClosure {
        private ApplyClosure() {
        }

        @Override
        public void execute(INavigationNode<?> node, IUIFilterRule attr, Object obj) {
            if (obj instanceof IRidget && NavigationUIFilterApplier.isMenuItemOfDeactivatedNode(node, (IRidget)obj)) {
                return;
            }
            attr.apply(obj);
        }
    }

    private static class RemoveClosure
    implements IUIFilterRuleClosure {
        private RemoveClosure() {
        }

        @Override
        public void execute(INavigationNode<?> node, IUIFilterRule attr, Object obj) {
            if (obj instanceof IRidget && NavigationUIFilterApplier.isMenuItemOfDeactivatedNode(node, (IRidget)obj)) {
                return;
            }
            attr.remove(obj);
        }
    }
}

