/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.controllers;

import java.util.Collection;
import org.eclipse.core.databinding.BindingException;
import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.core.IRienaActivator;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.core.util.RienaConfiguration;
import org.eclipse.riena.internal.ui.ridgets.Activator;
import org.eclipse.riena.navigation.ApplicationNodeManager;
import org.eclipse.riena.navigation.IApplicationNode;
import org.eclipse.riena.navigation.IHierarchyChangeListener;
import org.eclipse.riena.navigation.IModuleNode;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.listener.INavigationNodeListener;
import org.eclipse.riena.navigation.listener.SubModuleNodeListener;
import org.eclipse.riena.navigation.model.SubModuleNode;
import org.eclipse.riena.navigation.ui.controllers.ApplicationController;
import org.eclipse.riena.navigation.ui.controllers.ModuleController;
import org.eclipse.riena.navigation.ui.controllers.NavigationNodeController;
import org.eclipse.riena.ui.ridgets.AbstractRidget;
import org.eclipse.riena.ui.ridgets.IActionRidget;
import org.eclipse.riena.ui.ridgets.IComplexRidget;
import org.eclipse.riena.ui.ridgets.IDefaultActionManager;
import org.eclipse.riena.ui.ridgets.IEmbeddedTitleBarRidget;
import org.eclipse.riena.ui.ridgets.IInfoFlyoutRidget;
import org.eclipse.riena.ui.ridgets.IMarkableRidget;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.IStatuslineRidget;
import org.eclipse.riena.ui.ridgets.IWindowRidget;
import org.eclipse.riena.ui.ridgets.listener.IWindowRidgetListener;

public class SubModuleController
extends NavigationNodeController<ISubModuleNode> {
    private static final Logger LOGGER = Log4r.getLogger((IRienaActivator)Activator.getDefault(), SubModuleController.class);
    public static final String WINDOW_RIDGET = "windowRidget";
    private static final String TITLE_SEPARATOR = " - ";
    private IDefaultActionManager actionManager;
    private IRidget initialFocus;
    private final WindowListener windowListener = new WindowListener();
    protected boolean titleInvalid;

    public SubModuleController() {
        this(null);
    }

    public SubModuleController(ISubModuleNode navigationNode) {
        super(navigationNode);
    }

    public void addDefaultAction(IRidget focusRidget, IActionRidget action) {
        this.actionManager = this.getWindowRidget().addDefaultAction(focusRidget, action);
        if (this.actionManager != null && this.getWindowRidget().getUIControl() != null) {
            this.actionManager.deactivate();
            this.actionManager.activate();
        }
    }

    @Override
    public void afterBind() {
        super.afterBind();
        this.updateIcon();
        this.updateWindowTitle();
        this.updateCloseable();
        this.updateActive();
        if (this.getWindowRidget() != null) {
            this.getWindowRidget().addWindowRidgetListener((IWindowRidgetListener)this.windowListener);
        }
        this.initializeStatuslineMessageViewer();
    }

    private void initializeStatuslineMessageViewer() {
        if (this.shouldEnableStatuslineMessageViewer()) {
            this.setStatuslineToShowMarkerMessages(this.getStatusline());
        } else {
            this.setStatuslineToShowMarkerMessages(null);
        }
    }

    protected boolean shouldEnableStatuslineMessageViewer() {
        String value = RienaConfiguration.getInstance().getProperty("riena.showRidgetMessagesInStatusline");
        return Boolean.parseBoolean(value);
    }

    public void configureRidgets() {
    }

    public IRidget getInitialFocus() {
        return this.initialFocus;
    }

    public IRidget getFocusableRidget() {
        if (this.getInitialFocus() != null) {
            return this.getInitialFocus();
        }
        for (IRidget ridget : this.getRidgets()) {
            boolean markable = ridget instanceof IMarkableRidget;
            if (!ridget.isFocusable() || !ridget.isEnabled() || !ridget.isVisible() || markable && (!markable || ((IMarkableRidget)ridget).isOutputOnly())) continue;
            return ridget;
        }
        return null;
    }

    public ModuleController getModuleController() {
        IModuleNode moduleNode = (IModuleNode)((ISubModuleNode)this.getNavigationNode()).getParentOfType(IModuleNode.class);
        if (moduleNode != null) {
            return (ModuleController)moduleNode.getNavigationNodeController();
        }
        return null;
    }

    public IWindowRidget getWindowRidget() {
        return (IWindowRidget)this.getRidget(IEmbeddedTitleBarRidget.class, WINDOW_RIDGET);
    }

    public IInfoFlyoutRidget getInfoFlyout() {
        ApplicationController appController = (ApplicationController)ApplicationNodeManager.getApplicationNode().getNavigationNodeController();
        return appController.getInfoFlyout();
    }

    public void setInitialFocus(IRidget ridget) {
        this.initialFocus = ridget;
    }

    @Override
    public void setBlocked(boolean blocked) {
        super.setBlocked(blocked);
        this.restoreFocusRequestFromRidget(this.getRidgets());
    }

    public void restoreFocusRequestFromRidget(Collection<? extends IRidget> collection) {
        for (IRidget iRidget : collection) {
            if (iRidget instanceof IComplexRidget) {
                this.restoreFocusRequestFromRidget(((IComplexRidget)iRidget).getRidgets());
                continue;
            }
            if (!(iRidget instanceof AbstractRidget) || !((AbstractRidget)iRidget).isRetryRequestFocus()) continue;
            if (!((ISubModuleNode)this.getNavigationNode()).isBlocked()) {
                iRidget.requestFocus();
            }
            ((AbstractRidget)iRidget).setRetryRequestFocus(false);
        }
    }

    @Override
    public void setNavigationNode(ISubModuleNode navigationNode) {
        super.setNavigationNode(navigationNode);
        ((ISubModuleNode)this.getNavigationNode()).addListener((INavigationNodeListener)new SubModuleNodeListener(){

            public void iconChanged(ISubModuleNode source) {
                SubModuleController.this.updateIcon();
            }

            public void labelChanged(ISubModuleNode subModuleNode) {
                SubModuleController.this.updateWindowTitle();
            }

            public void afterActivated(ISubModuleNode source) {
                if (SubModuleController.this.titleInvalid) {
                    SubModuleController.this.updateWindowTitle();
                }
                if (SubModuleController.this.actionManager != null) {
                    SubModuleController.this.actionManager.activate();
                }
            }

            public void afterDeactivated(ISubModuleNode source) {
                if (SubModuleController.this.actionManager != null) {
                    SubModuleController.this.actionManager.deactivate();
                }
            }

            public void beforeDisposed(ISubModuleNode source) {
                if (SubModuleController.this.actionManager != null) {
                    SubModuleController.this.actionManager.dispose();
                    SubModuleController.this.actionManager = null;
                }
            }
        });
        if (navigationNode instanceof SubModuleNode) {
            ((SubModuleNode)navigationNode).addHierarchyChangeListener(new IHierarchyChangeListener(){

                public void labelChanged(INavigationNode<?> node) {
                    if (SubModuleController.this.isActivated()) {
                        SubModuleController.this.updateWindowTitle();
                    } else {
                        SubModuleController.this.titleInvalid = true;
                    }
                }
            });
        }
    }

    public void setWindowRidget(IWindowRidget windowRidget) {
        if (this.getWindowRidget() != windowRidget) {
            this.addRidget(WINDOW_RIDGET, (IRidget)windowRidget);
        }
    }

    public void updateAllRidgetsFromModel() {
        for (IRidget ridget : this.getRidgets()) {
            if (ridget.isIgnoreBindingError()) {
                try {
                    ridget.updateFromModel();
                }
                catch (BindingException bindingException) {
                    String message = "Update from the model was unsuccessful for the ridget: ";
                    message = String.valueOf(message) + ridget + ", with id: " + ridget.getID();
                    LOGGER.log(4, message);
                }
                continue;
            }
            ridget.updateFromModel();
        }
    }

    protected String getFullTitle() {
        String title = ((ISubModuleNode)this.getNavigationNode()).getLabel();
        if (this.isInvisibleInTree()) {
            IModuleNode moduleNode = (IModuleNode)this.getModuleController().getNavigationNode();
            title = moduleNode.getLabel();
        } else {
            INavigationNode parent = ((ISubModuleNode)this.getNavigationNode()).getParent();
            if (parent != null) {
                while (parent != null && !(parent instanceof IModuleNode)) {
                    title = String.valueOf(parent.getLabel()) + TITLE_SEPARATOR + title;
                    parent = parent.getParent();
                }
                title = String.valueOf(parent.getLabel()) + TITLE_SEPARATOR + title;
            }
        }
        return title;
    }

    protected void layout() {
        IWindowRidget ridget = (IWindowRidget)this.getRidget(IEmbeddedTitleBarRidget.class, WINDOW_RIDGET);
        ridget.layout();
    }

    @Override
    protected void updateIcon(IWindowRidget windowRidget) {
        if (this.isInvisibleInTree()) {
            if (windowRidget == null) {
                return;
            }
            IModuleNode moduleNode = (IModuleNode)this.getModuleController().getNavigationNode();
            String nodeIcon = moduleNode.getIcon();
            windowRidget.setIcon(nodeIcon);
        } else {
            super.updateIcon(windowRidget);
        }
    }

    protected IStatuslineRidget getStatusline() {
        ApplicationController applicationController = this.getApplicationController();
        if (applicationController == null) {
            return null;
        }
        return applicationController.getStatusline();
    }

    private ApplicationController getApplicationController() {
        IApplicationNode application = (IApplicationNode)((ISubModuleNode)this.getNavigationNode()).getParentOfType(IApplicationNode.class);
        if (application == null) {
            return null;
        }
        return (ApplicationController)application.getNavigationNodeController();
    }

    private boolean isInvisibleInTree() {
        if (this.getModuleController() != null && this.getModuleController().hasSingleLeafChild()) {
            return !((IModuleNode)this.getModuleController().getNavigationNode()).isPresentSingleSubModule();
        }
        return false;
    }

    private void updateActive() {
        IWindowRidget windowRidget = this.getWindowRidget();
        if (windowRidget != null) {
            windowRidget.setActive(((ISubModuleNode)this.getNavigationNode()).isActivated());
        }
    }

    private void updateCloseable() {
        IWindowRidget windowRidget = this.getWindowRidget();
        if (windowRidget != null) {
            windowRidget.setCloseable(((ISubModuleNode)this.getNavigationNode()).isClosable());
        }
    }

    private void updateIcon() {
        this.updateIcon(this.getWindowRidget());
    }

    void updateWindowTitle() {
        ISubModuleNode subModule;
        IWindowRidget windowRidget = this.getWindowRidget();
        if (windowRidget != null) {
            windowRidget.setTitle(this.getFullTitle());
        }
        if (!((ISubModuleNode)this.getNavigationNode()).isActivated() && (subModule = ApplicationNodeManager.locateActiveSubModuleNode()) != null && subModule.getNavigationNodeController() instanceof SubModuleController) {
            ((SubModuleController)subModule.getNavigationNodeController()).updateWindowTitle();
        }
        this.titleInvalid = false;
    }

    private class WindowListener
    implements IWindowRidgetListener {
        private WindowListener() {
        }

        public void closed() {
            ((ISubModuleNode)SubModuleController.this.getNavigationNode()).dispose();
        }

        public void activated() {
        }
    }
}

