/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.model;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.riena.navigation.IHierarchyChangeListener;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.NavigationNodeId;
import org.eclipse.riena.navigation.listener.ISubModuleNodeListener;
import org.eclipse.riena.navigation.model.NavigationNode;

public class SubModuleNode
extends NavigationNode<ISubModuleNode, ISubModuleNode, ISubModuleNodeListener>
implements ISubModuleNode {
    private boolean selectable = true;
    private boolean closeSubTree = false;
    private boolean closable = false;
    private final List<IHierarchyChangeListener> hierarchyListeners = new LinkedList<IHierarchyChangeListener>();

    public SubModuleNode() {
        super(null);
    }

    @Override
    public Class<ISubModuleNode> getValidChildType() {
        return ISubModuleNode.class;
    }

    public SubModuleNode(NavigationNodeId nodeId) {
        super(nodeId);
    }

    public SubModuleNode(NavigationNodeId nodeId, String label) {
        super(nodeId, label);
    }

    public SubModuleNode(String label) {
        this(null, label);
    }

    @Override
    public boolean isSelectable() {
        return this.selectable;
    }

    @Override
    public void setSelectable(boolean folderNode) {
        this.selectable = folderNode;
    }

    @Override
    public boolean isCloseSubTree() {
        return this.closeSubTree;
    }

    @Override
    public void setCloseSubTree(boolean close) {
        this.closeSubTree = close;
    }

    @Override
    public boolean isClosable() {
        return this.closable;
    }

    @Override
    public void setClosable(boolean closeable) {
        this.closable = closeable;
    }

    @Override
    public void setLabel(String label) {
        super.setLabel(label);
        this.fireHierarchyLabelChange();
    }

    public void addHierarchyChangeListener(IHierarchyChangeListener hierarchyListener) {
        this.hierarchyListeners.add(hierarchyListener);
    }

    public void removeHierarchyChangeListener(IHierarchyChangeListener hierarchyListener) {
        this.hierarchyListeners.remove(hierarchyListener);
    }

    void notifyHierarchyLabelChangeListeners(INavigationNode<?> changedNode) {
        for (IHierarchyChangeListener l : new LinkedList<IHierarchyChangeListener>(this.hierarchyListeners)) {
            l.labelChanged(changedNode);
        }
        for (ISubModuleNode child : new LinkedList(this.getChildren())) {
            if (!(child instanceof SubModuleNode)) continue;
            ((SubModuleNode)child).notifyHierarchyLabelChangeListeners(this);
        }
    }

    private void fireHierarchyLabelChange() {
        for (ISubModuleNode child : new LinkedList(this.getChildren())) {
            if (!(child instanceof SubModuleNode)) continue;
            ((SubModuleNode)child).notifyHierarchyLabelChangeListeners(this);
        }
    }
}

