/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.util;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.riena.core.test.RienaTestCase;
import org.eclipse.riena.core.test.collect.NonUITestCase;
import org.eclipse.riena.core.util.VariableManagerUtil;

@NonUITestCase
public class FunctionResolverTest
extends RienaTestCase {
    public void testResolveNoFunction() throws CoreException, IOException {
        try {
            VariableManagerUtil.substitute((String)"${fn:}");
            FunctionResolverTest.fail();
        }
        catch (CoreException coreException) {
            this.ok();
        }
    }

    public void testResolveUnknownFunction() throws CoreException, IOException {
        try {
            VariableManagerUtil.substitute((String)"${fn:LetsHaveFun,vale}");
            FunctionResolverTest.fail();
        }
        catch (CoreException coreException) {
            this.ok();
        }
    }

    public void testResolveToFile() throws CoreException, IOException {
        String property = System.getProperty("osgi.instance.area");
        URL url = new URL(property);
        String expected = new File(url.getPath()).getCanonicalPath().replace('\\', '/');
        FunctionResolverTest.assertEquals((String)expected, (String)VariableManagerUtil.substitute((String)"${fn:toFile,${java.system.property:osgi.instance.area}}"));
    }

    public void testResolveUNCToFile() throws CoreException, IOException {
        System.setProperty("uncFileName", "file://RUV/PGL/ZI/SE/PUMA");
        FunctionResolverTest.assertEquals((String)"//RUV/PGL/ZI/SE/PUMA", (String)VariableManagerUtil.substitute((String)"${fn:toFile,${java.system.property:uncFileName}}"));
    }
}

