/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import junit.framework.TestCase;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckable;
import org.eclipse.riena.beans.common.Person;
import org.eclipse.riena.beans.common.PersonManager;
import org.eclipse.riena.core.test.collect.NonUITestCase;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.ui.ridgets.swt.TableRidget;
import org.eclipse.riena.internal.ui.ridgets.swt.TableRidgetTableViewer;
import org.eclipse.riena.ui.tests.base.TestMultiSelectionBean;
import org.eclipse.riena.ui.tests.base.TestSingleSelectionBean;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

@NonUITestCase
public class TableRidgetTableViewerTest
extends TestCase {
    protected PersonManager manager;
    protected Person person1;
    protected Person person2;
    protected Person person3;
    protected TestSingleSelectionBean singleSelectionBean;
    protected TestMultiSelectionBean multiSelectionBean;
    private TableRidget ridget;
    private Shell shell;
    private Table table;

    public void setUp() throws Exception {
        super.setUp();
        Display display = Display.getDefault();
        Realm realm = SWTObservables.getRealm((Display)display);
        TableRidgetTableViewerTest.assertNotNull((Object)realm);
        ReflectionUtils.invokeHidden((Object)realm, (String)"setDefault", (Object[])new Object[]{realm});
        this.shell = new Shell(147456);
        this.table = new Table((Composite)this.shell, 0);
        this.ridget = new TableRidget();
        this.ridget.setUIControl((Object)this.table);
        this.manager = new PersonManager(this.createPersonList());
        Iterator it = this.manager.getPersons().iterator();
        this.person1 = (Person)it.next();
        this.person2 = (Person)it.next();
        this.person3 = (Person)it.next();
    }

    protected void tearDown() throws Exception {
        this.ridget = null;
        this.table = null;
        this.shell.dispose();
        this.shell = null;
        super.tearDown();
    }

    public void testCheckStateChanged() throws Exception {
        String[] properties1 = new String[]{"hasCat", "firstname"};
        String[] headers1 = new String[]{"Cat", "First Name"};
        this.ridget.bindToModel((Object)this.manager, "persons", Person.class, properties1, headers1);
        TableRidgetTableViewer viewer = new TableRidgetTableViewer(this.ridget);
        Object listener = ReflectionUtils.newInstanceHidden((String)"org.eclipse.riena.internal.ui.ridgets.swt.TableRidgetTableViewer$TableRidgetCheckStateListener", (Object[])new Object[]{this.ridget});
        TableRidgetTableViewerTest.assertTrue((boolean)this.person1.isHasCat());
        CheckStateChangedEvent event = new CheckStateChangedEvent((ICheckable)viewer, (Object)this.person1, true);
        ReflectionUtils.invokeHidden((Object)listener, (String)"checkStateChanged", (Object[])new Object[]{event});
        TableRidgetTableViewerTest.assertTrue((boolean)this.person1.isHasCat());
        event = new CheckStateChangedEvent((ICheckable)viewer, (Object)this.person1, false);
        ReflectionUtils.invokeHidden((Object)listener, (String)"checkStateChanged", (Object[])new Object[]{event});
        TableRidgetTableViewerTest.assertFalse((boolean)this.person1.isHasCat());
        TableRidgetTableViewerTest.assertFalse((boolean)this.person2.isHasCat());
        event = new CheckStateChangedEvent((ICheckable)viewer, (Object)this.person2, true);
        ReflectionUtils.invokeHidden((Object)listener, (String)"checkStateChanged", (Object[])new Object[]{event});
        TableRidgetTableViewerTest.assertTrue((boolean)this.person2.isHasCat());
    }

    private Collection<Person> createPersonList() {
        ArrayList<Person> newList = new ArrayList<Person>();
        Person person = new Person("Doe", "John");
        person.setHasCat(true);
        newList.add(person);
        person = new Person("Jackson", "Janet");
        person.setHasCat(false);
        newList.add(person);
        person = new Person("Jackson", "Jermaine");
        person.setHasCat(true);
        newList.add(person);
        return newList;
    }
}

