/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.databinding;

import junit.framework.TestCase;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.riena.core.test.collect.NonUITestCase;
import org.eclipse.riena.ui.ridgets.databinding.StringToUpperCaseConverter;

@NonUITestCase
public class StringToUpperCaseConverterTest
extends TestCase {
    private IConverter converter;

    protected void setUp() throws Exception {
        this.converter = new StringToUpperCaseConverter();
    }

    public void testStringToUpperCase() {
        StringToUpperCaseConverterTest.assertEquals((Object)"ABCD", (Object)this.converter.convert((Object)"abcd"));
        StringToUpperCaseConverterTest.assertEquals((Object)"HELLO_WORLD!", (Object)this.converter.convert((Object)"Hello_World!"));
        StringToUpperCaseConverterTest.assertEquals((Object)"\u00c4\u00d6\u00dc\u00df", (Object)this.converter.convert((Object)"\u00e4\u00f6\u00fc\u00df"));
        StringToUpperCaseConverterTest.assertEquals((Object)"1337", (Object)this.converter.convert((Object)"1337"));
        StringToUpperCaseConverterTest.assertEquals((Object)"\t\r\n", (Object)this.converter.convert((Object)"\t\r\n"));
    }

    public void testNullToUpperCase() {
        StringToUpperCaseConverterTest.assertEquals(null, (Object)this.converter.convert(null));
    }

    public void testWrongType() {
        try {
            this.converter.convert((Object)1337);
            StringToUpperCaseConverterTest.fail();
        }
        catch (RuntimeException runtimeException) {}
    }
}

